/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_1263;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1735;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2586;
import net.minecraft.class_2588;
import net.minecraft.class_2614;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_5250;
import net.minecraft.class_5536;
import net.minecraft.class_5630;
import vazkii.botania.api.item.IBlockProvider;
import vazkii.botania.client.core.handler.ItemsRemainingRenderHandler;
import vazkii.botania.common.core.handler.ModSounds;
import vazkii.botania.common.core.helper.ItemNBTHelper;
import vazkii.botania.common.core.helper.PlayerHelper;

public class ItemBlackHoleTalisman
extends class_1792 {
    public static final String TAG_ACTIVE = "active";
    private static final String TAG_BLOCK_NAME = "blockName";
    private static final String TAG_BLOCK_COUNT = "blockCount";

    public ItemBlackHoleTalisman(class_1792.class_1793 props) {
        super(props);
        IBlockProvider.API.registerForItems((stack, c) -> new BlockProvider(stack), new class_1935[]{this});
    }

    @Nonnull
    public class_1271<class_1799> method_7836(class_1937 world, class_1657 player, @Nonnull class_1268 hand) {
        class_1799 stack = player.method_5998(hand);
        if (ItemBlackHoleTalisman.getBlock(stack) != null && player.method_5715()) {
            ItemNBTHelper.setBoolean(stack, TAG_ACTIVE, !ItemNBTHelper.getBoolean(stack, TAG_ACTIVE, false));
            player.method_5783(ModSounds.blackHoleTalismanConfigure, 1.0f, 1.0f);
            return class_1271.method_22427((Object)stack);
        }
        return class_1271.method_22430((Object)stack);
    }

    @Nonnull
    public class_1269 method_7884(class_1838 ctx) {
        class_1799 toUse;
        class_1269 result;
        class_1937 world = ctx.method_8045();
        class_2338 pos = ctx.method_8037();
        class_2350 side = ctx.method_8038();
        class_1657 player = ctx.method_8036();
        class_2680 state = world.method_8320(pos);
        class_1799 stack = ctx.method_8041();
        if (!state.method_26215() && ItemBlackHoleTalisman.setBlock(stack, state.method_26204())) {
            return class_1269.field_5812;
        }
        class_2248 bBlock = ItemBlackHoleTalisman.getBlock(stack);
        if (bBlock == null) {
            return class_1269.field_5811;
        }
        class_2586 tile = world.method_8321(pos);
        if (tile instanceof class_1263) {
            if (!world.field_9236) {
                class_1799 toAdd = new class_1799((class_1935)bBlock);
                int maxSize = toAdd.method_7914();
                toAdd.method_7939(ItemBlackHoleTalisman.remove(stack, maxSize));
                class_1799 remainder = class_2614.method_11260(null, (class_1263)((class_1263)tile), (class_1799)toAdd, (class_2350)side);
                if (!remainder.method_7960()) {
                    ItemBlackHoleTalisman.add(stack, remainder.method_7947());
                }
            }
            return class_1269.field_5812;
        }
        if ((player == null || player.method_31549().field_7477 || ItemBlackHoleTalisman.getBlockCount(stack) > 0) && (result = PlayerHelper.substituteUse(ctx, toUse = new class_1799((class_1935)bBlock))).method_23665()) {
            if (!world.field_9236) {
                ItemBlackHoleTalisman.remove(stack, 1);
                ItemsRemainingRenderHandler.send(player, toUse, ItemBlackHoleTalisman.getBlockCount(stack));
            }
            return result;
        }
        return class_1269.field_5811;
    }

    public void method_7888(class_1799 itemstack, class_1937 world, class_1297 entity, int slot, boolean selected) {
        class_2248 block = ItemBlackHoleTalisman.getBlock(itemstack);
        if (!entity.field_6002.field_9236 && ItemNBTHelper.getBoolean(itemstack, TAG_ACTIVE, false) && block != null && entity instanceof class_1657) {
            int i;
            class_1657 player = (class_1657)entity;
            int highest = -1;
            int[] counts = new int[player.method_31548().method_5439() - player.method_31548().field_7548.size()];
            for (i = 0; i < counts.length; ++i) {
                class_1799 stack = player.method_31548().method_5438(i);
                if (stack.method_7960() || block.method_8389() != stack.method_7909()) continue;
                counts[i] = stack.method_7947();
                highest = highest == -1 ? i : (counts[i] > counts[highest] && highest > 8 ? i : highest);
            }
            if (highest != -1) {
                for (i = 0; i < counts.length; ++i) {
                    int count = counts[i];
                    if (count == 0) continue;
                    ItemBlackHoleTalisman.add(itemstack, count);
                    player.method_31548().method_5447(i, class_1799.field_8037);
                }
            }
        }
    }

    @Nonnull
    public class_2561 method_7864(@Nonnull class_1799 stack) {
        class_2248 block = ItemBlackHoleTalisman.getBlock(stack);
        class_1799 bstack = new class_1799((class_1935)block);
        class_5250 cand = super.method_7864(stack).method_27661();
        if (!bstack.method_7960()) {
            cand.method_27693(" (");
            cand.method_10852((class_2561)bstack.method_7964().method_27661().method_27692(class_124.field_1060));
            cand.method_27693(")");
        }
        return cand;
    }

    private static boolean setBlock(class_1799 stack, class_2248 block) {
        if (block.method_8389() != class_1802.field_8162 && (ItemBlackHoleTalisman.getBlock(stack) == null || ItemBlackHoleTalisman.getBlockCount(stack) == 0)) {
            ItemNBTHelper.setString(stack, TAG_BLOCK_NAME, class_2378.field_11146.method_10221((Object)block).toString());
            return true;
        }
        return false;
    }

    private static void add(class_1799 stack, int count) {
        int current = ItemBlackHoleTalisman.getBlockCount(stack);
        ItemBlackHoleTalisman.setCount(stack, current + count);
    }

    @Environment(value=EnvType.CLIENT)
    public void method_7851(class_1799 stack, class_1937 world, List<class_2561> stacks, class_1836 flags) {
        class_2248 block = ItemBlackHoleTalisman.getBlock(stack);
        if (block != null) {
            int count = ItemBlackHoleTalisman.getBlockCount(stack);
            stacks.add((class_2561)new class_2585(count + " ").method_10852(new class_1799((class_1935)block).method_7964()).method_27692(class_124.field_1080));
        }
        if (ItemNBTHelper.getBoolean(stack, TAG_ACTIVE, false)) {
            stacks.add((class_2561)new class_2588("botaniamisc.active"));
        } else {
            stacks.add((class_2561)new class_2588("botaniamisc.inactive"));
        }
    }

    private static void setCount(class_1799 stack, int count) {
        ItemNBTHelper.setInt(stack, TAG_BLOCK_COUNT, count);
    }

    public static int remove(class_1799 stack, int count) {
        int current = ItemBlackHoleTalisman.getBlockCount(stack);
        ItemBlackHoleTalisman.setCount(stack, Math.max(current - count, 0));
        return Math.min(current, count);
    }

    private static String getBlockName(class_1799 stack) {
        return ItemNBTHelper.getString(stack, TAG_BLOCK_NAME, "");
    }

    @Nullable
    public static class_2248 getBlock(class_1799 stack) {
        class_2960 id = class_2960.method_12829((String)ItemBlackHoleTalisman.getBlockName(stack));
        if (id != null) {
            return class_2378.field_11146.method_17966(id).orElse(null);
        }
        return null;
    }

    public static int getBlockCount(class_1799 stack) {
        return ItemNBTHelper.getInt(stack, TAG_BLOCK_COUNT, 0);
    }

    public boolean method_31565(@Nonnull class_1799 talisman, @Nonnull class_1735 slot, @Nonnull class_5536 clickAction, @Nonnull class_1657 player) {
        class_2248 existingBlock;
        class_1799 toInsert;
        class_2248 blockToInsert;
        if (clickAction == class_5536.field_27014 && (blockToInsert = class_2248.method_9503((class_1792)(toInsert = slot.method_7677()).method_7909())) != class_2246.field_10124 && ((existingBlock = ItemBlackHoleTalisman.getBlock(talisman)) == null || existingBlock == blockToInsert)) {
            class_1799 taken = slot.method_32753(toInsert.method_7947(), Integer.MAX_VALUE, player);
            if (existingBlock == null) {
                ItemBlackHoleTalisman.setBlock(talisman, blockToInsert);
                ItemBlackHoleTalisman.setCount(talisman, taken.method_7947());
            } else {
                ItemBlackHoleTalisman.add(talisman, taken.method_7947());
            }
            return true;
        }
        return false;
    }

    public boolean method_31566(@Nonnull class_1799 talisman, @Nonnull class_1799 toInsert, @Nonnull class_1735 slot, @Nonnull class_5536 clickAction, @Nonnull class_1657 player, @Nonnull class_5630 cursorAccess) {
        class_2248 existingBlock;
        class_2248 blockToInsert;
        if (clickAction == class_5536.field_27014 && (blockToInsert = class_2248.method_9503((class_1792)toInsert.method_7909())) != class_2246.field_10124 && ((existingBlock = ItemBlackHoleTalisman.getBlock(talisman)) == null || existingBlock == blockToInsert)) {
            if (existingBlock == null) {
                ItemBlackHoleTalisman.setBlock(talisman, blockToInsert);
                ItemBlackHoleTalisman.setCount(talisman, toInsert.method_7947());
            } else {
                ItemBlackHoleTalisman.add(talisman, toInsert.method_7947());
            }
            cursorAccess.method_32332(class_1799.field_8037);
            return true;
        }
        return false;
    }

    protected static class BlockProvider
    implements IBlockProvider {
        private final class_1799 stack;

        protected BlockProvider(class_1799 stack) {
            this.stack = stack;
        }

        @Override
        public boolean provideBlock(class_1657 player, class_1799 requestor, class_2248 block, boolean doit) {
            int count;
            class_2248 stored = ItemBlackHoleTalisman.getBlock(this.stack);
            if (stored == block && (count = ItemBlackHoleTalisman.getBlockCount(this.stack)) > 0) {
                if (doit) {
                    ItemBlackHoleTalisman.setCount(this.stack, count - 1);
                }
                return true;
            }
            return false;
        }

        @Override
        public int getBlockCount(class_1657 player, class_1799 requestor, class_2248 block) {
            class_2248 stored = ItemBlackHoleTalisman.getBlock(this.stack);
            if (stored == block) {
                return ItemBlackHoleTalisman.getBlockCount(this.stack);
            }
            return 0;
        }
    }
}

