/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.equipment.armor.terrasteel;

import com.google.common.base.Suppliers;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import java.util.UUID;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_310;
import net.minecraft.class_5134;
import net.minecraft.class_5250;
import net.minecraft.class_5599;
import net.minecraft.class_572;
import net.minecraft.class_630;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.client.model.ModModelLayers;
import vazkii.botania.client.model.armor.ModelArmor;
import vazkii.botania.common.item.ModItems;
import vazkii.botania.common.item.equipment.armor.manasteel.ItemManasteelArmor;

public class ItemTerrasteelArmor
extends ItemManasteelArmor {
    private static final Supplier<class_1799[]> armorSet = Suppliers.memoize(() -> new class_1799[]{new class_1799((class_1935)ModItems.terrasteelHelm), new class_1799((class_1935)ModItems.terrasteelChest), new class_1799((class_1935)ModItems.terrasteelLegs), new class_1799((class_1935)ModItems.terrasteelBoots)});

    public ItemTerrasteelArmor(class_1304 type, class_1792.class_1793 props) {
        super(type, BotaniaAPI.instance().getTerrasteelArmorMaterial(), props);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    protected class_572<class_1309> provideArmorModelForSlot(class_1304 slot) {
        class_5599 entityModels = class_310.method_1551().method_31974();
        class_630 root = entityModels.method_32072(slot == class_1304.field_6172 ? ModModelLayers.TERRASTEEL_INNER_ARMOR : ModModelLayers.TERRASTEEL_OUTER_ARMOR);
        return new ModelArmor(root, slot);
    }

    @Override
    public String getArmorTextureAfterInk(class_1799 stack, class_1304 slot) {
        return "botania:textures/model/armor_terrasteel.png";
    }

    @Nonnull
    public Multimap<class_1320, class_1322> method_7844(@Nonnull class_1304 slot) {
        Multimap ret = super.method_7844(slot);
        UUID uuid = new UUID(class_2378.field_11142.method_10221((Object)this).hashCode() + slot.toString().hashCode(), 0L);
        if (slot == this.method_7685()) {
            ret = HashMultimap.create((Multimap)ret);
            int reduction = this.method_7686().method_7697(slot);
            ret.put((Object)class_5134.field_23718, (Object)new class_1322(uuid, "Terrasteel modifier " + this.type, (double)reduction / 20.0, class_1322.class_1323.field_6328));
        }
        return ret;
    }

    @Override
    public class_1799[] getArmorSetStacks() {
        return armorSet.get();
    }

    @Override
    public boolean hasArmorSetItem(class_1657 player, class_1304 slot) {
        if (player == null) {
            return false;
        }
        class_1799 stack = player.method_6118(slot);
        if (stack.method_7960()) {
            return false;
        }
        return switch (slot) {
            case class_1304.field_6169 -> stack.method_31574(ModItems.terrasteelHelm);
            case class_1304.field_6174 -> stack.method_31574(ModItems.terrasteelChest);
            case class_1304.field_6172 -> stack.method_31574(ModItems.terrasteelLegs);
            case class_1304.field_6166 -> stack.method_31574(ModItems.terrasteelBoots);
            default -> false;
        };
    }

    @Override
    public class_5250 getArmorSetName() {
        return new class_2588("botania.armorset.terrasteel.name");
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void addArmorSetDescription(class_1799 stack, List<class_2561> list) {
        list.add((class_2561)new class_2588("botania.armorset.terrasteel.desc0").method_27692(class_124.field_1080));
        list.add((class_2561)new class_2588("botania.armorset.terrasteel.desc1").method_27692(class_124.field_1080));
        list.add((class_2561)new class_2588("botania.armorset.terrasteel.desc2").method_27692(class_124.field_1080));
    }
}

