/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.equipment.bauble;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import java.util.UUID;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_3222;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_572;
import vazkii.botania.api.item.ICosmeticAttachable;
import vazkii.botania.api.item.IPhantomInkable;
import vazkii.botania.common.core.handler.ConfigHandler;
import vazkii.botania.common.core.handler.EquipmentHandler;
import vazkii.botania.common.core.helper.ItemNBTHelper;
import vazkii.botania.common.core.helper.PlayerHelper;
import vazkii.botania.common.lib.ResourceLocationHelper;

public abstract class ItemBauble
extends class_1792
implements ICosmeticAttachable,
IPhantomInkable {
    private static final String TAG_BAUBLE_UUID = "baubleUUID";
    private static final String TAG_COSMETIC_ITEM = "cosmeticItem";
    private static final String TAG_PHANTOM_INK = "phantomInk";

    public ItemBauble(class_1792.class_1793 props) {
        super(props);
        EquipmentHandler.initBaubleCap(this);
    }

    @Environment(value=EnvType.CLIENT)
    public void method_7851(class_1799 stack, class_1937 world, List<class_2561> tooltip, class_1836 flags) {
        class_1799 cosmetic = this.getCosmeticItem(stack);
        if (!cosmetic.method_7960()) {
            tooltip.add((class_2561)new class_2588("botaniamisc.hasCosmetic", new Object[]{cosmetic.method_7964()}).method_27695(new class_124[]{class_124.field_1080, class_124.field_1056}));
        }
        if (this.hasPhantomInk(stack)) {
            tooltip.add((class_2561)new class_2588("botaniamisc.hasPhantomInk").method_27692(class_124.field_1075));
        }
    }

    @Override
    public class_1799 getCosmeticItem(class_1799 stack) {
        class_2487 cmp = ItemNBTHelper.getCompound(stack, TAG_COSMETIC_ITEM, true);
        if (cmp == null) {
            return class_1799.field_8037;
        }
        return class_1799.method_7915((class_2487)cmp);
    }

    @Override
    public void setCosmeticItem(class_1799 stack, class_1799 cosmetic) {
        class_2487 cmp = new class_2487();
        if (!cosmetic.method_7960()) {
            cmp = cosmetic.method_7953(cmp);
        }
        ItemNBTHelper.setCompound(stack, TAG_COSMETIC_ITEM, cmp);
    }

    public static UUID getBaubleUUID(class_1799 stack) {
        UUID uuid;
        class_2487 tag = stack.method_7948();
        String tagBaubleUuidMostLegacy = "baubleUUIDMost";
        String tagBaubleUuidLeastLegacy = "baubleUUIDLeast";
        if (tag.method_10545(tagBaubleUuidMostLegacy) && tag.method_10545(tagBaubleUuidLeastLegacy)) {
            uuid = new UUID(tag.method_10537(tagBaubleUuidMostLegacy), tag.method_10537(tagBaubleUuidLeastLegacy));
            tag.method_25927(TAG_BAUBLE_UUID, uuid);
        }
        if (!tag.method_25928(TAG_BAUBLE_UUID)) {
            uuid = UUID.randomUUID();
            tag.method_25927(TAG_BAUBLE_UUID, uuid);
        }
        return tag.method_25926(TAG_BAUBLE_UUID);
    }

    @Override
    public boolean hasPhantomInk(class_1799 stack) {
        return ItemNBTHelper.getBoolean(stack, TAG_PHANTOM_INK, false);
    }

    @Override
    public void setPhantomInk(class_1799 stack, boolean ink) {
        ItemNBTHelper.setBoolean(stack, TAG_PHANTOM_INK, ink);
    }

    public void onWornTick(class_1799 stack, class_1309 entity) {
    }

    public void onEquipped(class_1799 stack, class_1309 entity) {
        if (!entity.field_6002.field_9236 && entity instanceof class_3222) {
            PlayerHelper.grantCriterion((class_3222)entity, ResourceLocationHelper.prefix("main/bauble_wear"), "code_triggered");
        }
    }

    public void onUnequipped(class_1799 stack, class_1309 entity) {
    }

    public boolean canEquip(class_1799 stack, class_1309 entity) {
        return true;
    }

    public Multimap<class_1320, class_1322> getEquippedAttributeModifiers(class_1799 stack) {
        return HashMultimap.create();
    }

    public boolean hasRender(class_1799 stack, class_1309 living) {
        return !this.hasPhantomInk(stack) && (Boolean)ConfigHandler.CLIENT.renderAccessories.getValue() != false && !living.method_5767();
    }

    @Environment(value=EnvType.CLIENT)
    public void doRender(class_572<?> bipedModel, class_1799 stack, class_1309 player, class_4587 ms, class_4597 buffers, int light, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
    }
}

