/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.network;

import io.netty.buffer.Unpooled;
import java.util.Random;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1767;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2540;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import net.minecraft.class_634;
import net.minecraft.class_638;
import vazkii.botania.client.fx.SparkleParticleData;
import vazkii.botania.client.fx.WispParticleData;
import vazkii.botania.common.Botania;
import vazkii.botania.common.block.tile.TileTerraPlate;
import vazkii.botania.common.core.helper.ColorHelper;
import vazkii.botania.common.core.helper.VecHelper;
import vazkii.botania.common.item.ItemTwigWand;
import vazkii.botania.common.lib.ResourceLocationHelper;

public class PacketBotaniaEffect {
    public static final class_2960 ID = ResourceLocationHelper.prefix("eff");

    public static void send(class_1657 player, EffectType type, double x, double y, double z, int ... args) {
        if (player instanceof class_3222) {
            ((class_3222)player).field_13987.method_14364(PacketBotaniaEffect.make(type, x, y, z, args));
        }
    }

    public static void sendNearby(class_1297 e, EffectType type, double x, double y, double z, int ... args) {
        if (!e.field_6002.field_9236) {
            class_2596<?> pkt = PacketBotaniaEffect.make(type, x, y, z, args);
            PlayerLookup.tracking((class_1297)e).stream().filter(p -> p.method_5707(e.method_19538()) < 4096.0).forEach(p -> p.field_13987.method_14364(pkt));
            if (e instanceof class_3222) {
                ((class_3222)e).field_13987.method_14364(pkt);
            }
        }
    }

    public static void sendNearby(class_1937 world, class_2338 pos, EffectType type, double x, double y, double z, int ... args) {
        if (world instanceof class_3218) {
            class_2596<?> pkt = PacketBotaniaEffect.make(type, x, y, z, args);
            PlayerLookup.tracking((class_3218)((class_3218)world), (class_2338)pos).stream().filter(p -> p.method_5649((double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260()) < 4096.0).forEach(p -> p.field_13987.method_14364(pkt));
        }
    }

    public static class_2596<?> make(EffectType type, double x, double y, double z, int ... args) {
        class_2540 buf = new class_2540(Unpooled.buffer());
        buf.writeByte(type.ordinal());
        buf.writeDouble(x);
        buf.writeDouble(y);
        buf.writeDouble(z);
        for (int i = 0; i < type.argCount; ++i) {
            buf.method_10804(args[i]);
        }
        return ServerPlayNetworking.createS2CPacket((class_2960)ID, (class_2540)buf);
    }

    public static enum EffectType {
        PAINT_LENS(1),
        ARENA_INDICATOR(0),
        ITEM_SMOKE(2),
        SPARK_NET_INDICATOR(2),
        SPARK_MANA_FLOW(3),
        ENCHANTER_DESTROY(0),
        BLACK_LOTUS_DISSOLVE(0),
        TERRA_PLATE(1),
        FLUGEL_EFFECT(1),
        PARTICLE_BEAM(3),
        DIVA_EFFECT(1),
        HALO_CRAFT(1),
        AVATAR_TORNADO_JUMP(1),
        AVATAR_TORNADO_BOOST(1);

        private final int argCount;

        private EffectType(int argCount) {
            this.argCount = argCount;
        }
    }

    public static class Handler {
        public static void handle(class_310 client, class_634 handler, class_2540 buf, PacketSender responseSender) {
            final EffectType type = EffectType.values()[buf.readByte()];
            final double x = buf.readDouble();
            final double y = buf.readDouble();
            final double z = buf.readDouble();
            final int[] args = new int[type.argCount];
            for (int i = 0; i < args.length; ++i) {
                args[i] = buf.method_10816();
            }
            client.execute(new Runnable(){

                @Override
                public void run() {
                    class_310 mc = class_310.method_1551();
                    class_638 world = mc.field_1687;
                    switch (type) {
                        case PAINT_LENS: {
                            class_1767 placeColor = class_1767.method_7791((int)args[0]);
                            int hex = ColorHelper.getColorValue(placeColor);
                            int r = (hex & 0xFF0000) >> 16;
                            int g = (hex & 0xFF00) >> 8;
                            int b = hex & 0xFF;
                            for (int i = 0; i < 10; ++i) {
                                class_2338 pos = new class_2338(x, y, z).method_10093(class_2350.method_10162((Random)world.field_9229));
                                SparkleParticleData data = SparkleParticleData.sparkle(0.6f + (float)Math.random() * 0.5f, (float)r / 255.0f, (float)g / 255.0f, (float)b / 255.0f, 5);
                                world.method_8406((class_2394)data, (double)((float)pos.method_10263() + (float)Math.random()), (double)((float)pos.method_10264() + (float)Math.random()), (double)((float)pos.method_10260() + (float)Math.random()), 0.0, 0.0, 0.0);
                            }
                            break;
                        }
                        case ARENA_INDICATOR: {
                            SparkleParticleData data = SparkleParticleData.sparkle(5.0f, 1.0f, 0.0f, 1.0f, 120);
                            for (int i = 0; i < 360; i += 8) {
                                float rad = (float)i * (float)Math.PI / 180.0f;
                                double wx = x + 0.5 - Math.cos(rad) * 12.0;
                                double wy = y + 0.5;
                                double wz = z + 0.5 - Math.sin(rad) * 12.0;
                                Botania.proxy.addParticleForceNear((class_1937)world, data, wx, wy, wz, 0.0, 0.0, 0.0);
                            }
                            break;
                        }
                        case ITEM_SMOKE: {
                            class_1297 item = world.method_8469(args[0]);
                            if (item == null) {
                                return;
                            }
                            int p = args[1];
                            for (int i = 0; i < p; ++i) {
                                double m = 0.01;
                                double d0 = item.field_6002.field_9229.nextGaussian() * m;
                                double d1 = item.field_6002.field_9229.nextGaussian() * m;
                                double d2 = item.field_6002.field_9229.nextGaussian() * m;
                                double d3 = 10.0;
                                item.field_6002.method_8406((class_2394)class_2398.field_11203, x + (double)(item.field_6002.field_9229.nextFloat() * item.method_17681() * 2.0f) - (double)item.method_17681() - d0 * d3, y + (double)(item.field_6002.field_9229.nextFloat() * item.method_17682()) - d1 * d3, z + (double)(item.field_6002.field_9229.nextFloat() * item.method_17681() * 2.0f) - (double)item.method_17681() - d2 * d3, d0, d1, d2);
                            }
                            break;
                        }
                        case SPARK_NET_INDICATOR: {
                            class_1297 e1 = world.method_8469(args[0]);
                            class_1297 e2 = world.method_8469(args[1]);
                            if (e1 == null || e2 == null) {
                                return;
                            }
                            class_243 orig = new class_243(e1.method_23317(), e1.method_23318() + 0.25, e1.method_23321());
                            class_243 end = new class_243(e2.method_23317(), e2.method_23318() + 0.25, e2.method_23321());
                            class_243 diff = end.method_1020(orig);
                            class_243 movement = diff.method_1029().method_1021(0.1);
                            int iters = (int)(diff.method_1033() / movement.method_1033());
                            float huePer = 1.0f / (float)iters;
                            float hueSum = (float)Math.random();
                            class_243 currentPos = orig;
                            for (int i = 0; i < iters; ++i) {
                                float hue = (float)i * huePer + hueSum;
                                int color = class_3532.method_15369((float)class_3532.method_22450((float)hue), (float)1.0f, (float)1.0f);
                                float r = Math.min(1.0f, (float)(color >> 16 & 0xFF) / 255.0f + 0.4f);
                                float g = Math.min(1.0f, (float)(color >> 8 & 0xFF) / 255.0f + 0.4f);
                                float b = Math.min(1.0f, (float)(color & 0xFF) / 255.0f + 0.4f);
                                SparkleParticleData data = SparkleParticleData.noClip(1.0f, r, g, b, 12);
                                world.method_17452((class_2394)data, true, currentPos.field_1352, currentPos.field_1351, currentPos.field_1350, 0.0, 0.0, 0.0);
                                currentPos = currentPos.method_1019(movement);
                            }
                            break;
                        }
                        case SPARK_MANA_FLOW: {
                            class_1297 e1 = world.method_8469(args[0]);
                            class_1297 e2 = world.method_8469(args[1]);
                            if (e1 == null || e2 == null) {
                                return;
                            }
                            double rc = 0.45;
                            class_243 thisVec = VecHelper.fromEntityCenter(e1).method_1031((Math.random() - 0.5) * rc, (Math.random() - 0.5) * rc, (Math.random() - 0.5) * rc);
                            class_243 receiverVec = VecHelper.fromEntityCenter(e2).method_1031((Math.random() - 0.5) * rc, (Math.random() - 0.5) * rc, (Math.random() - 0.5) * rc);
                            class_243 motion = receiverVec.method_1020(thisVec).method_1021((double)0.04f);
                            int color = args[2];
                            float r = (float)(color >> 16 & 0xFF) / 255.0f;
                            float g = (float)(color >> 8 & 0xFF) / 255.0f;
                            float b = (float)(color & 0xFF) / 255.0f;
                            if ((double)world.field_9229.nextFloat() < 0.25) {
                                r += 0.2f * (float)world.field_9229.nextGaussian();
                                g += 0.2f * (float)world.field_9229.nextGaussian();
                                b += 0.2f * (float)world.field_9229.nextGaussian();
                            }
                            float size = 0.125f + 0.125f * (float)Math.random();
                            WispParticleData data = WispParticleData.wisp(size, r, g, b).withNoClip(true);
                            world.method_8494((class_2394)data, thisVec.field_1352, thisVec.field_1351, thisVec.field_1350, motion.field_1352, motion.field_1351, motion.field_1350);
                            break;
                        }
                        case ENCHANTER_DESTROY: {
                            for (int i = 0; i < 50; ++i) {
                                float red = (float)Math.random();
                                float green = (float)Math.random();
                                float blue = (float)Math.random();
                                WispParticleData data = WispParticleData.wisp((float)Math.random() * 0.15f + 0.15f, red, green, blue);
                                world.method_8406((class_2394)data, x, y, z, (double)((float)(Math.random() - 0.5) * 0.25f), (double)((float)(Math.random() - 0.5) * 0.25f), (double)((float)(Math.random() - 0.5) * 0.25f));
                            }
                            break;
                        }
                        case BLACK_LOTUS_DISSOLVE: {
                            for (int i = 0; i < 50; ++i) {
                                float r = (float)Math.random() * 0.35f;
                                float g = 0.0f;
                                float b = (float)Math.random() * 0.35f;
                                float s = 0.45f * (float)Math.random() * 0.25f;
                                float m = 0.045f;
                                float mx = ((float)Math.random() - 0.5f) * m;
                                float my = (float)Math.random() * m;
                                float mz = ((float)Math.random() - 0.5f) * m;
                                WispParticleData data = WispParticleData.wisp(s, r, g, b);
                                world.method_8406((class_2394)data, x, y, z, (double)mx, (double)my, (double)mz);
                            }
                            break;
                        }
                        case TERRA_PLATE: {
                            class_2586 te = world.method_8321(new class_2338(x, y, z));
                            if (!(te instanceof TileTerraPlate)) break;
                            float percentage = Float.intBitsToFloat(args[0]);
                            int ticks = (int)(100.0 * (double)percentage);
                            int totalSpiritCount = 3;
                            double tickIncrement = 360.0 / (double)totalSpiritCount;
                            int speed = 5;
                            double wticks = (double)(ticks * speed) - tickIncrement;
                            double r = Math.sin((double)(ticks - 100) / 10.0) * 2.0;
                            double g = Math.sin(wticks * Math.PI / 180.0 * 0.55);
                            for (int i = 0; i < totalSpiritCount; ++i) {
                                double wx = x + Math.sin(wticks * Math.PI / 180.0) * r + 0.5;
                                double wy = y + 0.25 + Math.abs(r) * 0.7;
                                double wz = z + Math.cos(wticks * Math.PI / 180.0) * r + 0.5;
                                wticks += tickIncrement;
                                float[] colorsfx = new float[]{0.0f, (float)ticks / 100.0f, 1.0f - (float)ticks / 100.0f};
                                WispParticleData data = WispParticleData.wisp(0.85f, colorsfx[0], colorsfx[1], colorsfx[2], 0.25f);
                                Botania.proxy.addParticleForceNear((class_1937)world, data, wx, wy, wz, 0.0, (float)(-g * 0.05), 0.0);
                                data = WispParticleData.wisp((float)Math.random() * 0.1f + 0.1f, colorsfx[0], colorsfx[1], colorsfx[2], 0.9f);
                                world.method_8406((class_2394)data, wx, wy, wz, (double)((float)(Math.random() - 0.5) * 0.05f), (double)((float)(Math.random() - 0.5) * 0.05f), (double)((float)(Math.random() - 0.5) * 0.05f));
                                if (ticks != 100) continue;
                                for (int j = 0; j < 15; ++j) {
                                    data = WispParticleData.wisp((float)Math.random() * 0.15f + 0.15f, colorsfx[0], colorsfx[1], colorsfx[2]);
                                    world.method_8406((class_2394)data, x + 0.5, y + 0.5, z + 0.5, (double)((float)(Math.random() - 0.5) * 0.125f), (double)((float)(Math.random() - 0.5) * 0.125f), (double)((float)(Math.random() - 0.5) * 0.125f));
                                }
                            }
                            break;
                        }
                        case FLUGEL_EFFECT: {
                            class_1297 entity = world.method_8469(args[0]);
                            if (entity == null) break;
                            for (int i = 0; i < 15; ++i) {
                                float x2 = (float)(entity.method_23317() + Math.random());
                                float y2 = (float)(entity.method_23318() + Math.random());
                                float z2 = (float)(entity.method_23321() + Math.random());
                                WispParticleData data = WispParticleData.wisp((float)Math.random(), (float)Math.random(), (float)Math.random(), (float)Math.random(), 1.0f);
                                world.method_8406((class_2394)data, (double)x2, (double)y2, (double)z2, 0.0, (double)(-(-0.3f + (float)Math.random() * 0.2f)), 0.0);
                            }
                            break;
                        }
                        case PARTICLE_BEAM: {
                            ItemTwigWand.doParticleBeam((class_1937)class_310.method_1551().field_1687, new class_243(x, y, z), new class_243((double)args[0] + 0.5, (double)args[1] + 0.5, (double)args[2] + 0.5));
                            break;
                        }
                        case DIVA_EFFECT: {
                            class_1297 target = class_310.method_1551().field_1687.method_8469(args[0]);
                            if (target == null) break;
                            double x3 = target.method_23317();
                            double y3 = target.method_23318();
                            double z3 = target.method_23321();
                            SparkleParticleData data = SparkleParticleData.sparkle(1.0f, 1.0f, 1.0f, 0.25f, 3);
                            for (int i = 0; i < 50; ++i) {
                                world.method_8406((class_2394)data, x3 + Math.random() * (double)target.method_17681(), y3 + Math.random() * (double)target.method_17682(), z3 + Math.random() * (double)target.method_17681(), 0.0, 0.0, 0.0);
                            }
                            break;
                        }
                        case HALO_CRAFT: {
                            class_1297 target = class_310.method_1551().field_1687.method_8469(args[0]);
                            if (target == null) break;
                            class_243 lookVec3 = target.method_5720();
                            class_243 centerVector = VecHelper.fromEntityCenter(target).method_1031(lookVec3.field_1352 * 3.0, 1.3, lookVec3.field_1350 * 3.0);
                            float m = 0.1f;
                            for (int i = 0; i < 4; ++i) {
                                WispParticleData data = WispParticleData.wisp(0.2f + 0.2f * (float)Math.random(), 1.0f, 0.0f, 1.0f);
                                target.field_6002.method_8406((class_2394)data, centerVector.field_1352, centerVector.field_1351, centerVector.field_1350, (double)(((float)Math.random() - 0.5f) * m), (double)(((float)Math.random() - 0.5f) * m), (double)(((float)Math.random() - 0.5f) * m));
                            }
                            break;
                        }
                        case AVATAR_TORNADO_JUMP: {
                            class_1297 p = world.method_8469(args[0]);
                            if (p == null) break;
                            for (int i = 0; i < 20; ++i) {
                                for (int j = 0; j < 5; ++j) {
                                    WispParticleData data = WispParticleData.wisp(0.35f + (float)Math.random() * 0.1f, 0.25f, 0.25f, 0.25f);
                                    world.method_8406((class_2394)data, p.method_23317(), p.method_23318() + (double)i, p.method_23321(), (double)(0.2f * (float)(Math.random() - 0.5)), (double)(-0.01f * (float)Math.random()), (double)(0.2f * (float)(Math.random() - 0.5)));
                                }
                            }
                            break;
                        }
                        case AVATAR_TORNADO_BOOST: {
                            class_1297 p = world.method_8469(args[0]);
                            if (p == null) break;
                            class_243 lookDir = p.method_5720();
                            for (int i = 0; i < 20; ++i) {
                                for (int j = 0; j < 5; ++j) {
                                    WispParticleData data = WispParticleData.wisp(0.35f + (float)Math.random() * 0.1f, 0.25f, 0.25f, 0.25f);
                                    world.method_8406((class_2394)data, p.method_23317() + lookDir.method_10216() * (double)i, p.method_23318() + lookDir.method_10214() * (double)i, p.method_23321() + lookDir.method_10215() * (double)i, (double)(0.2f * (float)(Math.random() - 0.5)) * (Math.abs(lookDir.method_10214()) + Math.abs(lookDir.method_10215())) + (double)(-0.01f * (float)Math.random()) * lookDir.method_10216(), (double)(0.2f * (float)(Math.random() - 0.5)) * (Math.abs(lookDir.method_10216()) + Math.abs(lookDir.method_10215())) + (double)(-0.01f * (float)Math.random()) * lookDir.method_10214(), (double)(0.2f * (float)(Math.random() - 0.5)) * (Math.abs(lookDir.method_10214()) + Math.abs(lookDir.method_10216())) + (double)(-0.01f * (float)Math.random()) * lookDir.method_10215());
                                }
                            }
                            break;
                        }
                    }
                }
            });
        }
    }
}

