/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.data;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_124;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2403;
import net.minecraft.class_2405;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_5250;
import vazkii.botania.common.Botania;
import vazkii.botania.data.AdvancementProvider;
import vazkii.botania.data.BlockLootProvider;
import vazkii.botania.data.BlockTagProvider;
import vazkii.botania.data.BlockstateProvider;
import vazkii.botania.data.EntityTagProvider;
import vazkii.botania.data.FloatingFlowerModelProvider;
import vazkii.botania.data.ItemModelProvider;
import vazkii.botania.data.ItemTagProvider;
import vazkii.botania.data.recipes.BrewProvider;
import vazkii.botania.data.recipes.ElvenTradeProvider;
import vazkii.botania.data.recipes.ManaInfusionProvider;
import vazkii.botania.data.recipes.OrechidProvider;
import vazkii.botania.data.recipes.PetalProvider;
import vazkii.botania.data.recipes.PureDaisyProvider;
import vazkii.botania.data.recipes.RecipeProvider;
import vazkii.botania.data.recipes.RuneProvider;
import vazkii.botania.data.recipes.SmeltingProvider;
import vazkii.botania.data.recipes.StonecuttingProvider;
import vazkii.botania.data.recipes.TerraPlateProvider;

public class DataGenerators {
    private static Path inferOutputPath() {
        return Paths.get("../src/generated/resources", new String[0]).toAbsolutePath().normalize();
    }

    public static void registerCommands(CommandDispatcher<class_2168> disp) {
        if (!FabricLoader.getInstance().isDevelopmentEnvironment()) {
            return;
        }
        LiteralArgumentBuilder command = (LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"botania_gendata").then(class_2170.method_9247((String)"confirm").executes(ctx -> {
            Path p = DataGenerators.inferOutputPath();
            ((class_2168)ctx.getSource()).method_9226((class_2561)new class_2585("Generating data into " + p + "..."), false);
            try {
                DataGenerators.gatherData(p);
                ((class_2168)ctx.getSource()).method_9226((class_2561)new class_2585("Done"), false);
                return 1;
            }
            catch (Exception e) {
                Botania.LOGGER.error("Failed to generate data", (Throwable)e);
                ((class_2168)ctx.getSource()).method_9213((class_2561)new class_2585("Failed to generate data, see logs"));
                return 0;
            }
        }))).executes(ctx -> {
            Path p = DataGenerators.inferOutputPath();
            class_5250 yes = new class_2585("[yes]").method_27694(s -> s.method_10977(class_124.field_1060).method_10958(new class_2558(class_2558.class_2559.field_11745, "/botania_gendata confirm")));
            class_5250 msg = new class_2585(String.format("Will generate data into [%s]. Ok? ", p)).method_10852((class_2561)yes);
            ((class_2168)ctx.getSource()).method_9226((class_2561)msg, false);
            return 1;
        });
        disp.register(command);
    }

    private static void gatherData(Path output) throws IOException {
        class_2403 generator = new class_2403(output, Collections.emptyList());
        DataGenerators.gatherData(generator);
        generator.method_10315();
    }

    static void gatherData(class_2403 generator) {
        generator.method_10314((class_2405)new BlockLootProvider(generator));
        BlockTagProvider blockTagProvider = new BlockTagProvider(generator);
        generator.method_10314((class_2405)blockTagProvider);
        generator.method_10314((class_2405)new ItemTagProvider(generator, blockTagProvider));
        generator.method_10314((class_2405)new EntityTagProvider(generator));
        generator.method_10314((class_2405)new StonecuttingProvider(generator));
        generator.method_10314((class_2405)new RecipeProvider(generator));
        generator.method_10314((class_2405)new SmeltingProvider(generator));
        generator.method_10314((class_2405)new ElvenTradeProvider(generator));
        generator.method_10314((class_2405)new ManaInfusionProvider(generator));
        generator.method_10314((class_2405)new PureDaisyProvider(generator));
        generator.method_10314((class_2405)new BrewProvider(generator));
        generator.method_10314((class_2405)new PetalProvider(generator));
        generator.method_10314((class_2405)new RuneProvider(generator));
        generator.method_10314((class_2405)new TerraPlateProvider(generator));
        generator.method_10314((class_2405)new OrechidProvider(generator));
        generator.method_10314((class_2405)new BlockstateProvider(generator));
        generator.method_10314((class_2405)new FloatingFlowerModelProvider(generator));
        generator.method_10314((class_2405)new ItemModelProvider(generator));
        generator.method_10314((class_2405)new AdvancementProvider(generator));
    }
}

