/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.data;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2389;
import net.minecraft.class_2403;
import net.minecraft.class_2405;
import net.minecraft.class_2408;
import net.minecraft.class_2544;
import net.minecraft.class_2960;
import net.minecraft.class_4940;
import net.minecraft.class_4941;
import net.minecraft.class_4942;
import net.minecraft.class_4943;
import net.minecraft.class_4944;
import net.minecraft.class_4945;
import vazkii.botania.common.Botania;
import vazkii.botania.common.block.BlockLightRelay;
import vazkii.botania.common.block.BlockModDoubleFlower;
import vazkii.botania.common.block.BlockModFlower;
import vazkii.botania.common.block.BlockSpecialFlower;
import vazkii.botania.common.block.ModBlocks;
import vazkii.botania.common.block.ModFluffBlocks;
import vazkii.botania.common.block.decor.BlockFloatingFlower;
import vazkii.botania.common.block.decor.BlockModMushroom;
import vazkii.botania.common.block.decor.BlockMotifFlower;
import vazkii.botania.common.block.decor.BlockPetalBlock;
import vazkii.botania.common.block.mana.BlockPool;
import vazkii.botania.common.block.mana.BlockSpreader;
import vazkii.botania.common.item.ModItems;
import vazkii.botania.common.item.lens.ItemLens;
import vazkii.botania.common.item.material.ItemPetal;
import vazkii.botania.common.lib.ResourceLocationHelper;
import vazkii.botania.data.BlockstateProvider;
import vazkii.botania.data.util.ModelWithOverrides;
import vazkii.botania.data.util.OverrideHolder;
import vazkii.botania.data.util.SimpleModelSupplierWithOverrides;
import vazkii.botania.mixin.AccessorTextureSlot;

public class ItemModelProvider
implements class_2405 {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private static final class_4945 LAYER1 = AccessorTextureSlot.make("layer1");
    private static final class_4945 LAYER2 = AccessorTextureSlot.make("layer2");
    private static final class_4945 LAYER3 = AccessorTextureSlot.make("layer3");
    private static final class_4942 GENERATED_1 = new class_4942(Optional.of(new class_2960("item/generated")), Optional.empty(), new class_4945[]{class_4945.field_23006, LAYER1});
    private static final class_4942 GENERATED_2 = new class_4942(Optional.of(new class_2960("item/generated")), Optional.empty(), new class_4945[]{class_4945.field_23006, LAYER1, LAYER2});
    private static final class_4942 HANDHELD_1 = new class_4942(Optional.of(new class_2960("item/handheld")), Optional.empty(), new class_4945[]{class_4945.field_23006, LAYER1});
    private static final class_4942 HANDHELD_3 = new class_4942(Optional.of(new class_2960("item/handheld")), Optional.empty(), new class_4945[]{class_4945.field_23006, LAYER1, LAYER2, LAYER3});
    private static final class_4945 MATERIAL = AccessorTextureSlot.make("material");
    private static final class_4945 INSIDE = AccessorTextureSlot.make("inside");
    private static final class_4942 SPREADER = new class_4942(Optional.of(ResourceLocationHelper.prefix("block/shapes/spreader_item")), Optional.empty(), new class_4945[]{class_4945.field_23018, MATERIAL, INSIDE});
    private static final ModelWithOverrides GENERATED_OVERRIDES = new ModelWithOverrides(new class_2960("item/generated"), class_4945.field_23006);
    private static final ModelWithOverrides GENERATED_OVERRIDES_1 = new ModelWithOverrides(new class_2960("item/generated"), class_4945.field_23006, LAYER1);
    private static final ModelWithOverrides HANDHELD_OVERRIDES = new ModelWithOverrides(new class_2960("item/handheld"), class_4945.field_23006);
    private static final ModelWithOverrides HANDHELD_OVERRIDES_2 = new ModelWithOverrides(new class_2960("item/handheld"), class_4945.field_23006, LAYER1, LAYER2);
    private final class_2403 generator;
    private static final String BUILTIN_ENTITY_DISPLAY_STR = "{\n        \"gui\": {\n            \"rotation\": [ 30, 45, 0 ],\n            \"translation\": [ 0, 0, 0],\n            \"scale\":[ 0.625, 0.625, 0.625 ]\n        },\n        \"ground\": {\n            \"rotation\": [ 0, 0, 0 ],\n            \"translation\": [ 0, 3, 0],\n            \"scale\":[ 0.25, 0.25, 0.25 ]\n        },\n        \"head\": {\n            \"rotation\": [ 0, 180, 0 ],\n            \"translation\": [ 0, 0, 0],\n            \"scale\":[ 1, 1, 1]\n        },\n        \"fixed\": {\n            \"rotation\": [ 0, 180, 0 ],\n            \"translation\": [ 0, 0, 0],\n            \"scale\":[ 0.5, 0.5, 0.5 ]\n        },\n        \"thirdperson_righthand\": {\n            \"rotation\": [ 75, 315, 0 ],\n            \"translation\": [ 0, 2.5, 0],\n            \"scale\": [ 0.375, 0.375, 0.375 ]\n        },\n        \"firstperson_righthand\": {\n            \"rotation\": [ 0, 315, 0 ],\n            \"translation\": [ 0, 0, 0],\n            \"scale\": [ 0.4, 0.4, 0.4 ]\n        }\n    }";
    private static final JsonElement BUILTIN_ENTITY_DISPLAY = (JsonElement)GSON.fromJson("{\n        \"gui\": {\n            \"rotation\": [ 30, 45, 0 ],\n            \"translation\": [ 0, 0, 0],\n            \"scale\":[ 0.625, 0.625, 0.625 ]\n        },\n        \"ground\": {\n            \"rotation\": [ 0, 0, 0 ],\n            \"translation\": [ 0, 3, 0],\n            \"scale\":[ 0.25, 0.25, 0.25 ]\n        },\n        \"head\": {\n            \"rotation\": [ 0, 180, 0 ],\n            \"translation\": [ 0, 0, 0],\n            \"scale\":[ 1, 1, 1]\n        },\n        \"fixed\": {\n            \"rotation\": [ 0, 180, 0 ],\n            \"translation\": [ 0, 0, 0],\n            \"scale\":[ 0.5, 0.5, 0.5 ]\n        },\n        \"thirdperson_righthand\": {\n            \"rotation\": [ 75, 315, 0 ],\n            \"translation\": [ 0, 2.5, 0],\n            \"scale\": [ 0.375, 0.375, 0.375 ]\n        },\n        \"firstperson_righthand\": {\n            \"rotation\": [ 0, 315, 0 ],\n            \"translation\": [ 0, 0, 0],\n            \"scale\": [ 0.4, 0.4, 0.4 ]\n        }\n    }", JsonElement.class);

    public ItemModelProvider(class_2403 generator) {
        this.generator = generator;
    }

    public void method_10319(class_2408 cache) throws IOException {
        Set<class_1792> items = class_2378.field_11142.method_10220().filter(i -> "botania".equals(class_2378.field_11142.method_10221(i).method_12836())).collect(Collectors.toSet());
        HashMap map = new HashMap();
        this.registerItemBlocks(BlockstateProvider.takeAll(items, i -> i instanceof class_1747).stream().map(i -> (class_1747)i).collect(Collectors.toSet()), map::put);
        ItemModelProvider.registerItemOverrides(items, map::put);
        ItemModelProvider.registerItems(items, map::put);
        for (Map.Entry e : map.entrySet()) {
            class_2960 id = (class_2960)e.getKey();
            Path out = this.generator.method_10313().resolve("assets/" + id.method_12836() + "/models/" + id.method_12832() + ".json");
            try {
                class_2405.method_10320((Gson)GSON, (class_2408)cache, (JsonElement)((JsonElement)((Supplier)e.getValue()).get()), (Path)out);
            }
            catch (IOException ex) {
                Botania.LOGGER.error("Failed to generate {}", (Object)out, (Object)ex);
            }
        }
    }

    private static void registerItems(Set<class_1792> items, BiConsumer<class_2960, Supplier<JsonElement>> consumer) {
        items.remove(ModItems.manaGun);
        BlockstateProvider.takeAll(items, i -> i instanceof ItemLens).forEach(i -> {
            class_2960 lens = i == ModItems.lensTime || i == ModItems.lensWarp || i == ModItems.lensFire ? ResourceLocationHelper.prefix("item/lens_small") : ResourceLocationHelper.prefix("item/lens");
            GENERATED_1.method_25852(class_4941.method_25840((class_1792)i), class_4944.method_25895((class_2960)lens).method_25868(LAYER1, class_4944.method_25876((class_1792)i)), consumer);
        });
        GENERATED_1.method_25852(class_4941.method_25840((class_1792)ModItems.bloodPendant), class_4944.method_25895((class_2960)class_4944.method_25876((class_1792)ModItems.bloodPendant)).method_25868(LAYER1, class_4944.method_25863((class_1792)ModItems.bloodPendant, (String)"_overlay")), consumer);
        items.remove(ModItems.bloodPendant);
        HANDHELD_1.method_25852(class_4941.method_25840((class_1792)ModItems.enderDagger), class_4944.method_25895((class_2960)class_4944.method_25876((class_1792)ModItems.enderDagger)).method_25868(LAYER1, class_4944.method_25863((class_1792)ModItems.enderDagger, (String)"_overlay")), consumer);
        items.remove(ModItems.enderDagger);
        GENERATED_1.method_25852(class_4941.method_25840((class_1792)ModItems.incenseStick), class_4944.method_25895((class_2960)class_4944.method_25876((class_1792)ModItems.incenseStick)).method_25868(LAYER1, class_4944.method_25863((class_1792)ModItems.incenseStick, (String)"_overlay")), consumer);
        items.remove(ModItems.incenseStick);
        GENERATED_1.method_25852(class_4941.method_25840((class_1792)ModItems.manaMirror), class_4944.method_25895((class_2960)class_4944.method_25876((class_1792)ModItems.manaMirror)).method_25868(LAYER1, class_4944.method_25863((class_1792)ModItems.manaMirror, (String)"_overlay")), consumer);
        items.remove(ModItems.manaMirror);
        GENERATED_1.method_25852(class_4941.method_25840((class_1792)ModItems.manaTablet), class_4944.method_25895((class_2960)class_4944.method_25876((class_1792)ModItems.manaTablet)).method_25868(LAYER1, class_4944.method_25863((class_1792)ModItems.manaTablet, (String)"_overlay")), consumer);
        items.remove(ModItems.manaTablet);
        GENERATED_2.method_25852(class_4941.method_25840((class_1792)ModItems.thirdEye), new class_4944().method_25868(class_4945.field_23006, class_4944.method_25863((class_1792)ModItems.thirdEye, (String)"_0")).method_25868(LAYER1, class_4944.method_25863((class_1792)ModItems.thirdEye, (String)"_1")).method_25868(LAYER2, class_4944.method_25863((class_1792)ModItems.thirdEye, (String)"_2")), consumer);
        items.remove(ModItems.thirdEye);
        BlockstateProvider.takeAll(items, ModItems.cobbleRod, ModItems.dirtRod, ModItems.diviningRod, ModItems.elementiumAxe, ModItems.elementiumPick, ModItems.elementiumShovel, ModItems.elementiumHoe, ModItems.elementiumSword, ModItems.exchangeRod, ModItems.fireRod, ModItems.glassPick, ModItems.gravityRod, ModItems.manasteelAxe, ModItems.manasteelPick, ModItems.manasteelShears, ModItems.manasteelShovel, ModItems.manasteelHoe, ModItems.missileRod, ModItems.obedienceStick, ModItems.rainbowRod, ModItems.smeltRod, ModItems.starSword, ModItems.terraSword, ModItems.terraformRod, ModItems.thunderSword, ModItems.waterRod, ModItems.kingKey, ModItems.skyDirtRod).forEach(i -> class_4943.field_22939.method_25852(class_4941.method_25840((class_1792)i), class_4944.method_25871((class_1792)i), consumer));
        BlockstateProvider.takeAll(items, i -> true).forEach(i -> class_4943.field_22938.method_25852(class_4941.method_25840((class_1792)i), class_4944.method_25871((class_1792)i), consumer));
    }

    private static void singleGeneratedOverride(class_1792 item, class_2960 overrideModel, class_2960 predicate, double value, BiConsumer<class_2960, Supplier<JsonElement>> consumer) {
        class_4943.field_22938.method_25852(overrideModel, class_4944.method_25895((class_2960)overrideModel), consumer);
        GENERATED_OVERRIDES.create(class_4941.method_25840((class_1792)item), class_4944.method_25871((class_1792)item), new OverrideHolder().add(overrideModel, Pair.of((Object)predicate, (Object)value)), consumer);
    }

    private static void singleGeneratedSuffixOverride(class_1792 item, String suffix, class_2960 predicate, double value, BiConsumer<class_2960, Supplier<JsonElement>> consumer) {
        ItemModelProvider.singleGeneratedOverride(item, class_4941.method_25841((class_1792)item, (String)suffix), predicate, value, consumer);
    }

    private static void singleHandheldOverride(class_1792 item, class_2960 overrideModel, class_2960 predicate, double value, BiConsumer<class_2960, Supplier<JsonElement>> consumer) {
        class_4943.field_22939.method_25852(overrideModel, class_4944.method_25895((class_2960)overrideModel), consumer);
        HANDHELD_OVERRIDES.create(class_4941.method_25840((class_1792)item), class_4944.method_25871((class_1792)item), new OverrideHolder().add(overrideModel, Pair.of((Object)predicate, (Object)value)), consumer);
    }

    private static void singleHandheldSuffixOverride(class_1792 item, String suffix, class_2960 predicate, double value, BiConsumer<class_2960, Supplier<JsonElement>> consumer) {
        ItemModelProvider.singleHandheldOverride(item, class_4941.method_25841((class_1792)item, (String)suffix), predicate, value, consumer);
    }

    private static void registerItemOverrides(Set<class_1792> items, BiConsumer<class_2960, Supplier<JsonElement>> consumer) {
        items.remove(ModItems.livingwoodBow);
        items.remove(ModItems.crystalBow);
        ItemModelProvider.singleGeneratedSuffixOverride(ModItems.blackHoleTalisman, "_active", ResourceLocationHelper.prefix("active"), 1.0, consumer);
        items.remove(ModItems.blackHoleTalisman);
        OverrideHolder flaskOverrides = new OverrideHolder();
        for (int i = 1; i <= 5; ++i) {
            class_2960 overrideModel = class_4941.method_25841((class_1792)ModItems.brewFlask, (String)("_" + i));
            GENERATED_1.method_25852(overrideModel, class_4944.method_25871((class_1792)ModItems.flask).method_25868(LAYER1, overrideModel), consumer);
            flaskOverrides.add(overrideModel, Pair.of((Object)ResourceLocationHelper.prefix("swigs_taken"), (Object)i));
        }
        GENERATED_OVERRIDES_1.create(class_4941.method_25840((class_1792)ModItems.brewFlask), class_4944.method_25871((class_1792)ModItems.flask).method_25868(LAYER1, class_4944.method_25863((class_1792)ModItems.brewFlask, (String)"_0")), flaskOverrides, consumer);
        items.remove(ModItems.brewFlask);
        OverrideHolder vialOverrides = new OverrideHolder();
        for (int i = 1; i <= 3; ++i) {
            class_1792[] overrideModel = class_4941.method_25841((class_1792)ModItems.brewVial, (String)("_" + i));
            GENERATED_1.method_25852((class_2960)overrideModel, class_4944.method_25871((class_1792)ModItems.vial).method_25868(LAYER1, (class_2960)overrideModel), consumer);
            vialOverrides.add((class_2960)overrideModel, Pair.of((Object)ResourceLocationHelper.prefix("swigs_taken"), (Object)i));
        }
        GENERATED_OVERRIDES_1.create(class_4941.method_25840((class_1792)ModItems.brewVial), class_4944.method_25871((class_1792)ModItems.vial).method_25868(LAYER1, class_4944.method_25863((class_1792)ModItems.brewVial, (String)"_0")), vialOverrides, consumer);
        items.remove(ModItems.brewVial);
        ItemModelProvider.singleHandheldOverride(ModItems.elementiumShears, ResourceLocationHelper.prefix("item/dammitreddit"), ResourceLocationHelper.prefix("reddit"), 1.0, consumer);
        items.remove(ModItems.elementiumShears);
        class_2960 vuvuzela = ResourceLocationHelper.prefix("item/vuvuzela");
        class_4943.field_22939.method_25852(vuvuzela, class_4944.method_25895((class_2960)vuvuzela), consumer);
        for (class_1792 i : new class_1792[]{ModItems.grassHorn, ModItems.leavesHorn, ModItems.snowHorn}) {
            GENERATED_OVERRIDES.create(class_4941.method_25840((class_1792)i), class_4944.method_25871((class_1792)i), new OverrideHolder().add(vuvuzela, Pair.of((Object)ResourceLocationHelper.prefix("vuvuzela"), (Object)1.0)), consumer);
        }
        items.remove(ModItems.grassHorn);
        items.remove(ModItems.leavesHorn);
        items.remove(ModItems.snowHorn);
        ItemModelProvider.singleGeneratedOverride(ModItems.infiniteFruit, ResourceLocationHelper.prefix("item/dasboot"), ResourceLocationHelper.prefix("boot"), 1.0, consumer);
        items.remove(ModItems.infiniteFruit);
        ItemModelProvider.singleGeneratedSuffixOverride(ModItems.lexicon, "_elven", ResourceLocationHelper.prefix("elven"), 1.0, consumer);
        items.remove((Object)ModItems.lexicon);
        ItemModelProvider.singleGeneratedSuffixOverride(ModItems.magnetRing, "_active", ResourceLocationHelper.prefix("active"), 1.0, consumer);
        items.remove(ModItems.magnetRing);
        ItemModelProvider.singleGeneratedSuffixOverride(ModItems.magnetRingGreater, "_active", ResourceLocationHelper.prefix("active"), 1.0, consumer);
        items.remove(ModItems.magnetRingGreater);
        OverrideHolder bottleOverrides = new OverrideHolder();
        for (int i = 1; i <= 5; ++i) {
            class_2960 overrideModel = class_4941.method_25841((class_1792)ModItems.manaBottle, (String)("_" + i));
            class_4943.field_22938.method_25852(overrideModel, class_4944.method_25895((class_2960)overrideModel), consumer);
            bottleOverrides.add(overrideModel, Pair.of((Object)ResourceLocationHelper.prefix("swigs_taken"), (Object)i));
        }
        GENERATED_OVERRIDES.create(class_4941.method_25840((class_1792)ModItems.manaBottle), class_4944.method_25871((class_1792)ModItems.manaBottle), bottleOverrides, consumer);
        items.remove(ModItems.manaBottle);
        ItemModelProvider.singleGeneratedOverride(ModItems.manaCookie, ResourceLocationHelper.prefix("item/totalbiscuit"), ResourceLocationHelper.prefix("totalbiscuit"), 1.0, consumer);
        items.remove(ModItems.manaCookie);
        ItemModelProvider.singleHandheldOverride(ModItems.manasteelSword, ResourceLocationHelper.prefix("item/elucidator"), ResourceLocationHelper.prefix("elucidator"), 1.0, consumer);
        items.remove(ModItems.manasteelSword);
        ItemModelProvider.singleGeneratedSuffixOverride(ModItems.manaweaveHelm, "_holiday", ResourceLocationHelper.prefix("holiday"), 1.0, consumer);
        items.remove(ModItems.manaweaveHelm);
        ItemModelProvider.singleGeneratedSuffixOverride(ModItems.manaweaveChest, "_holiday", ResourceLocationHelper.prefix("holiday"), 1.0, consumer);
        items.remove(ModItems.manaweaveChest);
        ItemModelProvider.singleGeneratedSuffixOverride(ModItems.manaweaveLegs, "_holiday", ResourceLocationHelper.prefix("holiday"), 1.0, consumer);
        items.remove(ModItems.manaweaveLegs);
        ItemModelProvider.singleGeneratedSuffixOverride(ModItems.manaweaveBoots, "_holiday", ResourceLocationHelper.prefix("holiday"), 1.0, consumer);
        items.remove(ModItems.manaweaveBoots);
        ItemModelProvider.singleGeneratedSuffixOverride(ModItems.slimeBottle, "_active", ResourceLocationHelper.prefix("active"), 1.0, consumer);
        items.remove(ModItems.slimeBottle);
        ItemModelProvider.singleGeneratedSuffixOverride(ModItems.spawnerMover, "_full", ResourceLocationHelper.prefix("full"), 1.0, consumer);
        items.remove(ModItems.spawnerMover);
        ItemModelProvider.singleGeneratedSuffixOverride(ModItems.temperanceStone, "_active", ResourceLocationHelper.prefix("active"), 1.0, consumer);
        items.remove(ModItems.temperanceStone);
        ItemModelProvider.singleHandheldSuffixOverride(ModItems.terraAxe, "_active", ResourceLocationHelper.prefix("active"), 1.0, consumer);
        items.remove(ModItems.terraAxe);
        class_2960 enabledModel = class_4941.method_25841((class_1792)ModItems.terraPick, (String)"_active");
        HANDHELD_1.method_25852(enabledModel, class_4944.method_25871((class_1792)ModItems.terraPick).method_25868(LAYER1, enabledModel), consumer);
        class_2960 tippedModel = class_4941.method_25841((class_1792)ModItems.terraPick, (String)"_tipped");
        class_4943.field_22939.method_25852(tippedModel, class_4944.method_25895((class_2960)tippedModel), consumer);
        class_2960 tippedEnabledModel = class_4941.method_25841((class_1792)ModItems.terraPick, (String)"_tipped_active");
        HANDHELD_1.method_25852(tippedEnabledModel, class_4944.method_25895((class_2960)tippedModel).method_25868(LAYER1, class_4944.method_25863((class_1792)ModItems.terraPick, (String)"_active")), consumer);
        HANDHELD_OVERRIDES.create(class_4941.method_25840((class_1792)ModItems.terraPick), class_4944.method_25871((class_1792)ModItems.terraPick), new OverrideHolder().add(enabledModel, Pair.of((Object)ResourceLocationHelper.prefix("active"), (Object)1.0)).add(tippedModel, Pair.of((Object)ResourceLocationHelper.prefix("tipped"), (Object)1.0)).add(tippedEnabledModel, Pair.of((Object)ResourceLocationHelper.prefix("tipped"), (Object)1.0), Pair.of((Object)ResourceLocationHelper.prefix("active"), (Object)1.0)), consumer);
        items.remove(ModItems.terraPick);
        ItemModelProvider.singleHandheldSuffixOverride(ModItems.tornadoRod, "_active", ResourceLocationHelper.prefix("active"), 1.0, consumer);
        items.remove(ModItems.tornadoRod);
        class_4944 twigWandTextures = class_4944.method_25871((class_1792)ModItems.twigWand).method_25868(LAYER1, class_4944.method_25863((class_1792)ModItems.twigWand, (String)"_top")).method_25868(LAYER2, class_4944.method_25863((class_1792)ModItems.twigWand, (String)"_bottom"));
        class_2960 twigWandBind = class_4941.method_25841((class_1792)ModItems.twigWand, (String)"_bind");
        HANDHELD_3.method_25852(twigWandBind, twigWandTextures.method_25879(LAYER3, class_4944.method_25863((class_1792)ModItems.twigWand, (String)"_bind")), consumer);
        HANDHELD_OVERRIDES_2.create(class_4941.method_25840((class_1792)ModItems.twigWand), twigWandTextures, new OverrideHolder().add(twigWandBind, Pair.of((Object)ResourceLocationHelper.prefix("bindmode"), (Object)1.0)), consumer);
        items.remove(ModItems.twigWand);
    }

    private void registerItemBlocks(Set<class_1747> itemBlocks, BiConsumer<class_2960, Supplier<JsonElement>> consumer) {
        itemBlocks.remove(ModBlocks.corporeaCrystalCube.method_8389());
        itemBlocks.removeIf(i -> {
            class_2960 id = class_2378.field_11146.method_10221((Object)i.method_7711());
            return id.method_12836().equals("botania") && i.method_7711() instanceof BlockFloatingFlower;
        });
        GENERATED_1.method_25852(class_4941.method_25840((class_1792)ModBlocks.animatedTorch.method_8389()), class_4944.method_25911((class_2248)class_2246.field_10523).method_25868(LAYER1, ResourceLocationHelper.prefix("block/animated_torch_glimmer")), consumer);
        itemBlocks.remove(ModBlocks.animatedTorch.method_8389());
        class_4943.field_22945.method_25852(class_4941.method_25840((class_1792)ModBlocks.gaiaHead.method_8389()), new class_4944(), consumer);
        itemBlocks.remove(ModBlocks.gaiaHead.method_8389());
        BlockstateProvider.takeAll(itemBlocks, i -> i.method_7711() instanceof BlockModDoubleFlower).forEach(i -> class_4943.field_22938.method_25852(class_4941.method_25840((class_1792)i), class_4944.method_25895((class_2960)class_4944.method_25866((class_2248)i.method_7711(), (String)"_top")), consumer));
        BlockstateProvider.takeAll(itemBlocks, i -> i.method_7711() instanceof BlockPetalBlock).forEach(i -> consumer.accept(class_4941.method_25840((class_1792)i), (Supplier<JsonElement>)new class_4940(ResourceLocationHelper.prefix("block/petal_block"))));
        BlockstateProvider.takeAll(itemBlocks, i -> i.method_7711() instanceof class_2389).forEach(i -> {
            String name = class_2378.field_11142.method_10221(i).method_12832();
            String baseName = name.substring(0, name.length() - "_pane".length());
            class_4943.field_22938.method_25852(class_4941.method_25840((class_1792)i), class_4944.method_25895((class_2960)ResourceLocationHelper.prefix("block/" + baseName)), consumer);
        });
        Predicate<class_1747> defaultGenerated = i -> {
            class_2248 b = i.method_7711();
            return b instanceof BlockSpecialFlower || b instanceof BlockModMushroom || b instanceof BlockLightRelay || b instanceof BlockModFlower || b == ModBlocks.ghostRail;
        };
        BlockstateProvider.takeAll(itemBlocks, defaultGenerated).forEach(i -> class_4943.field_22938.method_25852(class_4941.method_25840((class_1792)i), class_4944.method_25911((class_2248)i.method_7711()), consumer));
        BlockstateProvider.takeAll(itemBlocks, b -> b.method_7711() instanceof BlockMotifFlower).forEach(i -> {
            String name = class_2378.field_11142.method_10221(i).method_12832();
            class_2960 texName = ResourceLocationHelper.prefix("block/" + name.replace("_motif", ""));
            class_4943.field_22938.method_25852(class_4941.method_25840((class_1792)i), class_4944.method_25895((class_2960)texName), consumer);
        });
        BlockstateProvider.takeAll(itemBlocks, i -> i.method_7711() instanceof BlockPool).forEach(i -> {
            class_2960 fullModel = class_4941.method_25843((class_2248)i.method_7711(), (String)"_full");
            OverrideHolder overrides = new OverrideHolder().add(fullModel, Pair.of((Object)ResourceLocationHelper.prefix("full"), (Object)1.0));
            consumer.accept(class_4941.method_25840((class_1792)i), (Supplier<JsonElement>)((Object)new SimpleModelSupplierWithOverrides(class_4941.method_25842((class_2248)i.method_7711()), overrides)));
        });
        BlockstateProvider.takeAll(itemBlocks, i -> i.method_7711() instanceof class_2544).forEach(i -> {
            String name = class_2378.field_11142.method_10221(i).method_12832();
            String baseName = name.substring(0, name.length() - "_wall".length());
            class_4943.field_22994.method_25852(class_4941.method_25840((class_1792)i), new class_4944().method_25868(class_4945.field_23027, ResourceLocationHelper.prefix("block/" + baseName)), consumer);
        });
        BlockstateProvider.takeAll(itemBlocks, i -> i.method_7711() instanceof BlockSpreader).forEach(i -> {
            String name = class_2378.field_11142.method_10221(i).method_12832();
            Object material = i.method_7711() == ModBlocks.elvenSpreader ? "dreamwood" : (i.method_7711() == ModBlocks.gaiaSpreader ? name + "_material" : "livingwood");
            SPREADER.method_25852(class_4941.method_25840((class_1792)i), new class_4944().method_25868(class_4945.field_23018, class_4944.method_25866((class_2248)i.method_7711(), (String)"_side")).method_25868(MATERIAL, ResourceLocationHelper.prefix("block/" + (String)material)).method_25868(INSIDE, class_4944.method_25866((class_2248)i.method_7711(), (String)"_inside")), consumer);
        });
        BlockstateProvider.takeAll(itemBlocks, ModBlocks.avatar.method_8389(), ModBlocks.bellows.method_8389(), ModBlocks.brewery.method_8389(), ModBlocks.corporeaIndex.method_8389(), ModBlocks.gaiaPylon.method_8389(), ModBlocks.hourglass.method_8389(), ModBlocks.manaPylon.method_8389(), ModBlocks.naturaPylon.method_8389(), ModBlocks.teruTeruBozu.method_8389()).forEach(i -> this.builtinEntity((class_1792)i, consumer));
        BlockstateProvider.takeAll(itemBlocks, i -> i instanceof ItemPetal).forEach(i -> class_4943.field_22938.method_25852(class_4941.method_25840((class_1792)i), class_4944.method_25895((class_2960)ResourceLocationHelper.prefix("item/petal")), consumer));
        class_4943.field_22990.method_25852(class_4941.method_25840((class_1792)ModFluffBlocks.dreamwoodFence.method_8389()), class_4944.method_25872((class_2248)ModBlocks.dreamwoodPlanks), consumer);
        itemBlocks.remove(ModFluffBlocks.dreamwoodFence.method_8389());
        class_4943.field_22990.method_25852(class_4941.method_25840((class_1792)ModFluffBlocks.livingwoodFence.method_8389()), class_4944.method_25872((class_2248)ModBlocks.livingwoodPlanks), consumer);
        itemBlocks.remove(ModFluffBlocks.livingwoodFence.method_8389());
        consumer.accept(class_4941.method_25840((class_1792)ModBlocks.elfGlass.method_8389()), (Supplier<JsonElement>)new class_4940(ResourceLocationHelper.prefix("block/elf_glass_0")));
        itemBlocks.remove(ModBlocks.elfGlass.method_8389());
        itemBlocks.forEach(i -> consumer.accept(class_4941.method_25840((class_1792)i), (Supplier<JsonElement>)new class_4940(class_4941.method_25842((class_2248)i.method_7711()))));
    }

    protected void builtinEntity(class_1792 i, BiConsumer<class_2960, Supplier<JsonElement>> consumer) {
        consumer.accept(class_4941.method_25840((class_1792)i), () -> {
            JsonObject json = new JsonObject();
            json.addProperty("parent", "minecraft:builtin/entity");
            json.add("display", BUILTIN_ENTITY_DISPLAY);
            return json;
        });
    }

    @Nonnull
    public String method_10321() {
        return "Botania item models";
    }
}

