/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.plugin.client.runtime;

import com.google.common.base.Stopwatch;
import dev.architectury.event.EventResult;
import it.unimi.dsi.fastutil.objects.Reference2BooleanMap;
import it.unimi.dsi.fastutil.objects.Reference2BooleanMaps;
import it.unimi.dsi.fastutil.objects.Reference2BooleanOpenHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import me.shedaniel.rei.RoughlyEnoughItemsCore;
import me.shedaniel.rei.api.client.config.ConfigObject;
import me.shedaniel.rei.api.client.registry.display.DisplayCategory;
import me.shedaniel.rei.api.client.registry.display.DisplayRegistry;
import me.shedaniel.rei.api.client.registry.display.visibility.DisplayVisibilityPredicate;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.impl.client.config.ConfigObjectImpl;
import me.shedaniel.rei.impl.client.entry.filtering.FilteringCache;
import me.shedaniel.rei.impl.client.entry.filtering.FilteringCacheImpl;
import me.shedaniel.rei.impl.client.entry.filtering.FilteringContextImpl;
import me.shedaniel.rei.impl.client.entry.filtering.FilteringContextType;
import me.shedaniel.rei.impl.client.entry.filtering.FilteringRule;

public class FilteredStacksVisibilityHandler
implements DisplayVisibilityPredicate {
    private boolean checkHiddenStacks;
    private Reference2BooleanMap<Display> visible = Reference2BooleanMaps.synchronize((Reference2BooleanMap)new Reference2BooleanOpenHashMap());
    private List<FilteringRule<?>> filteringRules;
    private FilteringCacheImpl cache;
    private final Predicate<Display> displayPredicate = this::checkHiddenStacks;

    @Override
    public EventResult handleDisplay(DisplayCategory<?> category, Display display) {
        if (this.checkHiddenStacks) {
            return this.visible.computeBooleanIfAbsent((Object)display, this.displayPredicate) ? EventResult.pass() : EventResult.interruptFalse();
        }
        return EventResult.pass();
    }

    public void reset() {
        this.checkHiddenStacks = ConfigObject.getInstance().shouldFilterDisplays();
        this.visible = Reference2BooleanMaps.synchronize((Reference2BooleanMap)new Reference2BooleanOpenHashMap());
        if (this.checkHiddenStacks) {
            this.filteringRules = ((ConfigObjectImpl)ConfigObject.getInstance()).getFilteringRules();
            this.cache = new FilteringCacheImpl();
            for (int i = this.filteringRules.size() - 1; i >= 0; --i) {
                FilteringRule<?> rule = this.filteringRules.get(i);
                this.cache.setCache(rule, rule.prepareCache(false));
            }
            this.cacheExisting();
        } else {
            this.filteringRules = null;
            this.cache = null;
        }
    }

    public void cacheExisting() {
        Stopwatch stopwatch = Stopwatch.createStarted();
        DisplayRegistry.getInstance().getAll().values().parallelStream().map(displays -> {
            Reference2BooleanOpenHashMap current = new Reference2BooleanOpenHashMap();
            for (Display display : displays) {
                current.put((Object)display, this.checkHiddenStacks(display));
            }
            return current;
        }).forEach(map -> this.visible.putAll((Map)map));
        RoughlyEnoughItemsCore.LOGGER.debug("Computed existing filtered displays with %d rules in %s", this.filteringRules.size(), stopwatch.stop());
    }

    private boolean checkHiddenStacks(Display display) {
        for (EntryIngredient ingredient : display.getInputEntries()) {
            if (ingredient.isEmpty() || !FilteredStacksVisibilityHandler.isEntryIngredientAllHidden(ingredient, this.cache, this.filteringRules)) continue;
            return false;
        }
        for (EntryIngredient ingredient : display.getOutputEntries()) {
            if (ingredient.isEmpty() || !FilteredStacksVisibilityHandler.isEntryIngredientAllHidden(ingredient, this.cache, this.filteringRules)) continue;
            return false;
        }
        return true;
    }

    private static boolean isEntryIngredientAllHidden(EntryIngredient ingredient, FilteringCache cache, List<FilteringRule<?>> rules) {
        FilteringContextImpl context = new FilteringContextImpl(false, ingredient);
        for (int i = rules.size() - 1; i >= 0; --i) {
            FilteringRule<?> rule = rules.get(i);
            context.handleResult(rule.processFilteredStacks(context, cache, false));
        }
        return context.stacks.get((Object)FilteringContextType.SHOWN).isEmpty() && context.stacks.get((Object)FilteringContextType.DEFAULT).isEmpty();
    }
}

