/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.search.argument.type;

import java.util.Locale;
import me.shedaniel.rei.api.client.ClientHelper;
import me.shedaniel.rei.api.client.config.ConfigObject;
import me.shedaniel.rei.api.client.gui.config.SearchMode;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.impl.client.search.argument.type.ArgumentType;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2583;
import net.minecraft.class_3902;
import net.minecraft.class_5251;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
@Environment(value=EnvType.CLIENT)
public final class ModArgumentType
extends ArgumentType<class_3902, ModInfoPair> {
    public static final ModArgumentType INSTANCE = new ModArgumentType();
    private static final class_2583 STYLE = class_2583.field_24360.method_27703(class_5251.method_27717((int)16754931));

    @Override
    public String getName() {
        return "mod";
    }

    @Override
    @Nullable
    public String getPrefix() {
        return "@";
    }

    @Override
    public SearchMode getSearchMode() {
        return ConfigObject.getInstance().getModSearchMode();
    }

    @Override
    @Nullable
    public ModInfoPair cacheData(EntryStack<?> stack) {
        String containingNs = stack.getContainingNamespace();
        return containingNs != null ? new ModInfoPair(containingNs, null) : ModInfoPair.EMPTY;
    }

    @Override
    public boolean matches(@Nullable ModInfoPair pair, EntryStack<?> stack, String searchText, class_3902 filterData) {
        if (pair.modId == null || pair.modId.contains(searchText)) {
            return true;
        }
        if (pair.modName == null) {
            pair.modName = ClientHelper.getInstance().getModFromModId(pair.modId).toLowerCase(Locale.ROOT);
        }
        return pair.modName.isEmpty() || pair.modName.contains(searchText);
    }

    @Override
    public class_3902 prepareSearchFilter(String searchText) {
        return class_3902.field_17274;
    }

    @Override
    public class_2583 getHighlightedStyle() {
        return STYLE;
    }

    private ModArgumentType() {
    }

    protected static class ModInfoPair {
        private static final ModInfoPair EMPTY = new ModInfoPair(null, null);
        @Nullable
        private final String modId;
        @Nullable
        private String modName;

        public ModInfoPair(@Nullable String modId, @Nullable String modName) {
            this.modId = modId;
            this.modName = modName;
        }
    }
}

