/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.favorites;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import me.shedaniel.rei.api.client.config.ConfigManager;
import me.shedaniel.rei.api.client.config.ConfigObject;
import me.shedaniel.rei.api.client.favorites.FavoriteEntry;
import me.shedaniel.rei.api.client.favorites.FavoriteEntryType;
import me.shedaniel.rei.api.client.favorites.SystemFavoriteEntryProvider;
import me.shedaniel.rei.api.client.plugins.REIClientPlugin;
import me.shedaniel.rei.api.common.registry.ReloadStage;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import org.apache.commons.lang3.mutable.MutableLong;
import org.apache.commons.lang3.tuple.Triple;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class FavoriteEntryTypeRegistryImpl
implements FavoriteEntryType.Registry {
    private final BiMap<class_2960, FavoriteEntryType<?>> registry = HashBiMap.create();
    private final List<Triple<SystemFavoriteEntryProvider<?>, MutableLong, List<FavoriteEntry>>> systemFavorites = Lists.newArrayList();
    private final Map<class_2561, FavoriteEntryType.Section> sections = Maps.newConcurrentMap();
    private final List<FavoriteEntryType.Section> sectionsList = Lists.newCopyOnWriteArrayList();

    @Override
    public ReloadStage getStage() {
        return ReloadStage.START;
    }

    @Override
    public void acceptPlugin(REIClientPlugin plugin) {
        plugin.registerFavorites(this);
    }

    @Override
    public void register(class_2960 id, FavoriteEntryType<?> type) {
        this.registry.put((Object)id, type);
    }

    @Override
    @Nullable
    public <A extends FavoriteEntry> FavoriteEntryType<A> get(class_2960 id) {
        return (FavoriteEntryType)this.registry.get((Object)id);
    }

    @Override
    @Nullable
    public class_2960 getId(FavoriteEntryType<?> type) {
        return (class_2960)this.registry.inverse().get(type);
    }

    @Override
    public FavoriteEntryType.Section getOrCrateSection(class_2561 text) {
        return this.sections.computeIfAbsent(text, $ -> {
            SectionImpl section = new SectionImpl((class_2561)$);
            this.sectionsList.add(section);
            return section;
        });
    }

    @Override
    public Iterable<FavoriteEntryType.Section> sections() {
        return this.sectionsList;
    }

    @Override
    public <A extends FavoriteEntry> void registerSystemFavorites(SystemFavoriteEntryProvider<A> provider) {
        this.systemFavorites.add(Triple.of(provider, (Object)new MutableLong(-1L), new ArrayList()));
    }

    public List<Triple<SystemFavoriteEntryProvider<?>, MutableLong, List<FavoriteEntry>>> getSystemProviders() {
        return this.systemFavorites;
    }

    @Override
    public void startReload() {
        this.registry.clear();
        this.systemFavorites.clear();
        this.sections.clear();
        this.sectionsList.clear();
    }

    @Override
    public void endReload() {
        if (ConfigObject.getInstance().isFavoritesEnabled()) {
            List<FavoriteEntry> favorites = ConfigObject.getInstance().getFavoriteEntries();
            favorites.removeIf(FavoriteEntry::isInvalid);
            ConfigManager.getInstance().saveConfig();
        }
    }

    private static class SectionImpl
    implements FavoriteEntryType.Section {
        private final class_2561 text;
        private final List<FavoriteEntry> entries = new ArrayList<FavoriteEntry>();

        public SectionImpl(class_2561 text) {
            this.text = text;
        }

        @Override
        public void add(FavoriteEntry ... entries) {
            Collections.addAll(this.entries, entries);
        }

        @Override
        public class_2561 getText() {
            return this.text;
        }

        @Override
        public List<FavoriteEntry> getEntries() {
            return this.entries;
        }
    }
}

