/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.tinyremapper.extension.mixin.soft.util;

import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import net.fabricmc.tinyremapper.api.TrClass;
import net.fabricmc.tinyremapper.extension.mixin.common.IMappable;
import net.fabricmc.tinyremapper.extension.mixin.common.MapUtility;
import net.fabricmc.tinyremapper.extension.mixin.common.ResolveUtility;
import net.fabricmc.tinyremapper.extension.mixin.common.data.CommonData;

public class NamedMappable
implements IMappable<String> {
    private final CommonData data;
    private final String name;
    private final String desc;
    private final Collection<TrClass> targets;

    public NamedMappable(CommonData data, String name, String desc, Collection<String> targets) {
        this.data = Objects.requireNonNull(data);
        this.name = Objects.requireNonNull(name);
        this.desc = Objects.requireNonNull(desc);
        this.targets = Objects.requireNonNull(targets).stream().map(data.resolver::resolveClass).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
    }

    @Override
    public String result() {
        if (MapUtility.IGNORED_NAME.contains(this.name)) {
            return this.name;
        }
        Collection collection = this.targets.stream().map(target -> this.data.resolver.resolveMember((TrClass)target, this.name, this.desc, ResolveUtility.FLAG_UNIQUE | ResolveUtility.FLAG_RECURSIVE)).filter(Optional::isPresent).map(Optional::get).map(this.data.mapper::mapName).distinct().collect(Collectors.toList());
        if (collection.size() > 1) {
            this.data.logger.error(String.format("Conflict mapping detected, %s -> %s.", this.name, collection));
        } else if (collection.isEmpty()) {
            this.data.logger.warn(String.format("Cannot remap %s because it does not exists in any of the targets %s or their parents.", this.name, this.targets));
        }
        return collection.stream().findFirst().orElse(this.name);
    }
}

