/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loader.impl;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import net.fabricmc.loader.ModContainer;
import net.fabricmc.loader.impl.FabricLoaderImpl;
import net.fabricmc.loader.impl.metadata.LoaderModMetadata;
import net.fabricmc.loader.impl.util.FileSystemUtil;
import net.fabricmc.loader.impl.util.log.Log;
import net.fabricmc.loader.impl.util.log.LogCategory;

public class ModContainerImpl
extends ModContainer {
    private final LoaderModMetadata info;
    private final Path originPath;
    private volatile Path root;
    private boolean warned = false;

    public ModContainerImpl(LoaderModMetadata info, Path originPath) {
        this.info = info;
        this.originPath = originPath;
    }

    @Override
    public LoaderModMetadata getMetadata() {
        return this.info;
    }

    @Override
    public Path getOriginPath() {
        return this.originPath;
    }

    @Override
    public Path getRootPath() {
        Path ret = this.root;
        if (ret == null || !ret.getFileSystem().isOpen()) {
            if (ret != null && !this.warned) {
                if (!FabricLoaderImpl.INSTANCE.isDevelopmentEnvironment()) {
                    this.warned = true;
                }
                Log.warn(LogCategory.GENERAL, "FileSystem for %s has been closed unexpectedly, existing root path references may break!", this);
            }
            this.root = ret = this.obtainRootPath();
        }
        return ret;
    }

    private Path obtainRootPath() {
        try {
            if (Files.isDirectory(this.originPath, new LinkOption[0])) {
                return this.originPath;
            }
            FileSystemUtil.FileSystemDelegate delegate = FileSystemUtil.getJarFileSystem(this.originPath, false);
            if (delegate.get() == null) {
                throw new RuntimeException("Could not open JAR file " + this.originPath + " for NIO reading!");
            }
            return delegate.get().getRootDirectories().iterator().next();
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to find root directory for mod '" + this.info.getId() + "'!", e);
        }
    }

    @Override
    @Deprecated
    public LoaderModMetadata getInfo() {
        return this.info;
    }

    public String toString() {
        return String.format("%s %s", this.info.getId(), this.info.getVersion());
    }
}

