/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loader.impl.discovery;

import java.io.IOException;
import java.net.URL;
import java.nio.file.Path;
import java.util.Enumeration;
import net.fabricmc.loader.impl.discovery.ModCandidateFinder;
import net.fabricmc.loader.impl.launch.FabricLauncherBase;
import net.fabricmc.loader.impl.util.UrlConversionException;
import net.fabricmc.loader.impl.util.UrlUtil;
import net.fabricmc.loader.impl.util.log.Log;
import net.fabricmc.loader.impl.util.log.LogCategory;

public class ClasspathModCandidateFinder
implements ModCandidateFinder {
    @Override
    public void findCandidates(ModCandidateFinder.ModCandidateConsumer out) {
        if (FabricLauncherBase.getLauncher().isDevelopment()) {
            try {
                Enumeration<URL> mods = FabricLauncherBase.getLauncher().getTargetClassLoader().getResources("fabric.mod.json");
                while (mods.hasMoreElements()) {
                    try {
                        out.accept(UrlUtil.getSourcePath("fabric.mod.json", mods.nextElement()), false);
                    }
                    catch (UrlConversionException e) {
                        Log.debug(LogCategory.DISCOVERY, "Error determining location for fabric.mod.json", e);
                    }
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        try {
            out.accept(ClasspathModCandidateFinder.getFabricLoaderPath(), false);
        }
        catch (Throwable t) {
            Log.debug(LogCategory.DISCOVERY, "Could not retrieve launcher code source!", t);
        }
    }

    public static Path getFabricLoaderPath() {
        try {
            return UrlUtil.asPath(FabricLauncherBase.getLauncher().getClass().getProtectionDomain().getCodeSource().getLocation());
        }
        catch (Throwable t) {
            Log.debug(LogCategory.DISCOVERY, "Could not retrieve launcher code source!", t);
            return null;
        }
    }
}

