/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loader.impl.game.minecraft;

import net.fabricmc.loader.impl.util.log.LogCategory;
import net.fabricmc.loader.impl.util.log.LogHandler;
import net.fabricmc.loader.impl.util.log.LogLevel;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class Log4jLogHandler
implements LogHandler {
    @Override
    public boolean shouldLog(LogLevel level, LogCategory category) {
        return Log4jLogHandler.getLogger(category).isEnabled(Log4jLogHandler.translateLogLevel(level));
    }

    @Override
    public void log(long time, LogLevel level, LogCategory category, String msg, Throwable exc, boolean isReplayedBuiltin) {
        Log4jLogHandler.getLogger(category).log(Log4jLogHandler.translateLogLevel(level), msg, exc);
    }

    private static Logger getLogger(LogCategory category) {
        Logger ret = (Logger)category.data;
        if (ret == null) {
            String name = category.name.isEmpty() ? "FabricLoader" : String.format("%s/%s", "FabricLoader", category.name);
            ret = LogManager.getLogger((String)name);
            category.data = ret;
        }
        return ret;
    }

    private static Level translateLogLevel(LogLevel level) {
        if (level == LogLevel.ERROR) {
            return Level.ERROR;
        }
        if (level == LogLevel.WARN) {
            return Level.WARN;
        }
        if (level == LogLevel.INFO) {
            return Level.INFO;
        }
        if (level == LogLevel.DEBUG) {
            return Level.DEBUG;
        }
        if (level == LogLevel.TRACE) {
            return Level.TRACE;
        }
        throw new IllegalArgumentException("unknown log level: " + (Object)((Object)level));
    }

    @Override
    public void close() {
    }
}

