/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loader.impl.game.minecraft;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.zip.ZipFile;
import net.fabricmc.api.EnvType;
import net.fabricmc.loader.api.ObjectShare;
import net.fabricmc.loader.api.VersionParsingException;
import net.fabricmc.loader.api.metadata.ModDependency;
import net.fabricmc.loader.impl.FabricLoaderImpl;
import net.fabricmc.loader.impl.FormattedException;
import net.fabricmc.loader.impl.game.GameProvider;
import net.fabricmc.loader.impl.game.GameProviderHelper;
import net.fabricmc.loader.impl.game.minecraft.BundlerClassPathCapture;
import net.fabricmc.loader.impl.game.minecraft.McVersion;
import net.fabricmc.loader.impl.game.minecraft.McVersionLookup;
import net.fabricmc.loader.impl.game.minecraft.patch.BrandingPatch;
import net.fabricmc.loader.impl.game.minecraft.patch.EntrypointPatch;
import net.fabricmc.loader.impl.game.minecraft.patch.EntrypointPatchFML125;
import net.fabricmc.loader.impl.game.patch.GameTransformer;
import net.fabricmc.loader.impl.launch.FabricLauncher;
import net.fabricmc.loader.impl.launch.knot.Knot;
import net.fabricmc.loader.impl.metadata.BuiltinModMetadata;
import net.fabricmc.loader.impl.metadata.ModDependencyImpl;
import net.fabricmc.loader.impl.util.Arguments;
import net.fabricmc.loader.impl.util.LoaderUtil;
import net.fabricmc.loader.impl.util.UrlUtil;
import net.fabricmc.loader.impl.util.log.Log;
import net.fabricmc.loader.impl.util.log.LogHandler;

public class MinecraftGameProvider
implements GameProvider {
    private static final String[] CLIENT_ENTRYPOINTS = new String[]{"net.minecraft.client.main.Main", "net.minecraft.client.MinecraftApplet", "com.mojang.minecraft.MinecraftApplet"};
    private static final String BUNDLER_ENTRYPOINT = "net.minecraft.bundler.Main";
    private static final String[] SERVER_ENTRYPOINTS = new String[]{"net.minecraft.bundler.Main", "net.minecraft.server.Main", "net.minecraft.server.MinecraftServer", "com.mojang.minecraft.server.MinecraftServer"};
    private static final String BUNDLER_MAIN_CLASS_PROPERTY = "bundlerMainClass";
    private static final String REALMS_CHECK_PATH = "realmsVersion";
    private static final String LOG4J_API_CHECK_PATH = "org/apache/logging/log4j/LogManager.class";
    private static final String[] LOG4J_IMPL_CHECK_PATHS = new String[]{"META-INF/services/org.apache.logging.log4j.spi.Provider", "META-INF/log4j-provider.properties"};
    private static final String LOG4J_CONFIG_CHECK_PATH = "log4j2.xml";
    private static final String LOG4J_PLUGIN_CHECK_PATH = "com/mojang/util/QueueLogAppender.class";
    private static final String[] ALLOWED_CLASS_PREFIXES = new String[]{"org.apache.logging.log4j.", "com.mojang.util."};
    private static final Set<String> SENSITIVE_ARGS = new HashSet<String>(Arrays.asList("accesstoken", "clientid", "profileproperties", "proxypass", "proxyuser", "username", "userproperties", "uuid", "xuid"));
    private EnvType envType;
    private String entrypoint;
    private Arguments arguments;
    private Path gameJar;
    private Path realmsJar;
    private final Set<Path> log4jJars = new HashSet<Path>();
    private final List<Path> miscGameLibraries = new ArrayList<Path>();
    private McVersion versionData;
    private boolean useGameJarForLogging;
    private boolean hasModLoader = false;
    private static final GameTransformer TRANSFORMER = new GameTransformer(new EntrypointPatch(), new BrandingPatch(), new EntrypointPatchFML125());

    @Override
    public String getGameId() {
        return "minecraft";
    }

    @Override
    public String getGameName() {
        return "Minecraft";
    }

    @Override
    public String getRawGameVersion() {
        return this.versionData.getRaw();
    }

    @Override
    public String getNormalizedGameVersion() {
        return this.versionData.getNormalized();
    }

    @Override
    public Collection<GameProvider.BuiltinMod> getBuiltinMods() {
        BuiltinModMetadata.Builder metadata = new BuiltinModMetadata.Builder(this.getGameId(), this.getNormalizedGameVersion()).setName(this.getGameName());
        if (this.versionData.getClassVersion().isPresent()) {
            int version = this.versionData.getClassVersion().getAsInt() - 44;
            try {
                metadata.addDependency(new ModDependencyImpl(ModDependency.Kind.DEPENDS, "java", Collections.singletonList(String.format(">=%d", version))));
            }
            catch (VersionParsingException e) {
                throw new RuntimeException(e);
            }
        }
        return Collections.singletonList(new GameProvider.BuiltinMod(this.gameJar, metadata.build()));
    }

    public Path getGameJar() {
        return this.gameJar;
    }

    @Override
    public String getEntrypoint() {
        return this.entrypoint;
    }

    @Override
    public Path getLaunchDirectory() {
        if (this.arguments == null) {
            return Paths.get(".", new String[0]);
        }
        return MinecraftGameProvider.getLaunchDirectory(this.arguments);
    }

    @Override
    public boolean isObfuscated() {
        return true;
    }

    @Override
    public boolean requiresUrlClassLoader() {
        return this.hasModLoader;
    }

    @Override
    public boolean isEnabled() {
        return System.getProperty("fabric.skipMcProvider") == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean locateGame(FabricLauncher launcher, String[] args) {
        String version;
        this.envType = launcher.getEnvironmentType();
        this.arguments = new Arguments();
        this.arguments.parse(args);
        String[] entrypointClasses = this.envType == EnvType.CLIENT ? CLIENT_ENTRYPOINTS : SERVER_ENTRYPOINTS;
        HashMap<Path, ZipFile> zipFiles = new HashMap<Path, ZipFile>();
        try {
            GameProviderHelper.FindResult result;
            String gameJarProperty = System.getProperty("fabric.gameJarPath");
            if (gameJarProperty != null) {
                Path path = Paths.get(gameJarProperty, new String[0]);
                if (!Files.exists(path, new LinkOption[0])) {
                    throw new RuntimeException("Game jar configured through fabric.gameJarPath system property doesn't exist");
                }
                result = GameProviderHelper.findFirstClass(Collections.singletonList(path), zipFiles, entrypointClasses);
            } else {
                result = GameProviderHelper.findFirstClass(launcher.getClassPath(), zipFiles, entrypointClasses);
            }
            if (result == null) {
                boolean bl = false;
                return bl;
            }
            if (result.className.equals(BUNDLER_ENTRYPOINT)) {
                this.processBundlerJar(result.path);
            } else {
                this.entrypoint = result.className;
                this.gameJar = result.path;
                result = GameProviderHelper.findFirstClass(launcher.getClassPath(), zipFiles, REALMS_CHECK_PATH);
                this.realmsJar = result != null && !result.path.equals(this.gameJar) ? result.path : null;
                result = GameProviderHelper.findFirstClass(launcher.getClassPath(), zipFiles, LOG4J_API_CHECK_PATH);
                this.useGameJarForLogging = result != null && this.gameJar.equals(result.path) || Knot.class.getClassLoader().getResource(LOG4J_CONFIG_CHECK_PATH) == null;
                result = GameProviderHelper.findFirstClass(launcher.getClassPath(), zipFiles, "ModLoader.class");
                this.hasModLoader = result != null;
            }
        }
        finally {
            for (ZipFile zf : zipFiles.values()) {
                try {
                    zf.close();
                }
                catch (IOException iOException) {}
            }
        }
        if (!this.useGameJarForLogging && this.log4jJars.isEmpty()) {
            this.setupLog4jLogHandler(launcher, false);
        }
        ObjectShare share = FabricLoaderImpl.INSTANCE.getObjectShare();
        share.put("fabric-loader:inputGameJar", this.gameJar);
        if (this.realmsJar != null) {
            share.put("fabric-loader:inputRealmsJar", this.realmsJar);
        }
        if ((version = this.arguments.remove("fabric.gameVersion")) == null) {
            version = System.getProperty("fabric.gameVersion");
        }
        this.versionData = McVersionLookup.getVersion(this.gameJar, entrypointClasses, version);
        MinecraftGameProvider.processArgumentMap(this.arguments, this.envType);
        return true;
    }

    private boolean processBundlerJar(Path path) {
        URL[] urls;
        if (this.envType != EnvType.SERVER) {
            return false;
        }
        try (URLClassLoader bundlerCl = new URLClassLoader(new URL[]{path.toUri().toURL()}, MinecraftGameProvider.class.getClassLoader()){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
                Object object = this.getClassLoadingLock(name);
                synchronized (object) {
                    Class<?> c = this.findLoadedClass(name);
                    if (c == null) {
                        URL url;
                        if (name.startsWith("net.minecraft.") && (url = this.getResource(LoaderUtil.getClassFileName(name))) != null) {
                            try (InputStream is = url.openConnection().getInputStream();){
                                int len;
                                byte[] data = new byte[Math.max(is.available() + 1, 1000)];
                                int offset = 0;
                                while ((len = is.read(data, offset, data.length - offset)) >= 0) {
                                    if ((offset += len) != data.length) continue;
                                    data = Arrays.copyOf(data, data.length * 2);
                                }
                                c = this.defineClass(name, data, 0, offset);
                            }
                            catch (IOException e) {
                                throw new RuntimeException(e);
                            }
                        }
                        if (c == null) {
                            c = this.getParent().loadClass(name);
                        }
                    }
                    if (resolve) {
                        this.resolveClass(c);
                    }
                    return c;
                }
            }
        };){
            Class<?> cls = Class.forName(BUNDLER_ENTRYPOINT, true, bundlerCl);
            Method method = cls.getMethod("main", String[].class);
            String prevProperty = System.getProperty(BUNDLER_MAIN_CLASS_PROPERTY);
            System.setProperty(BUNDLER_MAIN_CLASS_PROPERTY, BundlerClassPathCapture.class.getName());
            ClassLoader prevCl = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(bundlerCl);
            method.invoke((Object)method, new Object[]{new String[0]});
            urls = BundlerClassPathCapture.FUTURE.get(10L, TimeUnit.SECONDS);
            Thread.currentThread().setContextClassLoader(prevCl);
            if (prevProperty != null) {
                System.setProperty(BUNDLER_MAIN_CLASS_PROPERTY, prevProperty);
            } else {
                System.clearProperty(BUNDLER_MAIN_CLASS_PROPERTY);
            }
        }
        catch (ClassNotFoundException e) {
            return false;
        }
        catch (Throwable t) {
            throw new RuntimeException("Error invoking MC server bundler: " + t, t);
        }
        this.useGameJarForLogging = false;
        boolean hasGameJar = false;
        boolean hasRealmsJar = false;
        ClassLoader cl = Knot.class.getClassLoader();
        Object[] logCheckPaths = new Object[]{LOG4J_API_CHECK_PATH, LOG4J_IMPL_CHECK_PATHS, LOG4J_CONFIG_CHECK_PATH, LOG4J_PLUGIN_CHECK_PATH};
        int locatedLog4jPaths = 0;
        for (int i = 0; i < logCheckPaths.length; ++i) {
            Object logCheckPath = logCheckPaths[i];
            boolean found = false;
            if (logCheckPath instanceof String) {
                found = cl.getResource((String)logCheckPath) != null;
            } else {
                for (String p : (String[])logCheckPath) {
                    if (cl.getResource(p) == null) continue;
                    found = true;
                    break;
                }
            }
            if (!found) continue;
            locatedLog4jPaths |= 1 << i;
        }
        for (URL url : urls) {
            try {
                path = UrlUtil.asPath(url);
            }
            catch (URISyntaxException e) {
                throw new RuntimeException("invalid url: " + url);
            }
            if (hasGameJar && hasRealmsJar && Integer.bitCount(locatedLog4jPaths) == logCheckPaths.length) {
                this.miscGameLibraries.add(path);
                continue;
            }
            boolean isMiscLibrary = true;
            try (ZipFile zf = new ZipFile(path.toFile());){
                if (!hasGameJar) {
                    for (String string : SERVER_ENTRYPOINTS) {
                        if (zf.getEntry(LoaderUtil.getClassFileName(string)) == null) continue;
                        this.entrypoint = string;
                        this.gameJar = path;
                        hasGameJar = true;
                        isMiscLibrary = false;
                        break;
                    }
                }
                if (!hasRealmsJar && zf.getEntry(REALMS_CHECK_PATH) != null) {
                    if (!path.equals(this.gameJar)) {
                        this.realmsJar = path;
                    }
                    hasRealmsJar = true;
                    isMiscLibrary = false;
                }
                for (int i = 0; i < logCheckPaths.length; ++i) {
                    if ((locatedLog4jPaths & 1 << i) != 0) continue;
                    Object logCheckPath = logCheckPaths[i];
                    boolean found = false;
                    if (logCheckPath instanceof String) {
                        found = zf.getEntry((String)logCheckPath) != null;
                    } else {
                        for (String p : (String[])logCheckPath) {
                            if (zf.getEntry(p) == null) continue;
                            found = true;
                            break;
                        }
                    }
                    if (!found) continue;
                    locatedLog4jPaths |= 1 << i;
                    boolean bl = path.equals(this.gameJar);
                    this.useGameJarForLogging |= bl;
                    if (!bl) {
                        this.log4jJars.add(path);
                    }
                    isMiscLibrary = false;
                }
            }
            catch (IOException e) {
                throw new RuntimeException(String.format("Error reading %s: %s", path.toAbsolutePath(), e), e);
            }
            if (!isMiscLibrary) continue;
            this.miscGameLibraries.add(path);
        }
        if (!hasGameJar) {
            return false;
        }
        if ((locatedLog4jPaths & 3) != 3) {
            throw new UnsupportedOperationException("MC server bundler didn't yield the Log4J API and/or implementation JARs");
        }
        this.hasModLoader = false;
        return true;
    }

    private static void processArgumentMap(Arguments argMap, EnvType envType) {
        switch (envType) {
            case CLIENT: {
                if (!argMap.containsKey("accessToken")) {
                    argMap.put("accessToken", "FabricMC");
                }
                if (!argMap.containsKey("version")) {
                    argMap.put("version", "Fabric");
                }
                String versionType = "";
                if (argMap.containsKey("versionType") && !argMap.get("versionType").equalsIgnoreCase("release")) {
                    versionType = argMap.get("versionType") + "/";
                }
                argMap.put("versionType", versionType + "Fabric");
                if (argMap.containsKey("gameDir")) break;
                argMap.put("gameDir", MinecraftGameProvider.getLaunchDirectory(argMap).toAbsolutePath().normalize().toString());
                break;
            }
            case SERVER: {
                argMap.remove("version");
                argMap.remove("gameDir");
                argMap.remove("assetsDir");
            }
        }
    }

    private static Path getLaunchDirectory(Arguments argMap) {
        return Paths.get(argMap.getOrDefault("gameDir", "."), new String[0]);
    }

    @Override
    public void initialize(FabricLauncher launcher) {
        Map<String, Path> gameJars = new HashMap<String, Path>(2);
        String name = this.envType.name().toLowerCase(Locale.ENGLISH);
        gameJars.put(name, this.gameJar);
        if (this.realmsJar != null) {
            gameJars.put("realms", this.realmsJar);
        }
        if (this.isObfuscated()) {
            gameJars = GameProviderHelper.deobfuscate(gameJars, this.getGameId(), this.getNormalizedGameVersion(), this.getLaunchDirectory(), launcher);
            this.gameJar = gameJars.get(name);
            this.realmsJar = gameJars.get("realms");
        }
        if (this.useGameJarForLogging || !this.log4jJars.isEmpty()) {
            if (this.useGameJarForLogging) {
                launcher.addToClassPath(this.gameJar, ALLOWED_CLASS_PREFIXES);
            }
            if (!this.log4jJars.isEmpty()) {
                for (Path jar : this.log4jJars) {
                    launcher.addToClassPath(jar, new String[0]);
                }
            }
            this.setupLog4jLogHandler(launcher, true);
        }
        TRANSFORMER.locateEntrypoints(launcher, this.gameJar);
    }

    private void setupLog4jLogHandler(FabricLauncher launcher, boolean useTargetCl) {
        System.setProperty("log4j2.formatMsgNoLookups", "true");
        try {
            String logHandlerClsName = "net.fabricmc.loader.impl.game.minecraft.Log4jLogHandler";
            Class<?> logHandlerCls = useTargetCl ? launcher.loadIntoTarget("net.fabricmc.loader.impl.game.minecraft.Log4jLogHandler") : Class.forName("net.fabricmc.loader.impl.game.minecraft.Log4jLogHandler");
            Log.init((LogHandler)logHandlerCls.getConstructor(new Class[0]).newInstance(new Object[0]), true);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Arguments getArguments() {
        return this.arguments;
    }

    @Override
    public String[] getLaunchArguments(boolean sanitize) {
        if (this.arguments == null) {
            return new String[0];
        }
        String[] ret = this.arguments.toArray();
        if (!sanitize) {
            return ret;
        }
        int writeIdx = 0;
        for (int i = 0; i < ret.length; ++i) {
            String arg = ret[i];
            if (i + 1 < ret.length && arg.startsWith("--") && SENSITIVE_ARGS.contains(arg.substring(2).toLowerCase(Locale.ENGLISH))) {
                ++i;
                continue;
            }
            ret[writeIdx++] = arg;
        }
        if (writeIdx < ret.length) {
            ret = Arrays.copyOf(ret, writeIdx);
        }
        return ret;
    }

    @Override
    public GameTransformer getEntrypointTransformer() {
        return TRANSFORMER;
    }

    @Override
    public boolean canOpenErrorGui() {
        if (this.arguments == null || this.envType == EnvType.CLIENT) {
            return true;
        }
        List<String> extras = this.arguments.getExtraArgs();
        return !extras.contains("nogui") && !extras.contains("--nogui");
    }

    @Override
    public boolean hasAwtSupport() {
        return !LoaderUtil.hasMacOs();
    }

    @Override
    public void unlockClassPath(FabricLauncher launcher) {
        if (this.useGameJarForLogging) {
            launcher.setAllowedPrefixes(this.gameJar, new String[0]);
        } else {
            launcher.addToClassPath(this.gameJar, new String[0]);
        }
        if (this.realmsJar != null) {
            launcher.addToClassPath(this.realmsJar, new String[0]);
        }
        for (Path lib : this.miscGameLibraries) {
            launcher.addToClassPath(lib, new String[0]);
        }
    }

    @Override
    public void launch(ClassLoader loader) {
        String targetClass = this.entrypoint;
        if (this.envType == EnvType.CLIENT && targetClass.contains("Applet")) {
            targetClass = "net.fabricmc.loader.impl.game.minecraft.applet.AppletMain";
        }
        try {
            Class<?> c = loader.loadClass(targetClass);
            Method m = c.getMethod("main", String[].class);
            m.invoke(null, new Object[]{this.arguments.toArray()});
        }
        catch (InvocationTargetException e) {
            throw new FormattedException("Minecraft has crashed!", e.getCause());
        }
        catch (ReflectiveOperationException e) {
            throw new FormattedException("Failed to start Minecraft", e);
        }
    }
}

