/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loader.impl.game.patch;

import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.fabricmc.loader.impl.game.patch.GamePatch;
import net.fabricmc.loader.impl.launch.FabricLauncher;
import net.fabricmc.loader.impl.util.LoaderUtil;
import net.fabricmc.loader.impl.util.log.Log;
import net.fabricmc.loader.impl.util.log.LogCategory;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.ClassNode;

public class GameTransformer {
    private final List<GamePatch> patches;
    private Map<String, byte[]> patchedClasses;
    private boolean entrypointsLocated = false;

    public GameTransformer(GamePatch ... patches) {
        this.patches = Arrays.asList(patches);
    }

    private void addPatchedClass(ClassNode node) {
        String key = node.name.replace('/', '.');
        if (this.patchedClasses.containsKey(key)) {
            throw new RuntimeException("Duplicate addPatchedClasses call: " + key);
        }
        ClassWriter writer = new ClassWriter(0);
        node.accept((ClassVisitor)writer);
        this.patchedClasses.put(key, writer.toByteArray());
    }

    public void locateEntrypoints(FabricLauncher launcher, Path gameJar) {
        if (this.entrypointsLocated) {
            return;
        }
        this.patchedClasses = new HashMap<String, byte[]>();
        try (ZipFile zf = new ZipFile(gameJar.toFile());){
            Function<String, ClassReader> classSource = name -> {
                ClassReader classReader;
                block10: {
                    byte[] data = this.patchedClasses.get(name);
                    if (data != null) {
                        return new ClassReader(data);
                    }
                    ZipEntry entry = zf.getEntry(LoaderUtil.getClassFileName(name));
                    if (entry == null) {
                        return null;
                    }
                    InputStream is = zf.getInputStream(entry);
                    try {
                        classReader = new ClassReader(is);
                        if (is == null) break block10;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (is != null) {
                                try {
                                    is.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (IOException e) {
                            throw new UncheckedIOException(String.format("error reading %s in %s: %s", name, gameJar.toAbsolutePath(), e), e);
                        }
                    }
                    is.close();
                }
                return classReader;
            };
            for (GamePatch patch : this.patches) {
                patch.process(launcher, classSource, this::addPatchedClass);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(String.format("error reading %s: %s", gameJar.toAbsolutePath(), e), e);
        }
        Log.debug(LogCategory.GAME_PATCH, "Patched %d class%s", this.patchedClasses.size(), this.patchedClasses.size() != 1 ? "s" : "");
        this.entrypointsLocated = true;
    }

    public byte[] transform(String className) {
        return this.patchedClasses.get(className);
    }
}

