/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loader.impl.launch;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import net.fabricmc.loader.impl.launch.FabricLauncherBase;
import net.fabricmc.loader.impl.util.log.Log;
import net.fabricmc.loader.impl.util.log.LogCategory;
import net.fabricmc.mapping.tree.TinyMappingFactory;
import net.fabricmc.mapping.tree.TinyTree;

public class MappingConfiguration {
    private static TinyTree mappings;
    private static boolean checkedMappings;

    public TinyTree getMappings() {
        if (!checkedMappings) {
            InputStream mappingStream = FabricLauncherBase.class.getClassLoader().getResourceAsStream("mappings/mappings.tiny");
            if (mappingStream != null) {
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(mappingStream));){
                    long time = System.currentTimeMillis();
                    mappings = TinyMappingFactory.loadWithDetection((BufferedReader)reader);
                    Log.debug(LogCategory.MAPPINGS, "Loading mappings took %d ms", System.currentTimeMillis() - time);
                }
                catch (IOException ee) {
                    ee.printStackTrace();
                }
                try {
                    mappingStream.close();
                }
                catch (IOException ee) {
                    ee.printStackTrace();
                }
            }
            if (mappings == null) {
                Log.info(LogCategory.MAPPINGS, "Mappings not present!");
                mappings = TinyMappingFactory.EMPTY_TREE;
            }
            checkedMappings = true;
        }
        return mappings;
    }

    public String getTargetNamespace() {
        return FabricLauncherBase.getLauncher().isDevelopment() ? "named" : "intermediary";
    }

    public boolean requiresPackageAccessHack() {
        return this.getTargetNamespace().equals("named");
    }
}

