/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loader.impl.launch.knot;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.CodeSource;
import java.security.SecureClassLoader;
import java.util.Enumeration;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.loader.impl.game.GameProvider;
import net.fabricmc.loader.impl.launch.knot.DummyClassLoader;
import net.fabricmc.loader.impl.launch.knot.KnotClassDelegate;
import net.fabricmc.loader.impl.launch.knot.KnotClassLoaderInterface;

final class KnotClassLoader
extends SecureClassLoader
implements KnotClassLoaderInterface {
    private final DynamicURLClassLoader urlLoader;
    private final ClassLoader originalLoader = this.getClass().getClassLoader();
    private final KnotClassDelegate delegate;

    KnotClassLoader(boolean isDevelopment, EnvType envType, GameProvider provider) {
        super(new DynamicURLClassLoader(new URL[0]));
        this.urlLoader = (DynamicURLClassLoader)this.getParent();
        this.delegate = new KnotClassDelegate(isDevelopment, envType, this, provider);
    }

    @Override
    public KnotClassDelegate getDelegate() {
        return this.delegate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isClassLoaded(String name) {
        Object object = this.getClassLoadingLock(name);
        synchronized (object) {
            return this.findLoadedClass(name) != null;
        }
    }

    @Override
    public URL getResource(String name) {
        Objects.requireNonNull(name);
        URL url = this.urlLoader.getResource(name);
        if (url == null) {
            url = this.originalLoader.getResource(name);
        }
        return url;
    }

    @Override
    public URL findResource(String name) {
        Objects.requireNonNull(name);
        return this.urlLoader.findResource(name);
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        Objects.requireNonNull(name);
        InputStream inputStream = this.urlLoader.getResourceAsStream(name);
        if (inputStream == null) {
            inputStream = this.originalLoader.getResourceAsStream(name);
        }
        return inputStream;
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        Objects.requireNonNull(name);
        final Enumeration<URL> first = this.urlLoader.getResources(name);
        final Enumeration<URL> second = this.originalLoader.getResources(name);
        return new Enumeration<URL>(){
            Enumeration<URL> current;
            {
                this.current = first;
            }

            @Override
            public boolean hasMoreElements() {
                if (this.current == null) {
                    return false;
                }
                if (this.current.hasMoreElements()) {
                    return true;
                }
                return this.current == first && second.hasMoreElements();
            }

            @Override
            public URL nextElement() {
                if (this.current == null) {
                    return null;
                }
                if (!this.current.hasMoreElements()) {
                    if (this.current == first) {
                        this.current = second;
                    } else {
                        this.current = null;
                        return null;
                    }
                }
                return this.current.nextElement();
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Object object = this.getClassLoadingLock(name);
        synchronized (object) {
            Class<?> c = this.findLoadedClass(name);
            if (c == null && (c = this.delegate.tryLoadClass(name, false)) == null) {
                c = this.originalLoader.loadClass(name);
            }
            if (resolve) {
                this.resolveClass(c);
            }
            return c;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Class<?> loadIntoTarget(String name) throws ClassNotFoundException {
        Object object = this.getClassLoadingLock(name);
        synchronized (object) {
            Class<?> c = this.findLoadedClass(name);
            if (c == null && (c = this.delegate.tryLoadClass(name, true)) == null) {
                throw new ClassNotFoundException("can't find class " + name);
            }
            this.resolveClass(c);
            return c;
        }
    }

    @Override
    public void addURL(URL url) {
        this.urlLoader.addURL(url);
    }

    @Override
    public InputStream getResourceAsStream(String classFile, boolean allowFromParent) throws IOException {
        InputStream inputStream = this.urlLoader.getResourceAsStream(classFile);
        if (inputStream == null && allowFromParent) {
            inputStream = this.originalLoader.getResourceAsStream(classFile);
        }
        return inputStream;
    }

    @Override
    public Package getPackage(String name) {
        return super.getPackage(name);
    }

    @Override
    public Package definePackage(String name, String specTitle, String specVersion, String specVendor, String implTitle, String implVersion, String implVendor, URL sealBase) throws IllegalArgumentException {
        return super.definePackage(name, specTitle, specVersion, specVendor, implTitle, implVersion, implVendor, sealBase);
    }

    @Override
    public Class<?> defineClassFwd(String name, byte[] b, int off, int len, CodeSource cs) {
        return super.defineClass(name, b, off, len, cs);
    }

    static {
        KnotClassLoader.registerAsParallelCapable();
    }

    private static class DynamicURLClassLoader
    extends URLClassLoader {
        private DynamicURLClassLoader(URL[] urls) {
            super(urls, (ClassLoader)new DummyClassLoader());
        }

        @Override
        public void addURL(URL url) {
            super.addURL(url);
        }

        static {
            DynamicURLClassLoader.registerAsParallelCapable();
        }
    }
}

