/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loader.impl.metadata;

import java.util.ArrayList;
import java.util.List;
import net.fabricmc.loader.impl.lib.gson.JsonReader;

public class ParseMetadataException
extends Exception {
    private List<String> modPaths;

    public ParseMetadataException(String message) {
        super(message);
    }

    public ParseMetadataException(String message, JsonReader reader) {
        this(message + " Error was located at: " + reader.locationString());
    }

    public ParseMetadataException(String message, Throwable throwable) {
        super(message, throwable);
    }

    public ParseMetadataException(Throwable t) {
        super(t);
    }

    void setModPaths(String modPath, List<String> modParentPaths) {
        this.modPaths = new ArrayList<String>(modParentPaths);
        this.modPaths.add(modPath);
    }

    @Override
    public String getMessage() {
        String ret = "Error reading fabric.mod.json file for mod at ";
        ret = this.modPaths == null ? ret + "unknown location" : ret + String.join((CharSequence)" -> ", this.modPaths);
        String msg = super.getMessage();
        if (msg != null) {
            ret = ret + ": " + msg;
        }
        return ret;
    }

    public static class MissingField
    extends ParseMetadataException {
        public MissingField(String field) {
            super(String.format("Missing required field \"%s\".", field));
        }
    }
}

