/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loader.impl.util;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.jar.Attributes;
import java.util.jar.Manifest;

public final class ManifestUtil {
    public static Manifest readManifest(Path basePath) throws IOException {
        Path path = basePath.resolve("META-INF").resolve("MANIFEST.MF");
        if (!Files.exists(path, new LinkOption[0])) {
            return null;
        }
        try (InputStream stream = Files.newInputStream(path, new OpenOption[0]);){
            Manifest manifest = new Manifest(stream);
            return manifest;
        }
    }

    public static String getManifestValue(Manifest manifest, Attributes.Name name) {
        return manifest.getMainAttributes().getValue(name);
    }
}

