/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import net.fabricmc.api.EnvType;
import net.minecraft.class_3545;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class RoughlyEnoughItemsState {
    public static final Logger LOGGER = LogManager.getFormatterLogger((String)"REI");
    public static EnvType env;
    public static boolean isDev;
    private static List<class_3545<String, String>> errors;
    private static List<class_3545<String, String>> warnings;
    private static Set<String> errorSet;
    private static Set<String> warningSet;
    private static List<Runnable> continueCallbacks;

    private RoughlyEnoughItemsState() {
    }

    public static void error(String reason) {
        if (env == EnvType.SERVER || isDev) {
            throw new RuntimeException(reason);
        }
        if (errorSet.add(reason + " null")) {
            errors.add((class_3545<String, String>)new class_3545((Object)reason, null));
            LOGGER.error(reason);
        }
    }

    public static void error(String reason, String link) {
        if (env == EnvType.SERVER || isDev) {
            throw new RuntimeException(reason + " " + link);
        }
        if (errorSet.add(reason + " " + link)) {
            errors.add((class_3545<String, String>)new class_3545((Object)reason, (Object)link));
            LOGGER.error(reason + " " + link);
        }
    }

    public static void warn(String reason) {
        if (warningSet.add(reason + " null")) {
            warnings.add((class_3545<String, String>)new class_3545((Object)reason, null));
            LOGGER.warn(reason);
        }
    }

    public static void warn(String reason, String link) {
        if (warningSet.add(reason + " " + link)) {
            warnings.add((class_3545<String, String>)new class_3545((Object)reason, (Object)link));
            LOGGER.warn(reason + " " + link);
        }
    }

    public static void onContinue(Runnable runnable) {
        continueCallbacks.add(runnable);
    }

    public static List<class_3545<String, String>> getErrors() {
        return errors;
    }

    public static List<class_3545<String, String>> getWarnings() {
        return warnings;
    }

    public static void clear() {
        errors.clear();
        errorSet.clear();
        warnings.clear();
        warningSet.clear();
    }

    public static void continues() {
        for (Runnable callback : continueCallbacks) {
            try {
                callback.run();
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
        continueCallbacks.clear();
    }

    static {
        errors = new ArrayList<class_3545<String, String>>();
        warnings = new ArrayList<class_3545<String, String>>();
        errorSet = new LinkedHashSet<String>();
        warningSet = new LinkedHashSet<String>();
        continueCallbacks = new ArrayList<Runnable>();
    }
}

