/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.entry.filtering.rules;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import me.shedaniel.rei.api.client.search.SearchFilter;
import me.shedaniel.rei.api.client.search.SearchProvider;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.util.CollectionUtils;
import me.shedaniel.rei.impl.client.config.entries.FilteringEntry;
import me.shedaniel.rei.impl.client.config.entries.FilteringRuleOptionsScreen;
import me.shedaniel.rei.impl.client.entry.filtering.AbstractFilteringRule;
import me.shedaniel.rei.impl.client.entry.filtering.FilteringCache;
import me.shedaniel.rei.impl.client.entry.filtering.FilteringContext;
import me.shedaniel.rei.impl.client.entry.filtering.FilteringResult;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_437;
import net.minecraft.class_5348;

@Environment(value=EnvType.CLIENT)
public class SearchFilteringRule
extends AbstractFilteringRule<SearchFilteringRule> {
    private SearchFilter filter;
    private boolean show;

    public SearchFilteringRule() {
    }

    public SearchFilteringRule(SearchFilter filter, boolean show) {
        this.filter = filter;
        this.show = show;
    }

    @Override
    public class_2487 save(class_2487 tag) {
        tag.method_10582("filter", this.filter.getFilter());
        tag.method_10556("show", this.show);
        return tag;
    }

    @Override
    public SearchFilteringRule createFromTag(class_2487 tag) {
        String filter = tag.method_10558("filter");
        boolean show = tag.method_10577("show");
        return new SearchFilteringRule(SearchProvider.getInstance().createFilter(filter), show);
    }

    @Override
    public FilteringResult processFilteredStacks(FilteringContext context, FilteringCache cache, boolean async) {
        ArrayList completableFutures = Lists.newArrayList();
        this.processList(context.getUnsetStacks(), completableFutures);
        if (this.show) {
            this.processList(context.getHiddenStacks(), completableFutures);
        } else {
            this.processList(context.getShownStacks(), completableFutures);
        }
        try {
            CompletableFuture.allOf(completableFutures.toArray(new CompletableFuture[0])).get(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            e.printStackTrace();
        }
        FilteringResult result = FilteringResult.create();
        for (CompletableFuture future : completableFutures) {
            List now = future.getNow(null);
            if (now == null) continue;
            if (this.show) {
                result.show(now);
                continue;
            }
            result.hide(now);
        }
        return result;
    }

    @Override
    public SearchFilteringRule createNew() {
        return new SearchFilteringRule(SearchFilter.matchAll(), true);
    }

    private void processList(Collection<EntryStack<?>> stacks, List<CompletableFuture<List<EntryStack<?>>>> completableFutures) {
        for (Iterable iterable : CollectionUtils.partition((List)stacks, 100)) {
            completableFutures.add(CompletableFuture.supplyAsync(() -> {
                ArrayList output = Lists.newArrayList();
                for (EntryStack stack : partitionStacks) {
                    if (stack == null || !this.filter.test(stack)) continue;
                    output.add(stack);
                }
                return output;
            }));
        }
    }

    @Override
    public class_2561 getTitle() {
        return new class_2588("rule.roughlyenoughitems.filtering.search");
    }

    @Override
    public class_2561 getSubtitle() {
        return new class_2588("rule.roughlyenoughitems.filtering.search.subtitle");
    }

    @Override
    public Optional<BiFunction<FilteringEntry, class_437, class_437>> createEntryScreen() {
        return Optional.of((entry, screen) -> new FilteringRuleOptionsScreen<SearchFilteringRule>(entry, this, screen){
            FilteringRuleOptionsScreen.TextFieldRuleEntry entry;
            FilteringRuleOptionsScreen.BooleanRuleEntry show;
            {
                this.entry = null;
                this.show = null;
            }

            @Override
            public void addEntries(Consumer<FilteringRuleOptionsScreen.RuleEntry> entryConsumer) {
                this.addEmpty(entryConsumer, 10);
                this.addText(entryConsumer, (class_5348)new class_2588("rule.roughlyenoughitems.filtering.search.filter").method_27692(class_124.field_1080));
                this.entry = new FilteringRuleOptionsScreen.TextFieldRuleEntry(this.field_22789 - 36, this.rule, widget -> {
                    widget.method_1880(9999);
                    if (this.entry != null) {
                        widget.method_1852(this.entry.getWidget().method_1882());
                    } else {
                        widget.method_1852(((SearchFilteringRule)this.rule).filter.getFilter());
                    }
                });
                entryConsumer.accept(this.entry);
                this.addEmpty(entryConsumer, 10);
                this.addText(entryConsumer, (class_5348)new class_2588("rule.roughlyenoughitems.filtering.search.show").method_27692(class_124.field_1080));
                this.show = new FilteringRuleOptionsScreen.BooleanRuleEntry(this.field_22789 - 36, this.show == null ? ((SearchFilteringRule)this.rule).show : this.show.getBoolean(), this.rule, bool -> new class_2588("rule.roughlyenoughitems.filtering.search.show." + bool));
                entryConsumer.accept(this.show);
            }

            @Override
            public void save() {
                ((SearchFilteringRule)this.rule).filter = SearchProvider.getInstance().createFilter(this.entry.getWidget().method_1882());
                ((SearchFilteringRule)this.rule).show = this.show.getBoolean();
            }
        });
    }
}

