/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.registry.screen;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import dev.architectury.event.CompoundEventResult;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.gui.config.DisplayPanelLocation;
import me.shedaniel.rei.api.client.gui.drag.DraggableStackProvider;
import me.shedaniel.rei.api.client.gui.drag.DraggableStackProviderWidget;
import me.shedaniel.rei.api.client.gui.drag.DraggableStackVisitor;
import me.shedaniel.rei.api.client.gui.drag.DraggableStackVisitorWidget;
import me.shedaniel.rei.api.client.gui.widgets.Widgets;
import me.shedaniel.rei.api.client.plugins.REIClientPlugin;
import me.shedaniel.rei.api.client.registry.screen.ClickArea;
import me.shedaniel.rei.api.client.registry.screen.DisplayBoundsProvider;
import me.shedaniel.rei.api.client.registry.screen.ExclusionZones;
import me.shedaniel.rei.api.client.registry.screen.FocusedStackProvider;
import me.shedaniel.rei.api.client.registry.screen.OverlayDecider;
import me.shedaniel.rei.api.client.registry.screen.ScreenRegistry;
import me.shedaniel.rei.api.client.registry.screen.SimpleClickArea;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.registry.ReloadStage;
import me.shedaniel.rei.api.common.util.CollectionUtils;
import me.shedaniel.rei.api.common.util.EntryStacks;
import me.shedaniel.rei.impl.client.registry.screen.ExclusionZonesImpl;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1041;
import net.minecraft.class_1269;
import net.minecraft.class_1703;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_465;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableObject;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
@Environment(value=EnvType.CLIENT)
public class ScreenRegistryImpl
implements ScreenRegistry {
    private Multimap<Class<? extends class_437>, ClickArea<?>> clickAreas = HashMultimap.create();
    private List<DraggableStackProvider<class_437>> draggableStacksProviders = new ArrayList<DraggableStackProvider<class_437>>();
    private List<DraggableStackVisitor<class_437>> draggableStacksVisitors = new ArrayList<DraggableStackVisitor<class_437>>();
    private List<FocusedStackProvider> focusedStackProviders = new ArrayList<FocusedStackProvider>();
    private List<OverlayDecider> deciders = new ArrayList<OverlayDecider>();
    private Map<Class<?>, List<OverlayDecider>> cache = new HashMap();
    private ExclusionZones exclusionZones;
    private Class<? extends class_437> tmpScreen;

    @Override
    public ReloadStage getStage() {
        return ReloadStage.START;
    }

    @Override
    public void acceptPlugin(REIClientPlugin plugin) {
        plugin.registerScreens(this);
        plugin.registerExclusionZones(this.exclusionZones());
    }

    @Override
    public <R extends class_437> List<OverlayDecider> getDeciders(R screen) {
        if (screen == null) {
            return Collections.emptyList();
        }
        Class<?> screenClass = screen.getClass();
        List<OverlayDecider> possibleCached = this.cache.get(screenClass);
        if (possibleCached != null) {
            return possibleCached;
        }
        this.tmpScreen = screenClass;
        List<OverlayDecider> deciders = CollectionUtils.filterToList(this.deciders, this::filterResponsible);
        this.cache.put(screenClass, deciders);
        this.tmpScreen = null;
        return deciders;
    }

    private boolean filterResponsible(OverlayDecider handler) {
        return handler.isHandingScreen(this.tmpScreen);
    }

    @Override
    public List<OverlayDecider> getDeciders() {
        return Collections.unmodifiableList(this.deciders);
    }

    @Override
    public <T extends class_437> Rectangle getScreenBounds(T screen) {
        for (OverlayDecider decider : this.getDeciders(screen)) {
            if (!(decider instanceof DisplayBoundsProvider)) continue;
            return ((DisplayBoundsProvider)decider).getScreenBounds(screen);
        }
        return new Rectangle();
    }

    @Override
    public <T extends class_437> Rectangle getOverlayBounds(DisplayPanelLocation location, T screen) {
        class_1041 window = class_310.method_1551().method_22683();
        int scaledWidth = window.method_4486();
        int scaledHeight = window.method_4502();
        Rectangle screenBounds = this.getScreenBounds(screen);
        if (screenBounds.isEmpty()) {
            return new Rectangle();
        }
        if (location == DisplayPanelLocation.LEFT) {
            if (screenBounds.x < 10) {
                return new Rectangle();
            }
            return new Rectangle(2, 0, screenBounds.x - 2, scaledHeight);
        }
        if (scaledWidth - screenBounds.getMaxX() < 10) {
            return new Rectangle();
        }
        return new Rectangle(screenBounds.getMaxX() + 2, 0, scaledWidth - screenBounds.getMaxX() - 4, scaledHeight);
    }

    @Override
    @Nullable
    public <T extends class_437> EntryStack<?> getFocusedStack(T screen, Point mouse) {
        for (FocusedStackProvider provider : this.focusedStackProviders) {
            CompoundEventResult<EntryStack<?>> result = Objects.requireNonNull(provider.provide(screen, mouse));
            if (result.isTrue()) {
                if (result != null && !((EntryStack)result.object()).isEmpty()) {
                    return (EntryStack)result.object();
                }
                return null;
            }
            if (!result.isFalse()) continue;
            return null;
        }
        return null;
    }

    @Override
    public void registerDecider(OverlayDecider decider) {
        this.deciders.add(decider);
        this.deciders.sort(Comparator.reverseOrder());
        this.cache.clear();
        this.tmpScreen = null;
        this.registerDraggableStackProvider(DraggableStackProviderWidget.from(context -> Widgets.walk(context.getScreen().method_25396(), DraggableStackProviderWidget.class::isInstance)));
        this.registerDraggableStackVisitor(DraggableStackVisitorWidget.from(context -> Widgets.walk(context.getScreen().method_25396(), DraggableStackVisitorWidget.class::isInstance)));
    }

    @Override
    public void registerFocusedStack(FocusedStackProvider provider) {
        this.focusedStackProviders.add(provider);
        this.focusedStackProviders.sort(Comparator.reverseOrder());
    }

    @Override
    public <T extends class_437> void registerDraggableStackProvider(DraggableStackProvider<T> provider) {
        this.draggableStacksProviders.add(provider);
        this.draggableStacksProviders.sort(Comparator.reverseOrder());
    }

    @Override
    public <T extends class_437> void registerDraggableStackVisitor(DraggableStackVisitor<T> visitor) {
        this.draggableStacksVisitors.add(visitor);
        this.draggableStacksVisitors.sort(Comparator.reverseOrder());
    }

    @Override
    public Iterable<DraggableStackProvider<class_437>> getDraggableProviders() {
        return Collections.unmodifiableList(this.draggableStacksProviders);
    }

    @Override
    public Iterable<DraggableStackVisitor<class_437>> getDraggableVisitors() {
        return Collections.unmodifiableList(this.draggableStacksVisitors);
    }

    @Override
    public ExclusionZones exclusionZones() {
        return this.exclusionZones;
    }

    @Override
    public <C extends class_1703, T extends class_465<C>> void registerContainerClickArea(SimpleClickArea<T> area, Class<? extends T> screenClass, CategoryIdentifier<?> ... categories) {
        this.registerClickArea(screen -> {
            Rectangle rectangle = area.provide(screen).clone();
            rectangle.translate(screen.field_2776, screen.field_2800);
            return rectangle;
        }, screenClass, categories);
    }

    @Override
    public <T extends class_437> void registerClickArea(Class<? extends T> screenClass, ClickArea<T> area) {
        this.clickAreas.put(screenClass, area);
    }

    @Override
    @Nullable
    public <T extends class_437> Set<CategoryIdentifier<?>> handleClickArea(Class<T> screenClass, ClickArea.ClickAreaContext<T> context) {
        MutableObject categories = new MutableObject(null);
        for (ClickArea area : this.clickAreas.get(screenClass)) {
            ClickArea.Result result = area.handle(context);
            if (!result.isSuccessful()) continue;
            if (categories.getValue() == null) {
                categories.setValue(new LinkedHashSet());
            }
            result.getCategories().collect(Collectors.toCollection(() -> ((Mutable)categories).getValue()));
        }
        return (Set)categories.getValue();
    }

    @Override
    public void startReload() {
        this.clickAreas.clear();
        this.deciders.clear();
        this.cache.clear();
        this.focusedStackProviders.clear();
        this.draggableStacksProviders.clear();
        this.draggableStacksVisitors.clear();
        this.tmpScreen = null;
        this.registerDefault();
    }

    private void registerDefault() {
        this.exclusionZones = new ExclusionZonesImpl();
        this.registerDecider(this.exclusionZones);
        this.registerDecider(new OverlayDecider(){

            @Override
            public <R extends class_437> boolean isHandingScreen(Class<R> screen) {
                return true;
            }

            @Override
            public class_1269 shouldScreenBeOverlaid(Class<?> screen) {
                return class_465.class.isAssignableFrom(screen) ? class_1269.field_5812 : class_1269.field_5811;
            }

            @Override
            public double getPriority() {
                return -10.0;
            }
        });
        this.registerFocusedStack(new FocusedStackProvider(){

            @Override
            public CompoundEventResult<EntryStack<?>> provide(class_437 screen, Point mouse) {
                if (screen instanceof class_465) {
                    class_465 containerScreen = (class_465)screen;
                    if (containerScreen.field_2787 != null && !containerScreen.field_2787.method_7677().method_7960()) {
                        return CompoundEventResult.interruptTrue(EntryStacks.of(containerScreen.field_2787.method_7677()));
                    }
                }
                return CompoundEventResult.pass();
            }

            @Override
            public double getPriority() {
                return -10.0;
            }
        });
    }
}

