/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.search.argument.type;

import java.util.ConcurrentModificationException;
import java.util.Locale;
import java.util.StringJoiner;
import me.shedaniel.math.Point;
import me.shedaniel.rei.api.client.config.ConfigObject;
import me.shedaniel.rei.api.client.gui.config.SearchMode;
import me.shedaniel.rei.api.client.gui.widgets.Tooltip;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.impl.client.search.argument.type.ArgumentType;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2583;
import net.minecraft.class_3902;
import net.minecraft.class_5251;
import org.apache.commons.lang3.mutable.Mutable;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
@Environment(value=EnvType.CLIENT)
public final class TooltipArgumentType
extends ArgumentType<class_3902, String> {
    public static final TooltipArgumentType INSTANCE = new TooltipArgumentType();
    private static final class_2583 STYLE = class_2583.field_24360.method_27703(class_5251.method_27717((int)16769197));

    @Override
    public String getName() {
        return "tooltip";
    }

    @Override
    @Nullable
    public String getPrefix() {
        return "#";
    }

    @Override
    public class_2583 getHighlightedStyle() {
        return STYLE;
    }

    @Override
    public SearchMode getSearchMode() {
        return ConfigObject.getInstance().getTooltipSearchMode();
    }

    @Override
    public boolean matches(Mutable<String> data, EntryStack<?> stack, String searchText, class_3902 filterData) {
        String tooltip;
        if (data.getValue() == null) {
            tooltip = TooltipArgumentType.tryGetEntryStackTooltip(stack, 0);
            if (tooltip == null) {
                return false;
            }
            data.setValue((Object)tooltip.toLowerCase(Locale.ROOT));
        }
        return (tooltip = (String)data.getValue()).isEmpty() || tooltip.contains(searchText);
    }

    @Nullable
    public static String tryGetEntryStackTooltip(EntryStack<?> stack, int attempt) {
        try {
            Tooltip tooltip = stack.getTooltip(new Point(), false);
            if (tooltip != null) {
                StringJoiner joiner = new StringJoiner("\n");
                for (Tooltip.Entry entry : tooltip.entries()) {
                    if (!entry.isText()) continue;
                    joiner.add(entry.getAsText().getString());
                }
                return joiner.toString();
            }
            return "";
        }
        catch (Throwable throwable) {
            Throwable temp = throwable;
            while (temp != null) {
                if (!((temp = temp.getCause()) instanceof ConcurrentModificationException)) continue;
                if (attempt < 10) {
                    return TooltipArgumentType.tryGetEntryStackTooltip(stack, attempt + 1);
                }
                return null;
            }
            throw throwable;
        }
    }

    @Override
    public class_3902 prepareSearchFilter(String searchText) {
        return class_3902.field_17274;
    }

    private TooltipArgumentType() {
    }
}

