/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.common.entry.comparison;

import com.google.common.base.Predicates;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import me.shedaniel.rei.api.common.entry.comparison.ComparisonContext;
import me.shedaniel.rei.api.common.entry.comparison.EntryComparator;
import me.shedaniel.rei.impl.Internals;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import org.jetbrains.annotations.Nullable;

public enum NbtHasherProviderImpl implements Internals.NbtHasherProvider
{
    INSTANCE;

    private final EntryComparator<class_2520> defaultHasher = this._provide(new String[0]);

    @Override
    public EntryComparator<class_2520> provide(String ... ignoredKeys) {
        if (ignoredKeys == null || ignoredKeys.length == 0) {
            return this.defaultHasher;
        }
        return this._provide(ignoredKeys);
    }

    private EntryComparator<class_2520> _provide(String ... ignoredKeys) {
        return new Hasher(ignoredKeys);
    }

    private static class Hasher
    implements EntryComparator<class_2520> {
        private final Predicate<String> filter;

        private Hasher(@Nullable String[] ignoredKeys) {
            if (ignoredKeys == null || ignoredKeys.length == 0) {
                this.filter = key -> true;
            } else if (ignoredKeys.length == 1) {
                String s = ignoredKeys[0];
                this.filter = key -> !Objects.equals(s, key);
            } else {
                HashSet<String> set = new HashSet<String>(Arrays.asList(ignoredKeys));
                this.filter = Predicates.not(set::contains);
            }
        }

        private boolean shouldHash(String key) {
            return this.filter.test(key);
        }

        @Override
        public long hash(ComparisonContext context, class_2520 value) {
            return this.hashTag(value);
        }

        private int hashTag(class_2520 tag) {
            if (tag == null) {
                return 0;
            }
            if (tag instanceof class_2499) {
                class_2499 list = (class_2499)tag;
                return this.hashListTag(list);
            }
            if (tag instanceof class_2487) {
                class_2487 compound = (class_2487)tag;
                return this.hashCompoundTag(compound);
            }
            return tag.hashCode();
        }

        private int hashListTag(class_2499 tag) {
            int i = tag.size();
            for (class_2520 innerTag : tag) {
                i = i * 31 + this.hashTag(innerTag);
            }
            return i;
        }

        private int hashCompoundTag(class_2487 tag) {
            int i = 1;
            for (Map.Entry entry : tag.field_11515.entrySet()) {
                if (!this.shouldHash((String)entry.getKey())) continue;
                i = i * 31 + (Objects.hashCode(entry.getKey()) ^ this.hashTag((class_2520)entry.getValue()));
            }
            return i;
        }
    }
}

