/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.immediatelyfast;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.lang.reflect.Field;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.loader.api.FabricLoader;
import net.raphimc.immediatelyfast.compat.IrisCompat;
import net.raphimc.immediatelyfast.feature.core.ImmediatelyFastConfig;
import net.raphimc.immediatelyfast.feature.core.ImmediatelyFastRuntimeConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sun.misc.Unsafe;

public class ImmediatelyFast
implements ClientModInitializer {
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"ImmediatelyFast");
    public static final Unsafe UNSAFE = ImmediatelyFast.getUnsafe();
    public static ImmediatelyFastConfig config;
    public static ImmediatelyFastRuntimeConfig runtimeConfig;

    public void onInitializeClient() {
        FabricLoader.getInstance().getModContainer("immediatelyfast").ifPresent(modContainer -> LOGGER.info("Loading ImmediatelyFast " + modContainer.getMetadata().getVersion().getFriendlyString()));
        if (!ImmediatelyFast.config.debug_only_and_not_recommended_disable_mod_conflict_handling) {
            FabricLoader.getInstance().getModContainer("iris").ifPresent(modContainer -> {
                LOGGER.info("Found Iris " + modContainer.getMetadata().getVersion().getFriendlyString() + ". Enabling compatibility.");
                IrisCompat.init();
            });
        }
    }

    public static void loadConfig() {
        File configFile = FabricLoader.getInstance().getConfigDir().resolve("immediatelyfast.json").toFile();
        if (configFile.exists()) {
            try {
                config = (ImmediatelyFastConfig)new Gson().fromJson((Reader)new FileReader(configFile), ImmediatelyFastConfig.class);
            }
            catch (Throwable e) {
                LOGGER.error("Failed to load ImmediatelyFast config. Resetting it.", e);
            }
        }
        if (config == null) {
            config = new ImmediatelyFastConfig();
        }
        try {
            Files.writeString(configFile.toPath(), (CharSequence)new GsonBuilder().setPrettyPrinting().create().toJson((Object)config), new OpenOption[0]);
        }
        catch (Throwable e) {
            LOGGER.error("Failed to save ImmediatelyFast config.", e);
        }
        ImmediatelyFast.resetRuntimeConfig();
    }

    public static void resetRuntimeConfig() {
        runtimeConfig = new ImmediatelyFastRuntimeConfig(config);
    }

    private static Unsafe getUnsafe() {
        try {
            for (Field field : Unsafe.class.getDeclaredFields()) {
                if (!field.getType().equals(Unsafe.class)) continue;
                field.setAccessible(true);
                return (Unsafe)field.get(null);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        throw new IllegalStateException("Unable to get Unsafe instance");
    }
}

