/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.immediatelyfast.feature.batching;

import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import java.util.Map;
import net.minecraft.class_1921;
import net.minecraft.class_287;
import net.minecraft.class_4597;
import net.raphimc.immediatelyfast.ImmediatelyFast;
import net.raphimc.immediatelyfast.feature.batching.ItemModelBatchableImmediate;
import net.raphimc.immediatelyfast.feature.batching.RenderSystemState;
import net.raphimc.immediatelyfast.feature.core.BatchableImmediate;

public class BatchingBuffers {
    public static class_4597 FILL_CONSUMER = null;
    public static class_4597 TEXTURE_CONSUMER = null;
    public static class_4597 TEXT_CONSUMER = null;
    public static class_4597 LIT_ITEM_MODEL_CONSUMER = null;
    public static class_4597 UNLIT_ITEM_MODEL_CONSUMER = null;
    public static class_4597 ITEM_OVERLAY_CONSUMER = null;
    private static final BatchableImmediate HUD_BATCH = new BatchableImmediate();
    private static final BatchableImmediate LIT_ITEM_MODEL_BATCH = new ItemModelBatchableImmediate(true);
    private static final BatchableImmediate UNLIT_ITEM_MODEL_BATCH = new ItemModelBatchableImmediate(false);
    private static final BatchableImmediate ITEM_OVERLAY_BATCH = new BatchableImmediate();

    public static void beginHudBatching() {
        if (HUD_BATCH.hasActiveLayers()) {
            ImmediatelyFast.LOGGER.warn("HUD batching was already active! endHudBatching() was not called before beginHudBatching(). This will cause rendering issues.");
            HUD_BATCH.close();
        }
        FILL_CONSUMER = HUD_BATCH;
        TEXTURE_CONSUMER = HUD_BATCH;
        TEXT_CONSUMER = HUD_BATCH;
        BatchingBuffers.beginItemModelBatching();
        BatchingBuffers.beginItemOverlayBatching();
    }

    public static void endHudBatching() {
        FILL_CONSUMER = null;
        TEXTURE_CONSUMER = null;
        TEXT_CONSUMER = null;
        RenderSystemState renderSystemState = RenderSystemState.current();
        HUD_BATCH.method_22993();
        BatchingBuffers.endItemModelBatching();
        BatchingBuffers.endItemOverlayBatching();
        renderSystemState.apply();
    }

    public static boolean isHudBatching() {
        return TEXT_CONSUMER != null || TEXTURE_CONSUMER != null || FILL_CONSUMER != null || LIT_ITEM_MODEL_CONSUMER != null || UNLIT_ITEM_MODEL_CONSUMER != null || ITEM_OVERLAY_CONSUMER != null;
    }

    private static void beginItemModelBatching() {
        if (LIT_ITEM_MODEL_BATCH.hasActiveLayers() || UNLIT_ITEM_MODEL_BATCH.hasActiveLayers()) {
            ImmediatelyFast.LOGGER.warn("Item model batching was already active! endItemModelBatching() was not called before beginItemModelBatching(). This will cause rendering issues.");
            LIT_ITEM_MODEL_BATCH.close();
            UNLIT_ITEM_MODEL_BATCH.close();
        }
        LIT_ITEM_MODEL_CONSUMER = LIT_ITEM_MODEL_BATCH;
        UNLIT_ITEM_MODEL_CONSUMER = UNLIT_ITEM_MODEL_BATCH;
    }

    private static void endItemModelBatching() {
        LIT_ITEM_MODEL_CONSUMER = null;
        UNLIT_ITEM_MODEL_CONSUMER = null;
        UNLIT_ITEM_MODEL_BATCH.method_22993();
        LIT_ITEM_MODEL_BATCH.method_22993();
    }

    private static void beginItemOverlayBatching() {
        if (ITEM_OVERLAY_BATCH.hasActiveLayers()) {
            ImmediatelyFast.LOGGER.warn("Item overlay batching was already active! endItemOverlayBatching() was not called before beginItemOverlayBatching(). This will cause rendering issues.");
            ITEM_OVERLAY_BATCH.close();
        }
        ITEM_OVERLAY_CONSUMER = ITEM_OVERLAY_BATCH;
    }

    private static void endItemOverlayBatching() {
        ITEM_OVERLAY_CONSUMER = null;
        ITEM_OVERLAY_BATCH.method_22993();
    }

    public static Map<class_1921, class_287> createLayerBuffers(class_1921 ... layers) {
        Object2ObjectLinkedOpenHashMap layerBuffers = new Object2ObjectLinkedOpenHashMap(layers.length);
        for (class_1921 layer : layers) {
            layerBuffers.put((Object)layer, (Object)new class_287(layer.method_22722()));
        }
        return layerBuffers;
    }
}

