/*
 * Decompiled with CFR 0.152.
 */
package dev.lambdaurora.lambdabettergrass;

import com.mojang.logging.LogUtils;
import dev.lambdaurora.lambdabettergrass.LBGConfig;
import dev.lambdaurora.lambdabettergrass.metadata.LBGGrassState;
import dev.lambdaurora.lambdabettergrass.metadata.LBGLayerState;
import dev.lambdaurora.lambdabettergrass.metadata.LBGState;
import dev.lambdaurora.lambdabettergrass.resource.LBGResourcePack;
import dev.lambdaurora.lambdabettergrass.resource.LBGResourceReloader;
import java.nio.file.Path;
import net.minecraft.class_2960;
import net.minecraft.class_3262;
import net.minecraft.class_3264;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.quiltmc.loader.api.ModContainer;
import org.quiltmc.qsl.base.api.entrypoint.client.ClientModInitializer;
import org.quiltmc.qsl.resource.loader.api.ResourceLoader;
import org.quiltmc.qsl.resource.loader.api.ResourcePackActivationType;
import org.quiltmc.qsl.resource.loader.api.client.ClientResourceLoaderEvents;
import org.slf4j.Logger;

public class LambdaBetterGrass
implements ClientModInitializer,
ClientResourceLoaderEvents.EndResourcePackReload {
    public static final String NAMESPACE = "lambdabettergrass";
    public static final Logger LOGGER = LogUtils.getLogger();
    public static final class_2960 BETTER_GRASS_SIDE_CONNECT_MASK = LambdaBetterGrass.id("bettergrass/mask/standard_block_side_connect.png");
    public static final class_2960 BETTER_GRASS_SIDE_BLEND_UP_MASK = LambdaBetterGrass.id("bettergrass/mask/grass_block_side_blend_up.png");
    public static final class_2960 BETTER_GRASS_SIDE_ARCH_BLEND_MASK = LambdaBetterGrass.id("bettergrass/mask/grass_block_side_arch_blend.png");
    @ApiStatus.Internal
    public static final LambdaBetterGrass INSTANCE = new LambdaBetterGrass();
    public final LBGConfig config = new LBGConfig(this);
    private final ThreadLocal<Boolean> betterLayerDisabled = ThreadLocal.withInitial(() -> false);
    public final LBGResourceReloader resourceReloader = new LBGResourceReloader();
    public LBGResourcePack resourcePack;

    public void onInitializeClient(ModContainer mod) {
        this.log("Initializing LambdaBetterGrass...");
        this.config.load();
        ResourceLoader.registerBuiltinResourcePack((class_2960)LambdaBetterGrass.id("default"), (ModContainer)mod, (ResourcePackActivationType)ResourcePackActivationType.DEFAULT_ENABLED);
        ResourceLoader.registerBuiltinResourcePack((class_2960)LambdaBetterGrass.id("32x"), (ModContainer)mod, (ResourcePackActivationType)ResourcePackActivationType.NORMAL);
        ResourceLoader.get((class_3264)class_3264.field_14188).getRegisterTopResourcePackEvent().register(LambdaBetterGrass.id("register_pack"), context -> {
            this.log("Rebuilding resources and inject generated resource pack.");
            this.resourcePack = new LBGResourcePack(this);
            context.addResourcePack((class_3262)this.resourcePack);
            this.resourceReloader.reload(context.resourceManager());
        });
        LBGState.registerType("grass", (id, block, resourceManager, json, deserializationContext) -> new LBGGrassState(id, resourceManager, json));
        LBGState.registerType("layer", LBGLayerState::new);
    }

    public void onEndResourcePackReload(ClientResourceLoaderEvents.EndResourcePackReload.Context context) {
        if (this.config.isDebug()) {
            this.resourcePack.dumpTo(Path.of("debug/lbg_out", new String[0]));
        }
    }

    public void log(String info) {
        LOGGER.info("[LambdaBetterGrass] " + info);
    }

    public void warn(String info) {
        LOGGER.warn("[LambdaBetterGrass] " + info);
    }

    public void warn(String info, Object ... objects) {
        LOGGER.warn("[LambdaBetterGrass] " + info, objects);
    }

    public boolean hasBetterLayer() {
        if (this.config.hasBetterLayer()) {
            return this.betterLayerDisabled.get() == false;
        }
        return false;
    }

    public static class_2960 id(@NotNull String path) {
        return new class_2960(NAMESPACE, path);
    }

    public static LambdaBetterGrass get() {
        return INSTANCE;
    }

    public static void pushDisableBetterLayer() {
        LambdaBetterGrass.get().betterLayerDisabled.set(true);
    }

    public static void popDisableBetterLayer() {
        LambdaBetterGrass.get().betterLayerDisabled.remove();
    }
}

