/*
 * Decompiled with CFR 0.152.
 */
package dev.lambdaurora.lambdabettergrass.metadata;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import dev.lambdaurora.lambdabettergrass.LambdaBetterGrass;
import dev.lambdaurora.lambdabettergrass.metadata.LBGMetadata;
import dev.lambdaurora.lambdabettergrass.metadata.LBGState;
import dev.lambdaurora.lambdabettergrass.model.LBGUnbakedModel;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.class_1091;
import net.minecraft.class_1100;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LBGGrassState
extends LBGState {
    private final LBGMetadata metadata;
    private final Map<String, LBGMetadata> metadatas = new Object2ObjectOpenHashMap();

    public LBGGrassState(@NotNull class_2960 id, @NotNull class_3300 resourceManager, @NotNull JsonObject json) {
        super(id);
        if (json.has("variants")) {
            JsonObject variants = json.getAsJsonObject("variants");
            variants.entrySet().forEach(entry -> {
                JsonObject variant = ((JsonElement)entry.getValue()).getAsJsonObject();
                if (variant.has("data")) {
                    class_2960 metadataId = new class_2960(variant.get("data").getAsString());
                    this.metadatas.put((String)entry.getKey(), this.loadMetadata(resourceManager, metadataId));
                }
            });
            LBGMetadata normalMetadata = this.metadatas.get("snowy=false");
            LBGMetadata snowyMetadata = this.metadatas.get("snowy=true");
            if (normalMetadata != null && snowyMetadata != null) {
                snowyMetadata.snowyModelVariantProvider = bakedModel -> {
                    normalMetadata.snowyModelVariant = bakedModel;
                };
            }
            this.metadata = null;
        } else if (json.has("data")) {
            class_2960 metadataId = new class_2960(json.get("data").getAsString());
            this.metadata = this.loadMetadata(resourceManager, metadataId);
        } else {
            this.metadata = null;
        }
    }

    @Nullable
    private LBGMetadata loadMetadata(@NotNull class_3300 resourceManager, @NotNull class_2960 metadataId) {
        LBGMetadata lBGMetadata;
        class_2960 metadataResourceId = new class_2960(metadataId.method_12836(), metadataId.method_12832() + ".json");
        InputStreamReader reader = new InputStreamReader(resourceManager.getResourceOrThrow(metadataResourceId).method_14482());
        try {
            JsonObject metadataJson = JsonParser.parseReader((Reader)reader).getAsJsonObject();
            lBGMetadata = new LBGMetadata(resourceManager, metadataId, metadataJson);
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException iOException) {
                LambdaBetterGrass.get().warn("Could not load metadata `" + metadataId + "`.");
                return null;
            }
        }
        reader.close();
        return lBGMetadata;
    }

    @Nullable
    public LBGMetadata getMetadata(@NotNull class_1091 modelId) {
        if (this.metadata != null) {
            return this.metadata;
        }
        String[] modelVariant = modelId.method_4740().split(",");
        for (Map.Entry<String, LBGMetadata> variant : this.metadatas.entrySet()) {
            if (!this.matchVariant(modelVariant, variant.getKey().split(","))) continue;
            return variant.getValue();
        }
        return null;
    }

    @Override
    @Nullable
    public class_1100 getCustomUnbakedModel(class_1091 modelId, class_1100 originalModel, Function<class_2960, class_1100> modelGetter) {
        LBGMetadata metadata = this.getMetadata(modelId);
        if (metadata != null) {
            return new LBGUnbakedModel(originalModel, metadata);
        }
        return null;
    }
}

