/*
 * Decompiled with CFR 0.152.
 */
package dev.lambdaurora.lambdabettergrass.metadata;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.lambdaurora.lambdabettergrass.metadata.LBGLayerType;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.io.Reader;
import java.io.StringReader;
import java.util.function.Function;
import net.minecraft.class_1091;
import net.minecraft.class_1100;
import net.minecraft.class_2960;
import net.minecraft.class_790;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public class LBGLayerMetadata {
    public final class_2960 id;
    public final LBGLayerType layerType;
    private final boolean layerModel;
    @Nullable
    private final Vector3f offset;
    private final Object2ObjectMap<String, class_1100> variantModels = new Object2ObjectOpenHashMap();
    private class_1100 alternateModel;
    private final boolean hasAlternateModel;

    public LBGLayerMetadata(class_2960 id, @Nullable LBGLayerType layerType, JsonObject json, class_790.class_791 deserializationContext) {
        this.id = id;
        this.layerType = layerType;
        this.layerModel = json.has("layer") ? json.get("layer").getAsBoolean() : false;
        if (json.has("offset")) {
            JsonElement offsetJson = json.get("offset");
            if (offsetJson.isJsonArray()) {
                JsonArray offsetArray = offsetJson.getAsJsonArray();
                this.offset = new Vector3f(offsetArray.get(0).getAsFloat(), offsetArray.get(1).getAsFloat(), offsetArray.get(2).getAsFloat());
            } else {
                this.offset = null;
            }
        } else {
            this.offset = null;
        }
        if (!json.has("block_state")) {
            this.alternateModel = null;
            this.hasAlternateModel = false;
            return;
        }
        class_790 map = class_790.method_3424((class_790.class_791)deserializationContext, (Reader)new StringReader(json.get("block_state").toString()));
        if (map.method_3422()) {
            this.alternateModel = map.method_3421();
        } else {
            this.variantModels.putAll(map.method_3423());
        }
        this.hasAlternateModel = true;
    }

    public boolean hasLayerModel() {
        return this.layerModel;
    }

    @Nullable
    public Vector3f offset() {
        return this.offset;
    }

    public LayerUnbakedModels getCustomUnbakedModel(class_1091 modelId, class_1100 originalModel, Function<class_2960, class_1100> modelGetter) {
        class_1100 layerModel = null;
        if (this.layerModel) {
            layerModel = this.layerType.getLayerModel(modelGetter);
        }
        class_1100 alternateModel = null;
        if (this.hasAlternateModel) {
            if (this.alternateModel != null) {
                alternateModel = this.alternateModel;
            } else {
                class_1100 alternateVariantModel = (class_1100)this.variantModels.get((Object)modelId.method_4740());
                if (alternateVariantModel != null) {
                    alternateModel = alternateVariantModel;
                }
            }
        }
        return new LayerUnbakedModels(layerModel, alternateModel);
    }

    public String toString() {
        return "LBGLayerMetadata{id=" + this.id + ", layerType=" + this.layerType + ", layerModel=" + this.layerModel + ", hasAlternateModel=" + this.hasAlternateModel + "}";
    }

    public record LayerUnbakedModels(@Nullable class_1100 layerModel, @Nullable class_1100 alternateModel) {
        public boolean isEmpty() {
            return this.layerModel() == null && this.alternateModel() == null;
        }
    }
}

