/*
 * Decompiled with CFR 0.152.
 */
package dev.lambdaurora.lambdabettergrass.metadata;

import com.google.gson.JsonObject;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.function.Function;
import net.minecraft.class_1091;
import net.minecraft.class_1100;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_790;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public abstract class LBGState {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final String PATH_PREFIX = "bettergrass/states";
    private static final Object2ObjectMap<String, LBGStateProvider> LBG_STATES_TYPE = new Object2ObjectOpenHashMap();
    private static final Object2ObjectMap<class_2960, LBGState> LBG_STATES = new Object2ObjectOpenHashMap();
    public final class_2960 id;

    public LBGState(class_2960 id) {
        this.id = id;
        LBGState.putState(id, this);
    }

    protected boolean matchVariant(String[] modelVariant, String[] dataVariant) {
        for (String dataProperty : dataVariant) {
            if (dataProperty.equals("*")) {
                return true;
            }
            boolean matched = false;
            for (String modelProperty : modelVariant) {
                if (!modelProperty.equals(dataProperty)) continue;
                matched = true;
                break;
            }
            if (matched) continue;
            return false;
        }
        return true;
    }

    @Nullable
    public abstract class_1100 getCustomUnbakedModel(class_1091 var1, class_1100 var2, Function<class_2960, class_1100> var3);

    protected static void putState(class_2960 id, LBGState state) {
        LBG_STATES.put((Object)id, (Object)state);
    }

    @Nullable
    public static LBGState getMetadataState(class_2960 id) {
        return (LBGState)LBG_STATES.get((Object)id);
    }

    public static void reset() {
        LBG_STATES.clear();
    }

    public static void registerType(String type, LBGStateProvider stateProvider) {
        LBG_STATES_TYPE.put((Object)type, (Object)stateProvider);
    }

    public static void loadMetadataState(class_2960 id, class_2248 block, class_3300 resourceManager, JsonObject json, class_790.class_791 deserializationContext) {
        String type = "grass";
        if (json.has("type")) {
            type = json.get("type").getAsString();
        }
        if (LBG_STATES_TYPE.containsKey((Object)type)) {
            ((LBGStateProvider)LBG_STATES_TYPE.get((Object)type)).create(id, block, resourceManager, json, deserializationContext);
        } else {
            LOGGER.warn("Could not find type {} for metadata state {}.", (Object)type, (Object)id);
        }
    }

    @FunctionalInterface
    public static interface LBGStateProvider {
        public LBGState create(class_2960 var1, class_2248 var2, class_3300 var3, JsonObject var4, class_790.class_791 var5);
    }
}

