/*
 * Decompiled with CFR 0.152.
 */
package dev.lambdaurora.lambdabettergrass.util;

import dev.lambdaurora.lambdabettergrass.metadata.LBGLayerState;
import dev.lambdaurora.lambdabettergrass.metadata.LBGState;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import net.minecraft.class_1920;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2464;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;

public final class LayeredBlockUtils {
    private static final List<class_2350> HORIZONTAL_DIRECTIONS = Arrays.stream(class_2350.values()).filter(dir -> dir.method_10166().method_10179()).toList();

    private LayeredBlockUtils() {
        throw new UnsupportedOperationException("LayeredBlockUtils only contains static definitions.");
    }

    public static boolean shouldGrassBeSnowy(class_1920 world, class_2338 pos, class_2960 stateId, class_2680 upState, boolean onlyPureSnow) {
        if (upState.method_26217() != class_2464.field_11458) {
            return false;
        }
        LBGState state = LBGState.getMetadataState(stateId);
        if (!(state instanceof LBGLayerState)) {
            return false;
        }
        LBGLayerState layerState = (LBGLayerState)state;
        Collection properties = upState.method_28501();
        String[] modelVariant = new String[properties.size()];
        int i = 0;
        for (class_2769 property : properties) {
            String end = ",";
            if (modelVariant.length == i + 1) {
                end = "";
            }
            modelVariant[i] = property.method_11899() + "=" + LayeredBlockUtils.nameValue(property, upState.method_11654(property)) + end;
            ++i;
        }
        boolean[] shouldTry = new boolean[]{false};
        layerState.forEach(modelVariant, metadata -> {
            if (metadata.layerType.getName().equals("snow") && metadata.hasLayerModel()) {
                shouldTry[0] = true;
            }
        });
        return shouldTry[0] && LayeredBlockUtils.getNearbySnowyBlocks(world, pos.method_10084(), upState.method_26204(), onlyPureSnow) > 1;
    }

    private static <T extends Comparable<T>> String nameValue(class_2769<T> property, Comparable<?> value) {
        return property.method_11901(value);
    }

    public static int getNearbySnowyBlocks(class_1920 world, class_2338 pos, class_2248 type, boolean onlyPureSnow) {
        return LayeredBlockUtils.getNearbyLayeredBlocks(world, pos, class_2246.field_10477, type, onlyPureSnow);
    }

    public static int getNearbyLayeredBlocks(class_1920 world, class_2338 pos, class_2248 layerBlock, class_2248 type, boolean onlySourceBlock) {
        int nearbySnow = 0;
        for (class_2350 direction : HORIZONTAL_DIRECTIONS) {
            class_2338 offsetPos = pos.method_10093(direction);
            class_2248 block = world.method_8320(offsetPos).method_26204();
            if (block == type && !onlySourceBlock) {
                if (LayeredBlockUtils.getNearbyBlockLayers(world, offsetPos, layerBlock) <= 1) continue;
                ++nearbySnow;
                continue;
            }
            if (block != layerBlock) continue;
            ++nearbySnow;
        }
        return nearbySnow;
    }

    public static int getNearbyBlockLayers(class_1920 world, class_2338 pos, class_2248 layerBlock) {
        int nearbySnow = 0;
        for (class_2350 direction : HORIZONTAL_DIRECTIONS) {
            if (world.method_8320(pos.method_10093(direction)).method_26204() != layerBlock) continue;
            ++nearbySnow;
        }
        return nearbySnow;
    }
}

