/*
 * Decompiled with CFR 0.152.
 */
package dynamicfps.mixin;

import dynamicfps.util.DynamicFPSScreen;
import dynamicfps.util.ScreenOptimizationCompat;
import net.minecraft.class_437;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_437.class})
public class ScreenMixin
implements DynamicFPSScreen {
    @Unique
    private boolean dynamicfps$canOptimize = false;
    @Unique
    private boolean dynamicfps$hasOptedOut = false;

    @Override
    public boolean dynamicfps$rendersBackground() {
        return this.dynamicfps$canOptimize;
    }

    @Inject(method={"init"}, at={@At(value="HEAD")})
    private void onInit(CallbackInfo callbackInfo) {
        String name = this.getClass().getName();
        this.dynamicfps$hasOptedOut = ScreenOptimizationCompat.isOptedOut(name);
        if (!this.dynamicfps$hasOptedOut) {
            this.dynamicfps$canOptimize = ScreenOptimizationCompat.isOptedIn(name);
        }
    }

    @Inject(method={"renderBackgroundTexture"}, at={@At(value="HEAD")})
    private void onRenderBackgroundTexture(CallbackInfo callbackInfo) {
        if (!this.dynamicfps$hasOptedOut) {
            this.dynamicfps$canOptimize = true;
        }
    }
}

