/*
 * Decompiled with CFR 0.152.
 */
package me.pepperbell.continuity.client.resource;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import me.pepperbell.continuity.client.mixinterface.ModelLoaderExtension;
import me.pepperbell.continuity.client.model.QuadProcessors;
import me.pepperbell.continuity.client.resource.CTMPropertiesLoader;
import me.pepperbell.continuity.client.resource.EmissiveSuffixLoader;
import me.pepperbell.continuity.client.resource.SpriteLoaderLoadContext;
import net.minecraft.class_1058;
import net.minecraft.class_1059;
import net.minecraft.class_1088;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_4724;
import org.jetbrains.annotations.Nullable;

public class BakedModelManagerReloadExtension {
    private final CompletableFuture<CTMPropertiesLoader.LoadingResult> ctmLoadingResultFuture;
    private final AtomicBoolean wrapEmissiveModels = new AtomicBoolean();
    private volatile List<QuadProcessors.ProcessorHolder> processorHolders;

    public BakedModelManagerReloadExtension(class_3300 resourceManager, Executor prepareExecutor) {
        this.ctmLoadingResultFuture = CompletableFuture.supplyAsync(() -> CTMPropertiesLoader.loadAllWithState(resourceManager), prepareExecutor);
        EmissiveSuffixLoader.load(resourceManager);
    }

    public void setContext() {
        SpriteLoaderLoadContext.THREAD_LOCAL.set(new SpriteLoaderInitContextImpl((CompletableFuture<Map<class_2960, Set<class_2960>>>)this.ctmLoadingResultFuture.thenApply(CTMPropertiesLoader.LoadingResult::textureDependencies), this.wrapEmissiveModels));
    }

    public void clearContext() {
        SpriteLoaderLoadContext.THREAD_LOCAL.set(null);
    }

    public void beforeBaking(Map<class_2960, class_4724.class_7774> preparations, class_1088 modelLoader) {
        CTMPropertiesLoader.LoadingResult result = this.ctmLoadingResultFuture.join();
        List<QuadProcessors.ProcessorHolder> processorHolders = CTMPropertiesLoader.createProcessorHolders(result.containers(), spriteId -> {
            class_4724.class_7774 preparation = (class_4724.class_7774)preparations.get(spriteId.method_24144());
            class_1058 sprite = preparation.method_45869(spriteId.method_24147());
            if (sprite != null) {
                return sprite;
            }
            return preparation.method_45868();
        });
        this.processorHolders = processorHolders;
        ((ModelLoaderExtension)modelLoader).continuity$setWrapCTM(!processorHolders.isEmpty());
        ((ModelLoaderExtension)modelLoader).continuity$setWrapEmissive(this.wrapEmissiveModels.get());
    }

    public void apply() {
        List<QuadProcessors.ProcessorHolder> processorHolders = this.processorHolders;
        if (processorHolders != null) {
            QuadProcessors.reload(processorHolders);
        }
    }

    private static class SpriteLoaderInitContextImpl
    implements SpriteLoaderLoadContext {
        private final CompletableFuture<Map<class_2960, Set<class_2960>>> allExtraIdsFuture;
        private final Map<class_2960, CompletableFuture<Set<class_2960>>> extraIdsFutures = new Object2ObjectOpenHashMap();
        private final SpriteLoaderLoadContext.EmissiveControl blockAtlasEmissiveControl;
        private final AtomicReference<Map<class_2960, class_2960>> emissiveIdMapHolder = new AtomicReference();

        public SpriteLoaderInitContextImpl(CompletableFuture<Map<class_2960, Set<class_2960>>> allExtraIdsFuture, AtomicBoolean blockAtlasHasEmissivesHolder) {
            this.allExtraIdsFuture = allExtraIdsFuture;
            this.blockAtlasEmissiveControl = () -> blockAtlasHasEmissivesHolder.set(true);
        }

        @Override
        public CompletableFuture<@Nullable Set<class_2960>> getExtraIdsFuture(class_2960 atlasId) {
            return this.extraIdsFutures.computeIfAbsent(atlasId, id -> this.allExtraIdsFuture.thenApply(allExtraIds -> (Set)allExtraIds.get(id)));
        }

        @Override
        @Nullable
        public SpriteLoaderLoadContext.EmissiveControl getEmissiveControl(class_2960 atlasId) {
            if (atlasId.equals((Object)class_1059.field_5275)) {
                return this.blockAtlasEmissiveControl;
            }
            return null;
        }

        @Override
        public AtomicReference<@Nullable Map<class_2960, class_2960>> getEmissiveIdMapHolder() {
            return this.emissiveIdMapHolder;
        }
    }
}

