/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.gui;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.class_1074;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_410;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import xaero.map.MapProcessor;
import xaero.map.WorldMap;
import xaero.map.graphics.CustomRenderTypes;
import xaero.map.graphics.MapRenderHelper;
import xaero.map.gui.CursorBox;
import xaero.map.gui.GuiMap;
import xaero.map.gui.GuiMapName;
import xaero.map.gui.GuiMapSwitchingButton;
import xaero.map.gui.TooltipButton;
import xaero.map.gui.dropdown.DropDownWidget;
import xaero.map.misc.KeySortableByOther;
import xaero.map.world.MapDimension;

public class GuiMapSwitching {
    private MapProcessor mapProcessor;
    private MapDimension settingsDimension;
    private String[] mwDropdownValues;
    private DropDownWidget createdDropdown;
    private class_4185 switchingButton;
    private class_4185 multiworldTypeOptionButton;
    private class_4185 renameButton;
    private class_4185 deleteButton;
    private class_4185 confirmButton;
    private CursorBox serverSelectionModeBox = new CursorBox("gui.xaero_mw_server_box");
    private CursorBox mapSelectionBox = new CursorBox("gui.xaero_map_selection_box");
    public boolean active;
    private boolean writableOnInit;
    private boolean uiPausedOnUpdate;
    private boolean mapSwitchingAllowed;

    public GuiMapSwitching(MapProcessor mapProcessor) {
        this.mapProcessor = mapProcessor;
        this.mapSelectionBox.setStartWidth(200);
        this.serverSelectionModeBox.setStartWidth(200);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(GuiMap mapScreen, class_310 minecraft, int width, int height) {
        this.createdDropdown = null;
        this.switchingButton = null;
        this.multiworldTypeOptionButton = null;
        this.renameButton = null;
        this.deleteButton = null;
        this.confirmButton = null;
        this.settingsDimension = mapScreen.getDimension();
        this.mapSwitchingAllowed = this.settingsDimension != null && this.settingsDimension.getMapWorld().isMultiplayer();
        Object object = this.mapProcessor.uiPauseSync;
        synchronized (object) {
            this.uiPausedOnUpdate = this.isUIPaused();
            this.switchingButton = new GuiMapSwitchingButton(this.active, 0, height - 20, b -> {
                Object object = this.mapProcessor.uiPauseSync;
                synchronized (object) {
                    if (!this.canToggleThisScreen()) {
                        return;
                    }
                    this.active = !this.active;
                    mapScreen.method_25423(minecraft, width, height);
                    mapScreen.method_25395((class_364)this.switchingButton);
                }
            });
            mapScreen.addButton(this.switchingButton);
            if (this.mapSwitchingAllowed) {
                this.writableOnInit = this.settingsDimension.futureMultiworldWritable;
                if (this.active) {
                    this.createdDropdown = this.createDropdown(this.uiPausedOnUpdate, width, mapScreen, minecraft);
                    mapScreen.method_25429(this.createdDropdown);
                    this.multiworldTypeOptionButton = new TooltipButton(width / 2 - 90, 24, 180, 20, (class_2561)class_2561.method_43470((String)this.getMultiworldTypeButtonMessage()), b -> {
                        Object object = this.mapProcessor.uiPauseSync;
                        synchronized (object) {
                            if (this.isMapSelectionOptionEnabled()) {
                                this.mapProcessor.toggleMultiworldType(this.settingsDimension);
                                b.method_25355((class_2561)class_2561.method_43470((String)this.getMultiworldTypeButtonMessage()));
                            }
                        }
                    }, this.settingsDimension.isFutureMultiworldServerBased() ? () -> this.serverSelectionModeBox : () -> this.mapSelectionBox);
                    mapScreen.addButton(this.multiworldTypeOptionButton);
                    this.renameButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.xaero_rename"), b -> {
                        Object object = this.mapProcessor.uiPauseSync;
                        synchronized (object) {
                            if (!this.canRenameMap()) {
                                return;
                            }
                            minecraft.method_1507((class_437)new GuiMapName(this.mapProcessor, mapScreen, mapScreen, this.settingsDimension, this.settingsDimension.getFutureMultiworldUnsynced()));
                        }
                    }).method_46434(width / 2 + 109, 60, 60, 20).method_46431();
                    mapScreen.addButton(this.renameButton);
                    this.deleteButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.xaero_delete"), b -> {
                        Object object = this.mapProcessor.uiPauseSync;
                        synchronized (object) {
                            if (!this.canDeleteMap()) {
                                return;
                            }
                            String selectedMWId = this.settingsDimension.getFutureCustomSelectedMultiworld();
                            minecraft.method_1507((class_437)new class_410(result -> {
                                if (result) {
                                    String mapNameAndIdLine = class_1074.method_4662((String)"gui.xaero_delete_map_msg4", (Object[])new Object[0]) + ": " + this.settingsDimension.getMultiworldName(selectedMWId) + " (" + selectedMWId + ")";
                                    minecraft.method_1507((class_437)new class_410(result2 -> {
                                        if (result2) {
                                            Object object = this.mapProcessor.uiSync;
                                            synchronized (object) {
                                                if (this.mapProcessor.getMapWorld() == this.settingsDimension.getMapWorld()) {
                                                    MapDimension currentDimension;
                                                    MapDimension mapDimension = currentDimension = !this.mapProcessor.isMapWorldUsable() ? null : this.mapProcessor.getMapWorld().getCurrentDimension();
                                                    if (this.settingsDimension == currentDimension && this.settingsDimension.getCurrentMultiworld().equals(selectedMWId)) {
                                                        if (WorldMap.settings.debug) {
                                                            WorldMap.LOGGER.info("Delayed map deletion!");
                                                        }
                                                        this.mapProcessor.requestCurrentMapDeletion();
                                                    } else {
                                                        if (WorldMap.settings.debug) {
                                                            WorldMap.LOGGER.info("Instant map deletion!");
                                                        }
                                                        this.settingsDimension.deleteMultiworldMapDataUnsynced(selectedMWId);
                                                    }
                                                    this.settingsDimension.deleteMultiworldId(selectedMWId);
                                                    this.settingsDimension.pickDefaultCustomMultiworldUnsynced();
                                                    this.settingsDimension.saveConfigUnsynced();
                                                    this.settingsDimension.futureMultiworldWritable = false;
                                                    mapScreen.method_25423(minecraft, width, height);
                                                }
                                            }
                                        }
                                        minecraft.method_1507((class_437)mapScreen);
                                    }, (class_2561)class_2561.method_43471((String)"gui.xaero_delete_map_msg3"), (class_2561)class_2561.method_43470((String)mapNameAndIdLine)));
                                } else {
                                    minecraft.method_1507((class_437)mapScreen);
                                }
                            }, (class_2561)class_2561.method_43471((String)"gui.xaero_delete_map_msg1"), (class_2561)class_2561.method_43471((String)"gui.xaero_delete_map_msg2")));
                        }
                    }).method_46434(width / 2 - 168, 60, 60, 20).method_46431();
                    mapScreen.addButton(this.deleteButton);
                    this.confirmButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.xaero_confirm"), b -> {
                        Object object = this.mapProcessor.uiPauseSync;
                        synchronized (object) {
                            if (!this.canConfirm()) {
                                return;
                            }
                            this.confirm(mapScreen, minecraft, width, height);
                        }
                    }).method_46434(width / 2 - 50, 84, 100, 20).method_46431();
                    mapScreen.addButton(this.confirmButton);
                    this.updateButtons(mapScreen, width, minecraft);
                } else {
                    this.switchingButton.field_22763 = this.canToggleThisScreen();
                }
            } else {
                this.switchingButton.field_22763 = false;
            }
        }
    }

    private DropDownWidget createDropdown(boolean paused, int width, GuiMap mapScreen, class_310 minecraft) {
        List<CallSite> mwDropdownNames;
        int selected = 0;
        if (!paused) {
            String currentMultiworld = this.settingsDimension.getFutureMultiworldUnsynced();
            ArrayList<KeySortableByOther<String>> sortableList = new ArrayList<KeySortableByOther<String>>();
            for (String mwId : this.settingsDimension.getMultiworldIdsCopy()) {
                sortableList.add(new KeySortableByOther<String>(mwId, new Comparable[]{this.settingsDimension.getMultiworldName(mwId).toLowerCase()}));
            }
            Collections.sort(sortableList);
            ArrayList<String> dropdownValuesList = new ArrayList<String>();
            for (KeySortableByOther keySortableByOther : sortableList) {
                dropdownValuesList.add((String)keySortableByOther.getKey());
            }
            selected = this.getDropdownSelectionIdFromValue(dropdownValuesList, currentMultiworld);
            if (selected == dropdownValuesList.size()) {
                dropdownValuesList.add(currentMultiworld);
            }
            this.mwDropdownValues = dropdownValuesList.toArray(new String[0]);
            mwDropdownNames = dropdownValuesList.stream().map(s -> this.settingsDimension.getMultiworldName((String)s)).collect(ArrayList::new, ArrayList::add, ArrayList::addAll);
            if (this.settingsDimension.getMapWorld().isMultiplayer()) {
                mwDropdownNames.add((CallSite)((Object)("\u00a78" + class_1074.method_4662((String)"gui.xaero_create_new_map", (Object[])new Object[0]))));
            }
        } else {
            mwDropdownNames = new ArrayList<CallSite>();
            this.mwDropdownValues = null;
            mwDropdownNames.add((CallSite)((Object)("\u00a77" + class_1074.method_4662((String)"gui.xaero_map_menu_please_wait", (Object[])new Object[0]))));
        }
        DropDownWidget result = DropDownWidget.Builder.begin().setOptions(mwDropdownNames.toArray(new String[0])).setX(width / 2 - 100).setY(64).setW(200).setSelected(selected).setCallback((dd, i) -> {
            Object object = this.mapProcessor.uiPauseSync;
            synchronized (object) {
                if (this.isUIPaused() || this.uiPausedOnUpdate) {
                    return false;
                }
                if (i < this.mwDropdownValues.length) {
                    this.mapProcessor.setMultiworld(this.settingsDimension, this.mwDropdownValues[i]);
                    this.updateButtons(mapScreen, width, minecraft);
                    return true;
                }
                minecraft.method_1507((class_437)new GuiMapName(this.mapProcessor, mapScreen, mapScreen, this.settingsDimension, null));
                return false;
            }
        }).setContainer(mapScreen).setNarrationTitle((class_2561)class_2561.method_43471((String)"gui_xaero_wm_dropdown_map_select")).build();
        result.setActive(!paused);
        return result;
    }

    private boolean isUIPaused() {
        return this.mapProcessor.isUIPaused() || this.mapProcessor.isWaitingForWorldUpdate();
    }

    private boolean isMapSelectionOptionEnabled() {
        return !this.isUIPaused() && !this.settingsDimension.isFutureMultiworldServerBased() && this.settingsDimension.getMapWorld().isMultiplayer();
    }

    private boolean canToggleThisScreen() {
        return !this.isUIPaused() && this.settingsDimension != null && this.settingsDimension.futureMultiworldWritable;
    }

    private boolean canDeleteMap() {
        return !this.isUIPaused() && this.settingsDimension.getMapWorld().isMultiplayer() && this.mwDropdownValues != null && this.mwDropdownValues.length > 1 && this.settingsDimension.getFutureCustomSelectedMultiworld() != null;
    }

    private boolean canRenameMap() {
        return !this.isUIPaused() && this.settingsDimension.getMapWorld().isMultiplayer();
    }

    private boolean canConfirm() {
        return !this.isUIPaused();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateButtons(GuiMap mapScreen, int width, class_310 minecraft) {
        Object object = this.mapProcessor.uiPauseSync;
        synchronized (object) {
            boolean isPaused = this.isUIPaused();
            if (this.uiPausedOnUpdate != isPaused) {
                DropDownWidget newDropDown;
                DropDownWidget dropDownWidget = newDropDown = !this.active ? null : this.createDropdown(isPaused, width, mapScreen, minecraft);
                if (newDropDown != null) {
                    if (this.createdDropdown != null) {
                        mapScreen.replaceWidget(this.createdDropdown, newDropDown);
                    } else {
                        mapScreen.method_25429(newDropDown);
                    }
                } else if (this.createdDropdown != null) {
                    mapScreen.method_37066((class_364)this.createdDropdown);
                }
                this.createdDropdown = !this.active ? null : newDropDown;
                this.uiPausedOnUpdate = isPaused;
            }
            this.switchingButton.field_22763 = this.canToggleThisScreen();
            if (this.deleteButton != null) {
                this.deleteButton.field_22763 = this.canDeleteMap();
            }
            if (this.renameButton != null) {
                this.renameButton.field_22763 = this.canRenameMap();
            }
            if (this.multiworldTypeOptionButton != null) {
                this.multiworldTypeOptionButton.field_22763 = this.isMapSelectionOptionEnabled();
            }
            if (this.confirmButton != null) {
                this.confirmButton.field_22763 = this.canConfirm();
            }
        }
    }

    private String getMultiworldTypeButtonMessage() {
        int multiworldType = this.settingsDimension.getMapWorld().getFutureMultiworldType(this.settingsDimension);
        return class_1074.method_4662((String)"gui.xaero_map_selection", (Object[])new Object[0]) + ": " + class_1074.method_4662((String)(this.settingsDimension.isFutureMultiworldServerBased() ? "gui.xaero_mw_server" : (multiworldType == 0 ? "gui.xaero_mw_single" : (multiworldType == 1 ? "gui.xaero_mw_manual" : "gui.xaero_mw_spawn"))), (Object[])new Object[0]);
    }

    public void confirm(GuiMap mapScreen, class_310 minecraft, int width, int height) {
        if (this.mapProcessor.confirmMultiworld(this.settingsDimension)) {
            this.active = false;
            mapScreen.method_25423(minecraft, width, height);
        }
    }

    private int getDropdownSelectionIdFromValue(List<String> values, String value) {
        int selected = 0;
        for (selected = 0; selected < values.size() && !values.get(selected).equals(value); ++selected) {
        }
        return selected;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preMapRender(GuiMap mapScreen, class_310 minecraft, int width, int height) {
        String currentDropdownSelection;
        String currentMultiworld;
        if (!this.active && this.settingsDimension != null && !this.settingsDimension.futureMultiworldWritable) {
            this.active = true;
            mapScreen.method_25423(minecraft, width, height);
        }
        if (this.mapSwitchingAllowed && (this.createdDropdown == null || this.createdDropdown.isClosed())) {
            Object object = this.mapProcessor.uiPauseSync;
            synchronized (object) {
                if (this.uiPausedOnUpdate != this.isUIPaused()) {
                    this.updateButtons(mapScreen, width, minecraft);
                }
            }
        }
        if (this.active && this.settingsDimension != null && this.createdDropdown.isClosed() && !this.uiPausedOnUpdate && (!(currentMultiworld = this.settingsDimension.getFutureMultiworldUnsynced()).equals(currentDropdownSelection = this.mwDropdownValues[this.createdDropdown.getSelected()]) || this.writableOnInit != this.settingsDimension.futureMultiworldWritable)) {
            mapScreen.method_25423(minecraft, width, height);
        }
    }

    public void renderText(class_332 guiGraphics, class_310 minecraft, int mouseX, int mouseY, int width, int height) {
        if (!this.active) {
            return;
        }
        String selectMapString = class_1074.method_4662((String)"gui.xaero_select_map", (Object[])new Object[0]) + ":";
        class_4597.class_4598 renderTypeBuffers = this.mapProcessor.getCvc().getRenderTypeBuffers();
        class_4588 backgroundVertexBuffer = renderTypeBuffers.getBuffer(CustomRenderTypes.MAP_COLOR_OVERLAY);
        MapRenderHelper.drawStringWithBackground(guiGraphics, minecraft.field_1772, selectMapString, width / 2 - minecraft.field_1772.method_1727(selectMapString) / 2, 49, -1, 0.0f, 0.0f, 0.0f, 0.4f, backgroundVertexBuffer);
        renderTypeBuffers.method_22993();
    }

    public void postMapRender(class_332 guiGraphics, class_310 minecraft, int mouseX, int mouseY, int width, int height) {
    }
}

