/*
 * Decompiled with CFR 0.152.
 */
package de.johni0702.minecraft.bobby;

import de.johni0702.minecraft.bobby.FakeChunkStorage;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import it.unimi.dsi.fastutil.longs.Long2LongMap;
import it.unimi.dsi.fastutil.longs.Long2LongOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.longs.LongList;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.stream.Stream;
import net.minecraft.class_156;
import net.minecraft.class_1923;
import net.minecraft.class_2540;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LastAccessFile
implements Closeable {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final String FILE_NAME = "last_access";
    private final Path path;
    private final Thread finalSaveThread = new Thread(this::saveOrLog, "bobby-save-last-access");
    private boolean closed;
    private final Long2LongMap accessMap;
    private long now = LastAccessFile.timestampSeconds();

    public LastAccessFile(Path directory) throws IOException {
        this.path = directory.resolve(FILE_NAME);
        try {
            this.accessMap = LastAccessFile.read(this.path);
        }
        catch (Exception e) {
            throw new IOException("Error parsing " + this.path, e);
        }
        if (Files.notExists(this.path, new LinkOption[0])) {
            try (Stream<Path> stream = Files.list(directory);){
                for (Path path : stream::iterator) {
                    Matcher matcher = FakeChunkStorage.REGION_FILE_PATTERN.matcher(path.getFileName().toString());
                    if (!matcher.matches()) continue;
                    this.touchRegion(Integer.parseInt(matcher.group(1)), Integer.parseInt(matcher.group(2)));
                }
            }
        }
        this.scheduleSave();
        Runtime.getRuntime().addShutdownHook(this.finalSaveThread);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void touchRegion(int x, int z) {
        Long2LongMap long2LongMap = this.accessMap;
        synchronized (long2LongMap) {
            this.accessMap.put(class_1923.method_8331((int)x, (int)z), this.now);
        }
    }

    private void scheduleSave() {
        if (this.closed) {
            return;
        }
        class_156.method_27958().submit(this::saveOrLog);
        CompletableFuture.delayedExecutor(1L, TimeUnit.MINUTES).execute(this::scheduleSave);
    }

    private void saveOrLog() {
        try {
            this.save();
        }
        catch (IOException e) {
            LOGGER.error("Failed to save last access file at " + this.path + ":", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void save() throws IOException {
        class_2540 buf;
        if (this.closed) {
            return;
        }
        Long2LongMap long2LongMap = this.accessMap;
        synchronized (long2LongMap) {
            this.now = LastAccessFile.timestampSeconds();
            buf = new class_2540(Unpooled.buffer((int)(this.accessMap.size() * 16)));
            buf.method_10791(this.accessMap.values().longStream().max().orElse(0L));
            for (Long2LongMap.Entry entry : this.accessMap.long2LongEntrySet()) {
                buf.method_10804(class_1923.method_8325((long)entry.getLongKey()));
                buf.method_10804(class_1923.method_8332((long)entry.getLongKey()));
                buf.method_10791(entry.getLongValue());
            }
        }
        Path tmpFile = Files.createTempFile(this.path.getParent(), this.path.getFileName().toString(), ".tmp", new FileAttribute[0]);
        try {
            Files.write(tmpFile, buf.method_36132(), new OpenOption[0]);
            Files.move(tmpFile, this.path, StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.ATOMIC_MOVE);
        }
        finally {
            Files.deleteIfExists(tmpFile);
        }
    }

    private static Long2LongMap read(Path path) throws IOException {
        Long2LongOpenHashMap map = new Long2LongOpenHashMap();
        if (Files.exists(path, new LinkOption[0])) {
            class_2540 buf = new class_2540(Unpooled.wrappedBuffer((byte[])Files.readAllBytes(path)));
            buf.method_10792();
            while (buf.isReadable()) {
                int x = buf.method_10816();
                int z = buf.method_10816();
                map.put(class_1923.method_8331((int)x, (int)z), buf.method_10792());
            }
        }
        return map;
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.save();
        Runtime.getRuntime().removeShutdownHook(this.finalSaveThread);
        this.closed = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LongList pollRegionsOlderThan(long days) {
        Long2LongMap long2LongMap = this.accessMap;
        synchronized (long2LongMap) {
            long timestamp = LastAccessFile.timestampSeconds() - days * 24L * 60L * 60L;
            LongArrayList list = new LongArrayList();
            this.accessMap.long2LongEntrySet().removeIf(arg_0 -> LastAccessFile.lambda$pollRegionsOlderThan$0(timestamp, (LongList)list, arg_0));
            return list;
        }
    }

    public static boolean isEverythingOlderThan(Path directory, long days) throws IOException {
        Path path = directory.resolve(FILE_NAME);
        if (Files.notExists(path, new LinkOption[0])) {
            new LastAccessFile(directory).close();
        }
        ByteBuf buffer = Unpooled.buffer((int)10);
        try (InputStream rawIn = Files.newInputStream(path, new OpenOption[0]);
             BufferedInputStream in = new BufferedInputStream(rawIn);){
            for (int i = 0; i < 10; ++i) {
                int b = in.read();
                if (b == -1) {
                    break;
                }
                buffer.writeByte(b);
            }
        }
        long mostRecentTimestamp = new class_2540(buffer).method_10792();
        return mostRecentTimestamp <= LastAccessFile.timestampSeconds() - days * 24L * 60L * 60L;
    }

    private static long timestampSeconds() {
        return class_156.method_659() / 1000L;
    }

    private static /* synthetic */ boolean lambda$pollRegionsOlderThan$0(long timestamp, LongList list, Long2LongMap.Entry it) {
        if (it.getLongValue() <= timestamp) {
            list.add(it.getLongKey());
            return true;
        }
        return false;
    }
}

