/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.api.component;

import com.mojang.blaze3d.systems.RenderSystem;
import mcp.mobius.waila.api.ITooltipComponent;
import mcp.mobius.waila.api.WailaConstants;
import mcp.mobius.waila.api.WailaHelper;
import mcp.mobius.waila.api.__internal__.ApiSide;
import net.minecraft.class_2561;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import net.minecraft.class_5244;
import net.minecraft.class_5348;
import net.minecraft.class_757;

@ApiSide.ClientOnly
public class BarComponent
implements ITooltipComponent {
    private static final int WIDTH = 100;
    private static final int HEIGHT = 11;
    private static final float U0 = 0.0859375f;
    private static final float U1 = 0.4765625f;
    private static final float V0_BG = 0.0f;
    private static final float V1_BG = 0.04296875f;
    private static final float V0_FG = 0.04296875f;
    private static final float V1_FG = 0.0859375f;
    private static final float UV_W = 0.390625f;
    private final float ratio;
    private final int color;
    private final class_2561 text;

    public BarComponent(float ratio, int color) {
        this(ratio, color, class_5244.field_39003);
    }

    public BarComponent(float ratio, int color, String text) {
        this(ratio, color, (class_2561)class_2561.method_43470((String)text));
    }

    public BarComponent(float ratio, int color, class_2561 text) {
        this.ratio = ratio;
        this.color = color;
        this.text = text;
    }

    @Override
    public int getWidth() {
        return Math.max(class_310.method_1551().field_1772.method_27525((class_5348)this.text), 100);
    }

    @Override
    public int getHeight() {
        return 11;
    }

    @Override
    public void render(class_332 ctx, int x, int y, float delta) {
        BarComponent.renderBar(ctx.method_51448(), x, y, 100.0f, 0.0f, 0.4765625f, 0.04296875f, this.color);
        BarComponent.renderBar(ctx.method_51448(), x, y, 100.0f * this.ratio, 0.04296875f, 0.0859375f + 0.390625f * this.ratio, 0.0859375f, this.color);
        double luminance = WailaHelper.getLuminance(this.color);
        int overlay = 0;
        if (luminance < 0.25) {
            overlay = 0x8FFFFFF;
        } else if (luminance > 0.9) {
            overlay = Integer.MIN_VALUE;
        } else if (luminance > 0.8) {
            overlay = 0x70000000;
        } else if (luminance > 0.7) {
            overlay = 0x60000000;
        } else if (luminance > 0.6) {
            overlay = 0x50000000;
        } else if (luminance > 0.5) {
            overlay = 0x40000000;
        }
        if (overlay != 0) {
            ctx.method_25294(x, y, x + 100, y + 11, overlay);
        }
        int textWidth = class_310.method_1551().field_1772.method_27525((class_5348)this.text);
        int textX = x + Math.max((100 - textWidth) / 2, 0);
        int textY = y + 2;
        ctx.method_27535(class_310.method_1551().field_1772, this.text, textX, textY, -5592406);
    }

    private static void renderBar(class_4587 matrices, int x, int y, float w, float v0, float u1, float v1, int tint) {
        matrices.method_22903();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(class_757::method_34541);
        RenderSystem.setShaderTexture((int)0, (class_2960)WailaConstants.COMPONENT_TEXTURE);
        int a = WailaHelper.getAlpha(tint);
        int r = WailaHelper.getRed(tint);
        int g = WailaHelper.getGreen(tint);
        int b = WailaHelper.getBlue(tint);
        class_289 tessellator = class_289.method_1348();
        class_287 buffer = tessellator.method_1349();
        buffer.method_1328(class_293.class_5596.field_27382, class_290.field_20887);
        buffer.method_22918(matrices.method_23760().method_23761(), (float)x, (float)(y + 11), 0.0f).method_1336(r, g, b, a).method_22913(0.0859375f, v1).method_1344();
        buffer.method_22918(matrices.method_23760().method_23761(), (float)x + w, (float)(y + 11), 0.0f).method_1336(r, g, b, a).method_22913(u1, v1).method_1344();
        buffer.method_22918(matrices.method_23760().method_23761(), (float)x + w, (float)y, 0.0f).method_1336(r, g, b, a).method_22913(u1, v0).method_1344();
        buffer.method_22918(matrices.method_23760().method_23761(), (float)x, (float)y, 0.0f).method_1336(r, g, b, a).method_22913(0.0859375f, v0).method_1344();
        tessellator.method_1350();
        RenderSystem.disableBlend();
        matrices.method_22909();
    }
}

