/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.registry;

import com.google.common.base.Preconditions;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import mcp.mobius.waila.Waila;
import mcp.mobius.waila.api.IBlockComponentProvider;
import mcp.mobius.waila.api.IData;
import mcp.mobius.waila.api.IDataProvider;
import mcp.mobius.waila.api.IEntityComponentProvider;
import mcp.mobius.waila.api.IEventListener;
import mcp.mobius.waila.api.IObjectPicker;
import mcp.mobius.waila.api.IRegistrar;
import mcp.mobius.waila.api.ITheme;
import mcp.mobius.waila.api.IThemeType;
import mcp.mobius.waila.api.IntFormat;
import mcp.mobius.waila.api.TooltipPosition;
import mcp.mobius.waila.config.BlacklistConfig;
import mcp.mobius.waila.config.ConfigEntry;
import mcp.mobius.waila.config.PluginConfig;
import mcp.mobius.waila.gui.hud.theme.ThemeType;
import mcp.mobius.waila.registry.Register;
import mcp.mobius.waila.util.TypeUtil;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_156;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2960;
import net.minecraft.class_7923;

public enum Registrar implements IRegistrar
{
    INSTANCE;

    public final Register<IBlockComponentProvider> blockOverride = new Register();
    public final Register<IBlockComponentProvider> blockIcon = new Register();
    public final Register<IDataProvider<class_2586>> blockData = new Register();
    public final Map<TooltipPosition, Register<IBlockComponentProvider>> blockComponent = (Map)class_156.method_654(new EnumMap(TooltipPosition.class), map -> {
        for (TooltipPosition key : TooltipPosition.values()) {
            map.put(key, new Register());
        }
    });
    public final Register<IEntityComponentProvider> entityOverride = new Register();
    public final Register<IEntityComponentProvider> entityIcon = new Register();
    public final Register<IDataProvider<class_1297>> entityData = new Register();
    public final Map<TooltipPosition, Register<IEntityComponentProvider>> entityComponent = (Map)class_156.method_654(new EnumMap(TooltipPosition.class), map -> {
        for (TooltipPosition key : TooltipPosition.values()) {
            map.put(key, new Register());
        }
    });
    public final Register<IEventListener> eventListeners = (Register)class_156.method_654(new Register(), Register::reversed);
    public final BlacklistConfig blacklist = new BlacklistConfig();
    public final Map<class_2960, IntFormat> intConfigFormats = new HashMap<class_2960, IntFormat>();
    public final BiMap<class_2960, ThemeType<?>> themeTypes = HashBiMap.create();
    private final Map<Class<? extends ITheme>, ThemeType<?>> themeClass2Type = new HashMap();
    public final Map<Class<? extends IData>, class_2960> dataType2Id = new HashMap<Class<? extends IData>, class_2960>();
    public final Map<class_2960, IData.Serializer<?>> dataId2Serializer = new HashMap();
    private int pickerPriority = Integer.MAX_VALUE;
    public IObjectPicker picker = null;
    private boolean locked = false;

    private <T> void addConfig(class_2960 key, T defaultValue, T clientOnlyValue, boolean serverRequired, boolean merged, ConfigEntry.Type<T> type) {
        this.assertLock();
        PluginConfig.addConfig(type.create(key, defaultValue, clientOnlyValue, serverRequired, merged));
    }

    @Override
    public void addConfig(class_2960 key, boolean defaultValue) {
        this.addConfig(key, defaultValue, defaultValue, false, false, ConfigEntry.BOOLEAN);
    }

    @Override
    public void addConfig(class_2960 key, int defaultValue, IntFormat format) {
        this.intConfigFormats.put(key, format);
        this.addConfig(key, defaultValue, defaultValue, false, false, ConfigEntry.INTEGER);
    }

    @Override
    public void addConfig(class_2960 key, double defaultValue) {
        this.addConfig(key, defaultValue, defaultValue, false, false, ConfigEntry.DOUBLE);
    }

    @Override
    public void addConfig(class_2960 key, String defaultValue) {
        this.addConfig(key, defaultValue, defaultValue, false, false, ConfigEntry.STRING);
    }

    @Override
    public <T extends Enum<T>> void addConfig(class_2960 key, T defaultValue) {
        this.addConfig(key, defaultValue, defaultValue, false, false, ConfigEntry.ENUM);
    }

    @Override
    public void addMergedConfig(class_2960 key, boolean defaultValue) {
        this.addConfig(key, defaultValue, defaultValue, false, true, ConfigEntry.BOOLEAN);
    }

    @Override
    public void addMergedSyncedConfig(class_2960 key, boolean defaultValue, boolean clientOnlyValue) {
        this.addConfig(key, defaultValue, clientOnlyValue, true, true, ConfigEntry.BOOLEAN);
    }

    @Override
    public void addSyncedConfig(class_2960 key, boolean defaultValue, boolean clientOnlyValue) {
        this.addConfig(key, defaultValue, clientOnlyValue, true, false, ConfigEntry.BOOLEAN);
    }

    @Override
    public void addSyncedConfig(class_2960 key, int defaultValue, int clientOnlyValue, IntFormat format) {
        this.intConfigFormats.put(key, format);
        this.addConfig(key, defaultValue, clientOnlyValue, true, false, ConfigEntry.INTEGER);
    }

    @Override
    public void addSyncedConfig(class_2960 key, double defaultValue, double clientOnlyValue) {
        this.addConfig(key, defaultValue, clientOnlyValue, true, false, ConfigEntry.DOUBLE);
    }

    @Override
    public void addSyncedConfig(class_2960 key, String defaultValue, String clientOnlyValue) {
        this.addConfig(key, defaultValue, clientOnlyValue, true, false, ConfigEntry.STRING);
    }

    @Override
    public <T extends Enum<T>> void addSyncedConfig(class_2960 key, T defaultValue, T clientOnlyValue) {
        this.addConfig(key, defaultValue, clientOnlyValue, true, false, ConfigEntry.ENUM);
    }

    @Override
    public void addEventListener(IEventListener listener, int priority) {
        this.assertLock();
        this.eventListeners.add(Object.class, listener, priority);
    }

    @Override
    public void addBlacklist(class_2248 ... blocks) {
        this.assertLock();
        this.blacklist.blocks.addAll(Arrays.asList(blocks));
    }

    @Override
    public void addBlacklist(class_2591<?> ... blockEntityTypes) {
        this.blacklist.blockEntityTypes.addAll(Arrays.asList(blockEntityTypes));
    }

    @Override
    public <T> void addOverride(IBlockComponentProvider provider, Class<T> clazz, int priority) {
        if (Waila.CLIENT_SIDE) {
            this.assertLock();
            this.assertPriority(priority);
            this.blockOverride.add(clazz, provider, priority);
        }
    }

    @Override
    public <T> void addIcon(IBlockComponentProvider provider, Class<T> clazz, int priority) {
        if (Waila.CLIENT_SIDE) {
            this.assertLock();
            this.assertPriority(priority);
            this.blockIcon.add(clazz, provider, priority);
        }
    }

    @Override
    public <T> void addComponent(IBlockComponentProvider provider, TooltipPosition position, Class<T> clazz, int priority) {
        if (Waila.CLIENT_SIDE) {
            this.assertLock();
            this.assertPriority(priority);
            this.blockComponent.get((Object)position).add(clazz, provider, priority);
        }
    }

    @Override
    public <T, BE extends class_2586> void addBlockData(IDataProvider<BE> provider, Class<T> clazz, int priority) {
        this.assertLock();
        this.blockData.add(clazz, provider, priority);
    }

    @Override
    public void addBlacklist(class_1299<?> ... entityTypes) {
        this.assertLock();
        this.blacklist.entityTypes.addAll(Arrays.asList(entityTypes));
    }

    @Override
    public <T> void addOverride(IEntityComponentProvider provider, Class<T> clazz, int priority) {
        if (Waila.CLIENT_SIDE) {
            this.assertLock();
            this.assertPriority(priority);
            this.entityOverride.add(clazz, provider, priority);
        }
    }

    @Override
    public <T> void addIcon(IEntityComponentProvider provider, Class<T> clazz, int priority) {
        if (Waila.CLIENT_SIDE) {
            this.assertLock();
            this.assertPriority(priority);
            this.entityIcon.add(clazz, provider, priority);
        }
    }

    @Override
    public <T> void addComponent(IEntityComponentProvider provider, TooltipPosition position, Class<T> clazz, int priority) {
        if (Waila.CLIENT_SIDE) {
            this.assertLock();
            this.assertPriority(priority);
            this.entityComponent.get((Object)position).add(clazz, provider, priority);
        }
    }

    @Override
    public <T, E extends class_1297> void addEntityData(IDataProvider<E> provider, Class<T> clazz, int priority) {
        this.assertLock();
        this.entityData.add(clazz, provider, priority);
    }

    @Override
    public <T extends IData> void addDataType(class_2960 id, Class<T> type, IData.Serializer<T> serializer) {
        this.assertLock();
        Preconditions.checkArgument((!this.dataId2Serializer.containsKey(id) ? 1 : 0) != 0, (String)"Data type with id %s already present", (Object)id);
        this.dataType2Id.put(type, id);
        this.dataId2Serializer.put(id, serializer);
    }

    @Override
    public <T extends ITheme> void addThemeType(class_2960 id, IThemeType<T> type) {
        if (Waila.CLIENT_SIDE) {
            this.assertLock();
            ThemeType casted = (ThemeType)TypeUtil.uncheckedCast(type);
            this.themeTypes.put((Object)id, (Object)casted);
            this.themeClass2Type.put(casted.clazz, casted);
        }
    }

    @Override
    public void replacePicker(IObjectPicker picker, int priority) {
        if (Waila.CLIENT_SIDE) {
            this.assertLock();
            this.assertPriority(priority);
            if (priority <= this.pickerPriority) {
                this.picker = picker;
                this.pickerPriority = priority;
            }
        }
    }

    public void lock() {
        this.locked = true;
        if (Waila.CLIENT_SIDE) {
            Preconditions.checkState((this.picker != null ? 1 : 0) != 0, (Object)"No object picker registered");
            Waila.LOGGER.info("Using {} as the object picker", (Object)this.picker.getClass().getName());
        }
        int[] hash = new int[]{0, 0, 0};
        hash[0] = this.hash((Set)this.blacklist.blocks, (class_2378)class_7923.field_41175);
        hash[1] = this.hash(this.blacklist.blockEntityTypes, class_7923.field_41181);
        hash[2] = this.hash((Set)this.blacklist.entityTypes, (class_2378)class_7923.field_41177);
        if (Waila.BLACKLIST_CONFIG.isFileExists() && !Arrays.equals(Waila.BLACKLIST_CONFIG.get().pluginHash, hash)) {
            Waila.BLACKLIST_CONFIG.backup();
        }
        BlacklistConfig newBlacklist = Waila.BLACKLIST_CONFIG.get();
        newBlacklist.pluginHash = hash;
        newBlacklist.blocks.addAll(this.blacklist.blocks);
        newBlacklist.entityTypes.addAll(this.blacklist.entityTypes);
        Waila.BLACKLIST_CONFIG.save();
    }

    private void assertLock() {
        Preconditions.checkState((!this.locked ? 1 : 0) != 0, (Object)"Tried to register new component after the registrar is locked");
    }

    private void assertPriority(int priority) {
        Preconditions.checkArgument((priority >= 0 ? 1 : 0) != 0, (Object)"Priority must be equals or more than 0");
    }

    private <T> int hash(Set<T> set, class_2378<T> registry) {
        return set.stream().map(arg_0 -> registry.method_10221(arg_0)).collect(Collectors.toSet()).hashCode();
    }
}

