/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.util;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import mcp.mobius.waila.Waila;
import mcp.mobius.waila.api.ITooltip;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import org.apache.commons.lang3.exception.ExceptionUtils;

public final class ExceptionUtil {
    private static final Set<String> ERRORS = new HashSet<String>();
    private static final DateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd - HH:mm:ss");
    private static final File ERROR_FILE = Waila.GAME_DIR.resolve("logs/waila_errors.log").toFile();

    public static void dump(Throwable e, String errorName, ITooltip tooltip) {
        if (ERRORS.add(errorName)) {
            Waila.LOGGER.error("Caught unhandled exception : [{}] {}", (Object)errorName, (Object)e);
            Waila.LOGGER.error("See {} for more information", (Object)ERROR_FILE);
            try (FileWriter writer = new FileWriter(ERROR_FILE, StandardCharsets.UTF_8);){
                writer.write(DATE_FORMAT.format(new Date()) + "\n" + errorName + "\n" + ExceptionUtils.getStackTrace((Throwable)e) + "\n");
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (tooltip != null) {
            tooltip.addLine((class_2561)class_2561.method_43470((String)("Error on " + errorName)).method_27692(class_124.field_1061));
            tooltip.addLine((class_2561)class_2561.method_43470((String)"See logs/waila_errors.log for more info").method_27692(class_124.field_1061));
        }
    }

    static {
        ERROR_FILE.getParentFile().mkdirs();
    }
}

