/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.util.workarounds;

import java.util.EnumSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import me.jellysquid.mods.sodium.client.util.workarounds.DriverProbeLauncher;
import me.jellysquid.mods.sodium.client.util.workarounds.DriverProbeResult;
import net.minecraft.class_156;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DriverWorkarounds {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"Sodium");
    private static final AtomicReference<Set<Reference>> ACTIVE_WORKAROUNDS = new AtomicReference<EnumSet<Reference>>(EnumSet.noneOf(Reference.class));

    public static void init() {
        DriverProbeResult result;
        LOGGER.info("Launching a new process to probe the system configuration!");
        try {
            result = DriverProbeLauncher.launchProbe();
        }
        catch (Throwable t) {
            LOGGER.error("Failed to launch driver probe", t);
            return;
        }
        LOGGER.info("OpenGL Vendor: {}", (Object)result.vendor);
        LOGGER.info("OpenGL Renderer: {}", (Object)result.renderer);
        LOGGER.info("OpenGL Version: {}", (Object)result.version);
        Set<Reference> workarounds = DriverWorkarounds.updateWorkarounds(result);
        if (!workarounds.isEmpty()) {
            LOGGER.warn("One or more workarounds were enabled to prevent crashes or other issues on your system. You may need to update your graphics drivers.");
        }
        ACTIVE_WORKAROUNDS.set(workarounds);
    }

    private static Set<Reference> updateWorkarounds(DriverProbeResult probe) {
        EnumSet<Reference> workarounds = EnumSet.noneOf(Reference.class);
        class_156.class_158 operatingSystem = class_156.method_668();
        if (operatingSystem == class_156.class_158.field_1133 && probe.vendor.contains("NVIDIA")) {
            workarounds.add(Reference.ISSUE_1486);
            LOGGER.warn("Enabling workaround for NVIDIA graphics drivers on Windows (issue #1486)");
        }
        return workarounds;
    }

    public static boolean isWorkaroundEnabled(Reference id) {
        return ACTIVE_WORKAROUNDS.get().contains((Object)id);
    }

    public static enum Reference {
        ISSUE_1486;

    }
}

