/*
 * Decompiled with CFR 0.152.
 */
package me.axieum.mcmod.authme.api.util;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.sun.net.httpserver.HttpServer;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import me.axieum.mcmod.authme.impl.AuthMe;
import net.minecraft.class_156;
import net.minecraft.class_320;
import net.minecraft.class_3518;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class MicrosoftUtils {
    public static final RequestConfig REQUEST_CONFIG = RequestConfig.custom().setConnectionRequestTimeout(30000).setConnectTimeout(30000).setSocketTimeout(30000).build();
    public static final String CLIENT_ID = "e16699bb-2aa8-46da-b5e3-45cbcce29091";
    public static final String AUTHORIZE_URL = "https://login.microsoftonline.com/consumers/oauth2/v2.0/authorize";
    public static final String TOKEN_URL = "https://login.microsoftonline.com/consumers/oauth2/v2.0/token";
    public static final String XBOX_AUTH_URL = "https://user.auth.xboxlive.com/user/authenticate";
    public static final String XBOX_XSTS_URL = "https://xsts.auth.xboxlive.com/xsts/authorize";
    public static final String MC_AUTH_URL = "https://api.minecraftservices.com/authentication/login_with_xbox";
    public static final String MC_PROFILE_URL = "https://api.minecraftservices.com/minecraft/profile";

    private MicrosoftUtils() {
    }

    public static CompletableFuture<String> acquireMSAuthCode(Function<Boolean, @NotNull String> browserMessage, Executor executor) {
        return MicrosoftUtils.acquireMSAuthCode((URI url) -> class_156.method_668().method_673(url), browserMessage, executor);
    }

    public static CompletableFuture<String> acquireMSAuthCode(Function<Boolean, @NotNull String> browserMessage, Executor executor, @Nullable MicrosoftPrompt prompt) {
        return MicrosoftUtils.acquireMSAuthCode(url -> class_156.method_668().method_673(url), browserMessage, executor, prompt);
    }

    public static CompletableFuture<String> acquireMSAuthCode(Consumer<URI> browserAction, Function<Boolean, @NotNull String> browserMessage, Executor executor) {
        return MicrosoftUtils.acquireMSAuthCode(browserAction, browserMessage, executor, null);
    }

    public static CompletableFuture<String> acquireMSAuthCode(Consumer<URI> browserAction, Function<Boolean, @NotNull String> browserMessage, Executor executor, @Nullable MicrosoftPrompt prompt) {
        return CompletableFuture.supplyAsync(() -> {
            AuthMe.LOGGER.info("Acquiring Microsoft auth code...");
            String state = RandomStringUtils.randomAlphanumeric((int)8);
            HttpServer server = HttpServer.create(new InetSocketAddress(AuthMe.getConfig().methods.microsoft.port), 0);
            CountDownLatch latch = new CountDownLatch(1);
            AtomicReference<@Nullable Object> authCode = new AtomicReference<Object>(null);
            AtomicReference<@Nullable Object> errorMsg = new AtomicReference<Object>(null);
            server.createContext("/callback", exchange -> {
                Map<String, String> query = URLEncodedUtils.parse((URI)exchange.getRequestURI(), (Charset)StandardCharsets.UTF_8).stream().collect(Collectors.toMap(NameValuePair::getName, NameValuePair::getValue));
                if (!state.equals(query.get("state"))) {
                    errorMsg.set(String.format("State mismatch! Expected '%s' but got '%s'.", state, query.get("state")));
                } else if (query.containsKey("code")) {
                    authCode.set(query.get("code"));
                } else if (query.containsKey("error")) {
                    errorMsg.set(String.format("%s: %s", query.get("error"), query.get("error_description")));
                }
                byte @Nullable [] message = ((String)browserMessage.apply(errorMsg.get() == null)).getBytes();
                exchange.sendResponseHeaders(200, message.length);
                OutputStream res = exchange.getResponseBody();
                res.write(message);
                res.close();
                latch.countDown();
            });
            URIBuilder uriBuilder = new URIBuilder(AuthMe.getConfig().methods.microsoft.authorizeUrl).addParameter("client_id", AuthMe.getConfig().methods.microsoft.clientId).addParameter("response_type", "code").addParameter("redirect_uri", String.format("http://localhost:%d/callback", server.getAddress().getPort())).addParameter("scope", "XboxLive.signin offline_access").addParameter("state", state);
            if (prompt != null || AuthMe.getConfig().methods.microsoft.prompt != MicrosoftPrompt.DEFAULT) {
                uriBuilder.addParameter("prompt", (prompt != null ? prompt : AuthMe.getConfig().methods.microsoft.prompt).toString());
            }
            URI uri = uriBuilder.build();
            AuthMe.LOGGER.info("Launching Microsoft login in browser: {}", (Object)uri.toString());
            browserAction.accept(uri);
            try {
                AuthMe.LOGGER.info("Begin listening on http://localhost:{}/callback for a successful Microsoft login...", (Object)server.getAddress().getPort());
                server.start();
                latch.await();
                String string = Optional.ofNullable(authCode.get()).filter(code -> !code.isBlank()).map(code -> {
                    AuthMe.LOGGER.info("Acquired Microsoft auth code! ({})", (Object)StringUtils.abbreviateMiddle((String)code, (String)"...", (int)32));
                    return code;
                }).orElseThrow(() -> new Exception(Optional.ofNullable((String)errorMsg.get()).orElse("There was no auth code or error description present.")));
                server.stop(2);
                return string;
            }
            catch (Throwable throwable) {
                try {
                    server.stop(2);
                    throw throwable;
                }
                catch (InterruptedException e) {
                    AuthMe.LOGGER.warn("Microsoft auth code acquisition was cancelled!");
                    throw new CancellationException("Interrupted");
                }
                catch (Exception e) {
                    AuthMe.LOGGER.error("Unable to acquire Microsoft auth code!", (Throwable)e);
                    throw new CompletionException(e);
                }
            }
        }, executor);
    }

    public static CompletableFuture<String> acquireMSAccessToken(String authCode, Executor executor) {
        return CompletableFuture.supplyAsync(() -> {
            String string;
            block9: {
                AuthMe.LOGGER.info("Exchanging Microsoft auth code for an access token...");
                CloseableHttpClient client = HttpClients.createMinimal();
                try {
                    HttpPost request = new HttpPost(URI.create(AuthMe.getConfig().methods.microsoft.tokenUrl));
                    request.setConfig(REQUEST_CONFIG);
                    request.setHeader("Content-Type", "application/x-www-form-urlencoded");
                    request.setEntity((HttpEntity)new UrlEncodedFormEntity(List.of(new BasicNameValuePair("client_id", AuthMe.getConfig().methods.microsoft.clientId), new BasicNameValuePair("grant_type", "authorization_code"), new BasicNameValuePair("code", authCode), new BasicNameValuePair("redirect_uri", String.format("http://localhost:%d/callback", AuthMe.getConfig().methods.microsoft.port))), "UTF-8"));
                    AuthMe.LOGGER.info("[{}] {} (timeout={}s)", (Object)request.getMethod(), (Object)request.getURI().toString(), (Object)(request.getConfig().getConnectTimeout() / 1000));
                    CloseableHttpResponse res = client.execute((HttpUriRequest)request);
                    JsonObject json = class_3518.method_15285((String)EntityUtils.toString((HttpEntity)res.getEntity()));
                    string = Optional.ofNullable(json.get("access_token")).map(JsonElement::getAsString).filter(token -> !token.isBlank()).map(token -> {
                        AuthMe.LOGGER.info("Acquired Microsoft access token! ({})", (Object)StringUtils.abbreviateMiddle((String)token, (String)"...", (int)32));
                        return token;
                    }).orElseThrow(() -> new Exception(json.has("error") ? String.format("%s: %s", json.get("error").getAsString(), json.get("error_description").getAsString()) : "There was no access token or error description present."));
                    if (client == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (client != null) {
                            try {
                                client.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (InterruptedException e) {
                        AuthMe.LOGGER.warn("Microsoft access token acquisition was cancelled!");
                        throw new CancellationException("Interrupted");
                    }
                    catch (Exception e) {
                        AuthMe.LOGGER.error("Unable to acquire Microsoft access token!", (Throwable)e);
                        throw new CompletionException(e);
                    }
                }
                client.close();
            }
            return string;
        }, executor);
    }

    public static CompletableFuture<String> acquireXboxAccessToken(String accessToken, Executor executor) {
        return CompletableFuture.supplyAsync(() -> {
            String string;
            block9: {
                AuthMe.LOGGER.info("Exchanging Microsoft access token for an Xbox Live access token...");
                CloseableHttpClient client = HttpClients.createMinimal();
                try {
                    HttpPost request = new HttpPost(URI.create(AuthMe.getConfig().methods.microsoft.xboxAuthUrl));
                    request.setConfig(REQUEST_CONFIG);
                    request.setHeader("Content-Type", "application/json");
                    request.setEntity((HttpEntity)new StringEntity(String.format("{\n  \"Properties\": {\n    \"AuthMethod\": \"RPS\",\n    \"SiteName\": \"user.auth.xboxlive.com\",\n    \"RpsTicket\": \"d=%s\"\n  },\n  \"RelyingParty\": \"http://auth.xboxlive.com\",\n  \"TokenType\": \"JWT\"\n}", accessToken)));
                    AuthMe.LOGGER.info("[{}] {} (timeout={}s)", (Object)request.getMethod(), (Object)request.getURI().toString(), (Object)(request.getConfig().getConnectTimeout() / 1000));
                    CloseableHttpResponse res = client.execute((HttpUriRequest)request);
                    JsonObject json = res.getStatusLine().getStatusCode() == 200 ? class_3518.method_15285((String)EntityUtils.toString((HttpEntity)res.getEntity())) : new JsonObject();
                    string = Optional.ofNullable(json.get("Token")).map(JsonElement::getAsString).filter(token -> !token.isBlank()).map(token -> {
                        AuthMe.LOGGER.info("Acquired Xbox Live access token! ({})", (Object)StringUtils.abbreviateMiddle((String)token, (String)"...", (int)32));
                        return token;
                    }).orElseThrow(() -> new Exception(json.has("XErr") ? String.format("%s: %s", json.get("XErr").getAsString(), json.get("Message").getAsString()) : "There was no access token or error description present."));
                    if (client == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (client != null) {
                            try {
                                client.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (InterruptedException e) {
                        AuthMe.LOGGER.warn("Xbox Live access token acquisition was cancelled!");
                        throw new CancellationException("Interrupted");
                    }
                    catch (Exception e) {
                        AuthMe.LOGGER.error("Unable to acquire Xbox Live access token!", (Throwable)e);
                        throw new CompletionException(e);
                    }
                }
                client.close();
            }
            return string;
        }, executor);
    }

    public static CompletableFuture<Map<String, String>> acquireXboxXstsToken(String accessToken, Executor executor) {
        return CompletableFuture.supplyAsync(() -> {
            Map map;
            block9: {
                AuthMe.LOGGER.info("Exchanging Xbox Live token for an Xbox Live XSTS token...");
                CloseableHttpClient client = HttpClients.createMinimal();
                try {
                    HttpPost request = new HttpPost(URI.create(AuthMe.getConfig().methods.microsoft.xboxXstsUrl));
                    request.setConfig(REQUEST_CONFIG);
                    request.setHeader("Content-Type", "application/json");
                    request.setEntity((HttpEntity)new StringEntity(String.format("{\n  \"Properties\": {\n    \"SandboxId\": \"RETAIL\",\n    \"UserTokens\": [\"%s\"]\n  },\n  \"RelyingParty\": \"rp://api.minecraftservices.com/\",\n  \"TokenType\": \"JWT\"\n}", accessToken)));
                    AuthMe.LOGGER.info("[{}] {} (timeout={}s)", (Object)request.getMethod(), (Object)request.getURI().toString(), (Object)(request.getConfig().getConnectTimeout() / 1000));
                    CloseableHttpResponse res = client.execute((HttpUriRequest)request);
                    JsonObject json = res.getStatusLine().getStatusCode() == 200 ? class_3518.method_15285((String)EntityUtils.toString((HttpEntity)res.getEntity())) : new JsonObject();
                    map = Optional.ofNullable(json.get("Token")).map(JsonElement::getAsString).filter(token -> !token.isBlank()).map(token -> {
                        String uhs = json.get("DisplayClaims").getAsJsonObject().get("xui").getAsJsonArray().get(0).getAsJsonObject().get("uhs").getAsString();
                        AuthMe.LOGGER.info("Acquired Xbox Live XSTS token! (token={}, uhs={})", (Object)StringUtils.abbreviateMiddle((String)token, (String)"...", (int)32), (Object)uhs);
                        return Map.of("Token", token, "uhs", uhs);
                    }).orElseThrow(() -> new Exception(json.has("XErr") ? String.format("%s: %s", json.get("XErr").getAsString(), json.get("Message").getAsString()) : "There was no access token or error description present."));
                    if (client == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (client != null) {
                            try {
                                client.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (InterruptedException e) {
                        AuthMe.LOGGER.warn("Xbox Live XSTS token acquisition was cancelled!");
                        throw new CancellationException("Interrupted");
                    }
                    catch (Exception e) {
                        AuthMe.LOGGER.error("Unable to acquire Xbox Live XSTS token!", (Throwable)e);
                        throw new CompletionException(e);
                    }
                }
                client.close();
            }
            return map;
        }, executor);
    }

    public static CompletableFuture<String> acquireMCAccessToken(String xstsToken, String userHash, Executor executor) {
        return CompletableFuture.supplyAsync(() -> {
            String string;
            block9: {
                AuthMe.LOGGER.info("Exchanging Xbox Live XSTS token for a Minecraft access token...");
                CloseableHttpClient client = HttpClients.createMinimal();
                try {
                    HttpPost request = new HttpPost(URI.create(AuthMe.getConfig().methods.microsoft.mcAuthUrl));
                    request.setConfig(REQUEST_CONFIG);
                    request.setHeader("Content-Type", "application/json");
                    request.setEntity((HttpEntity)new StringEntity(String.format("{\"identityToken\": \"XBL3.0 x=%s;%s\"}", userHash, xstsToken)));
                    AuthMe.LOGGER.info("[{}] {} (timeout={}s)", (Object)request.getMethod(), (Object)request.getURI().toString(), (Object)(request.getConfig().getConnectTimeout() / 1000));
                    CloseableHttpResponse res = client.execute((HttpUriRequest)request);
                    JsonObject json = class_3518.method_15285((String)EntityUtils.toString((HttpEntity)res.getEntity()));
                    string = Optional.ofNullable(json.get("access_token")).map(JsonElement::getAsString).filter(token -> !token.isBlank()).map(token -> {
                        AuthMe.LOGGER.info("Acquired Minecraft access token! ({})", (Object)StringUtils.abbreviateMiddle((String)token, (String)"...", (int)32));
                        return token;
                    }).orElseThrow(() -> new Exception(json.has("error") ? String.format("%s: %s", json.get("error").getAsString(), json.get("errorMessage").getAsString()) : "There was no access token or error description present."));
                    if (client == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (client != null) {
                            try {
                                client.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (InterruptedException e) {
                        AuthMe.LOGGER.warn("Minecraft access token acquisition was cancelled!");
                        throw new CancellationException("Interrupted");
                    }
                    catch (Exception e) {
                        AuthMe.LOGGER.error("Unable to acquire Minecraft access token!", (Throwable)e);
                        throw new CompletionException(e);
                    }
                }
                client.close();
            }
            return string;
        }, executor);
    }

    public static CompletableFuture<class_320> login(String mcToken, Executor executor) {
        return CompletableFuture.supplyAsync(() -> {
            class_320 class_3202;
            block9: {
                AuthMe.LOGGER.info("Fetching Minecraft profile...");
                CloseableHttpClient client = HttpClients.createMinimal();
                try {
                    HttpGet request = new HttpGet(URI.create(AuthMe.getConfig().methods.microsoft.mcProfileUrl));
                    request.setConfig(REQUEST_CONFIG);
                    request.setHeader("Authorization", "Bearer " + mcToken);
                    AuthMe.LOGGER.info("[{}] {} (timeout={}s)", (Object)request.getMethod(), (Object)request.getURI().toString(), (Object)(request.getConfig().getConnectTimeout() / 1000));
                    CloseableHttpResponse res = client.execute((HttpUriRequest)request);
                    JsonObject json = class_3518.method_15285((String)EntityUtils.toString((HttpEntity)res.getEntity()));
                    class_3202 = Optional.ofNullable(json.get("id")).map(JsonElement::getAsString).filter(uuid -> !uuid.isBlank()).map(uuid -> {
                        AuthMe.LOGGER.info("Fetched Minecraft profile! (name={}, uuid={})", (Object)json.get("name").getAsString(), uuid);
                        return new class_320(json.get("name").getAsString(), uuid, mcToken, Optional.empty(), Optional.empty(), class_320.class_321.field_1988);
                    }).orElseThrow(() -> new Exception(json.has("error") ? String.format("%s: %s", json.get("error").getAsString(), json.get("errorMessage").getAsString()) : "There was no profile or error description present."));
                    if (client == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (client != null) {
                            try {
                                client.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (InterruptedException e) {
                        AuthMe.LOGGER.warn("Minecraft profile fetching was cancelled!");
                        throw new CancellationException("Interrupted");
                    }
                    catch (Exception e) {
                        AuthMe.LOGGER.error("Unable to fetch Minecraft profile!", (Throwable)e);
                        throw new CompletionException(e);
                    }
                }
                client.close();
            }
            return class_3202;
        }, executor);
    }

    public static enum MicrosoftPrompt {
        DEFAULT(""),
        SELECT_ACCOUNT("select_account"),
        LOGIN("login"),
        NONE("none"),
        CONSENT("consent");

        private final String prompt;

        private MicrosoftPrompt(String prompt) {
            this.prompt = prompt;
        }

        public String toString() {
            return this.prompt;
        }
    }
}

