/*
 * Decompiled with CFR 0.152.
 */
package com.github.franckyi.databindings.api;

import com.github.franckyi.databindings.api.DataBindings;
import com.github.franckyi.databindings.api.ObservableObjectValue;
import com.github.franckyi.databindings.api.ObservableValue;
import com.github.franckyi.databindings.api.StringProperty;
import java.util.function.Supplier;

public interface ObservableStringValue
extends ObservableObjectValue<String> {
    public static ObservableStringValue unmodifiable(final String value) {
        return new Unmodifiable(){

            @Override
            public String get() {
                return value;
            }
        };
    }

    public static ObservableStringValue readOnly(StringProperty property) {
        return DataBindings.getPropertyFactory().createReadOnlyProperty(property);
    }

    public static ObservableStringValue observe(Supplier<String> supplier, ObservableValue<?> ... triggers) {
        return DataBindings.getMappingFactory().createStringMapping(supplier, triggers);
    }

    default public ObservableStringValue append(String other) {
        return this.mapToString(s -> s + other, other);
    }

    default public ObservableStringValue prepend(String other) {
        return this.mapToString(s -> other + s, other);
    }

    default public ObservableStringValue append(ObservableValue<String> other) {
        return ObservableStringValue.observe(() -> (String)this.get() + (String)other.get(), new ObservableValue[]{this, other});
    }

    default public ObservableStringValue prepend(ObservableValue<String> other) {
        return ObservableStringValue.observe(() -> (String)other.get() + (String)this.get(), new ObservableValue[]{this, other});
    }

    public static abstract class Unmodifiable
    extends ObservableValue.Unmodifiable<String>
    implements ObservableStringValue {
    }
}

