/*
 * Decompiled with CFR 0.152.
 */
package com.github.franckyi.ibeeditor.client.screen.model.category.item;

import com.github.franckyi.ibeeditor.client.screen.model.ItemEditorModel;
import com.github.franckyi.ibeeditor.client.screen.model.category.item.ItemEditorCategoryModel;
import com.github.franckyi.ibeeditor.client.screen.model.entry.EntryModel;
import com.github.franckyi.ibeeditor.client.screen.model.entry.item.PotionEffectEntryModel;
import com.github.franckyi.ibeeditor.client.screen.model.entry.item.PotionSelectionEntryModel;
import com.github.franckyi.ibeeditor.common.ModTexts;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_5250;

public class ItemPotionEffectsCategoryModel
extends ItemEditorCategoryModel {
    private class_2499 potionEffectList;

    public ItemPotionEffectsCategoryModel(ItemEditorModel editor) {
        super((class_2561)ModTexts.POTION_EFFECTS, editor);
    }

    @Override
    protected void setupEntries() {
        this.getEntries().add(new PotionSelectionEntryModel(this, ModTexts.DEFAULT_POTION, this.getTag().method_10558("Potion"), this.getCustomPotionColor(), p -> this.getTag().method_10582("Potion", p), this::setCustomPotionColor));
        this.getTag().method_10554("CustomPotionEffects", 10).stream().map(class_2487.class::cast).map(this::createPotionEffectEntry).forEach(this.getEntries()::add);
    }

    @Override
    public int getEntryListStart() {
        return 1;
    }

    @Override
    public EntryModel createNewListEntry() {
        return this.createPotionEffectEntry(null);
    }

    @Override
    public int getEntryHeight() {
        return 50;
    }

    @Override
    protected class_5250 getAddListEntryButtonTooltip() {
        return ModTexts.EFFECT;
    }

    private int getCustomPotionColor() {
        return this.getTag().method_10573("CustomPotionColor", 3) ? this.getTag().method_10550("CustomPotionColor") : Integer.MIN_VALUE;
    }

    private void setCustomPotionColor(int color) {
        if (color != Integer.MIN_VALUE) {
            this.getOrCreateTag().method_10569("CustomPotionColor", color);
        } else {
            this.getOrCreateTag().method_10551("CustomPotionColor");
        }
    }

    private EntryModel createPotionEffectEntry(class_2487 tag) {
        if (tag != null) {
            int id = tag.method_10550("Id");
            int amplifier = tag.method_10550("Amplifier");
            int duration = tag.method_10573("Duration", 3) ? tag.method_10550("Duration") : 1;
            boolean ambient = tag.method_10577("Ambient");
            boolean showParticles = !tag.method_10573("ShowParticles", 1) || tag.method_10577("ShowParticles");
            boolean showIcon = tag.method_10577("ShowIcon");
            return new PotionEffectEntryModel(this, id, amplifier, duration, ambient, showParticles, showIcon, this::addPotionEffect);
        }
        return new PotionEffectEntryModel(this, 1, 0, 1, false, true, true, this::addPotionEffect);
    }

    @Override
    public void apply() {
        this.potionEffectList = new class_2499();
        super.apply();
        if (!this.potionEffectList.isEmpty()) {
            this.getOrCreateTag().method_10566("CustomPotionEffects", (class_2520)this.potionEffectList);
        } else if (this.getOrCreateTag().method_10545("CustomPotionEffects")) {
            this.getOrCreateTag().method_10551("CustomPotionEffects");
        }
    }

    private void addPotionEffect(int id, int amplifier, int duration, boolean ambient, boolean showParticles, boolean showIcon) {
        class_2487 tag = new class_2487();
        tag.method_10569("Id", id);
        tag.method_10569("Amplifier", amplifier);
        tag.method_10569("Duration", duration);
        tag.method_10556("Ambient", ambient);
        tag.method_10556("ShowParticles", showParticles);
        tag.method_10556("ShowIcon", showIcon);
        this.potionEffectList.add((Object)tag);
    }
}

