/*
 * Decompiled with CFR 0.152.
 */
package com.github.franckyi.ibeeditor.common.logic;

import com.github.franckyi.ibeeditor.common.CommonUtil;
import com.github.franckyi.ibeeditor.common.ModTexts;
import com.github.franckyi.ibeeditor.common.logic.PermissionLogic;
import com.github.franckyi.ibeeditor.common.network.BlockEditorPacket;
import com.github.franckyi.ibeeditor.common.network.BlockInventoryItemEditorPacket;
import com.github.franckyi.ibeeditor.common.network.EntityEditorPacket;
import com.github.franckyi.ibeeditor.common.network.EntityInventoryItemEditorPacket;
import com.github.franckyi.ibeeditor.common.network.MainHandItemEditorPacket;
import com.github.franckyi.ibeeditor.common.network.PlayerInventoryItemEditorPacket;
import net.minecraft.class_1263;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2586;
import net.minecraft.class_3222;

public final class ServerEditorUpdateLogic {
    public static void onMainHandItemEditorUpdate(class_3222 player, MainHandItemEditorPacket.Update response) {
        if (!PermissionLogic.hasPermission(player)) {
            CommonUtil.showPermissionError((class_1657)player, ModTexts.ITEM);
            return;
        }
        player.method_6122(class_1268.field_5808, response.getItemStack());
        CommonUtil.showUpdateSuccess((class_1657)player, ModTexts.ITEM);
    }

    public static void onPlayerInventoryItemEditorUpdate(class_3222 player, PlayerInventoryItemEditorPacket.Update response) {
        if (!PermissionLogic.hasPermission(player)) {
            CommonUtil.showPermissionError((class_1657)player, ModTexts.ITEM);
            return;
        }
        player.method_31548().method_5447(response.getSlot(), response.getItemStack());
        CommonUtil.showUpdateSuccess((class_1657)player, ModTexts.ITEM);
    }

    public static void onBlockInventoryItemEditorUpdate(class_3222 player, BlockInventoryItemEditorPacket.Update response) {
        if (!PermissionLogic.hasPermission(player)) {
            CommonUtil.showPermissionError((class_1657)player, ModTexts.ITEM);
            return;
        }
        class_2586 class_25862 = player.method_37908().method_8321(response.getBlockPos());
        if (class_25862 instanceof class_1263) {
            class_1263 container = (class_1263)class_25862;
            container.method_5447(response.getSlot(), response.getItemStack());
            CommonUtil.showUpdateSuccess((class_1657)player, ModTexts.ITEM);
        } else {
            CommonUtil.showTargetError((class_1657)player, ModTexts.ITEM);
        }
    }

    public static void onEntityInventoryItemEditorUpdate(class_3222 player, EntityInventoryItemEditorPacket.Update response) {
        if (!PermissionLogic.hasPermission(player)) {
            CommonUtil.showPermissionError((class_1657)player, ModTexts.ITEM);
            return;
        }
        class_1297 class_12972 = player.method_37908().method_8469(response.getEntityId());
        if (class_12972 instanceof class_1263) {
            class_1263 container = (class_1263)class_12972;
            container.method_5447(response.getSlot(), response.getItemStack());
            CommonUtil.showUpdateSuccess((class_1657)player, ModTexts.ITEM);
        } else {
            CommonUtil.showTargetError((class_1657)player, ModTexts.ITEM);
        }
    }

    public static void onBlockEditorUpdate(class_3222 player, BlockEditorPacket.Update update) {
        if (!PermissionLogic.hasPermission(player)) {
            CommonUtil.showPermissionError((class_1657)player, ModTexts.BLOCK);
            return;
        }
        class_1937 level = player.method_37908();
        level.method_8501(update.getBlockPos(), update.getBlockState());
        class_2586 blockEntity = level.method_8321(update.getBlockPos());
        if (update.getTag() != null) {
            if (blockEntity == null) {
                CommonUtil.showTargetError((class_1657)player, ModTexts.BLOCK);
                return;
            }
            blockEntity.method_11014(update.getTag());
        }
        CommonUtil.showUpdateSuccess((class_1657)player, ModTexts.BLOCK);
    }

    public static void onEntityEditorUpdate(class_3222 player, EntityEditorPacket.Update update) {
        if (!PermissionLogic.hasPermission(player)) {
            CommonUtil.showPermissionError((class_1657)player, ModTexts.ENTITY);
            return;
        }
        class_1297 entity = player.method_37908().method_8469(update.getEntityId());
        if (entity != null) {
            entity.method_5651(update.getTag());
            CommonUtil.showUpdateSuccess((class_1657)player, ModTexts.ENTITY);
        } else {
            CommonUtil.showTargetError((class_1657)player, ModTexts.ENTITY);
        }
    }
}

