/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.gui.widget.favorites.panel;

import java.util.ArrayList;
import java.util.List;
import me.shedaniel.clothconfig2.ClothConfigInitializer;
import me.shedaniel.clothconfig2.api.LazyResettable;
import me.shedaniel.clothconfig2.api.ScissorsHandler;
import me.shedaniel.clothconfig2.api.animator.ProgressValueAnimator;
import me.shedaniel.clothconfig2.api.animator.ValueAnimator;
import me.shedaniel.clothconfig2.api.scroll.ScrollingContainer;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.favorites.FavoriteEntry;
import me.shedaniel.rei.api.client.favorites.FavoriteEntryType;
import me.shedaniel.rei.api.client.gui.drag.DraggableStack;
import me.shedaniel.rei.api.client.gui.widgets.WidgetWithBounds;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.util.CollectionUtils;
import me.shedaniel.rei.impl.client.gui.widget.favorites.FavoritesListWidget;
import me.shedaniel.rei.impl.client.gui.widget.favorites.panel.rows.FavoritesPanelEmptyRow;
import me.shedaniel.rei.impl.client.gui.widget.favorites.panel.rows.FavoritesPanelEntriesRow;
import me.shedaniel.rei.impl.client.gui.widget.favorites.panel.rows.FavoritesPanelRow;
import me.shedaniel.rei.impl.client.gui.widget.favorites.panel.rows.FavoritesPanelSectionRow;
import me.shedaniel.rei.impl.client.gui.widget.favorites.panel.rows.FavoritesPanelSeparatorRow;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_364;
import org.jetbrains.annotations.Nullable;

public class FavoritesPanel
extends WidgetWithBounds {
    private final FavoritesListWidget parent;
    public final ProgressValueAnimator<Boolean> expendState = ValueAnimator.ofBoolean((double)0.1, (boolean)false);
    private final Rectangle bounds = new Rectangle();
    private final Rectangle innerBounds = new Rectangle();
    private final LazyResettable<List<FavoritesPanelRow>> rows = new LazyResettable(() -> {
        ArrayList<FavoritesPanelRow> rows = new ArrayList<FavoritesPanelRow>();
        for (FavoriteEntryType.Section section : FavoriteEntryType.registry().sections()) {
            rows.add(new FavoritesPanelSectionRow(section.getText(), (class_2561)section.getText().method_27661().method_27694(style -> style.method_30938(Boolean.valueOf(true)))));
            rows.add(new FavoritesPanelEntriesRow(this, CollectionUtils.map(section.getEntries(), FavoriteEntry::copy)));
            rows.add(new FavoritesPanelSeparatorRow());
        }
        if (!rows.isEmpty()) {
            rows.remove(rows.size() - 1);
        }
        rows.add(new FavoritesPanelEmptyRow(4));
        return rows;
    });
    private final ScrollingContainer scroller = new ScrollingContainer(){

        public Rectangle getBounds() {
            return FavoritesPanel.this.innerBounds;
        }

        public int getMaxScrollHeight() {
            return Math.max(1, ((List)FavoritesPanel.this.rows.get()).stream().mapToInt(FavoritesPanelRow::getRowHeight).sum());
        }
    };

    public FavoritesPanel(FavoritesListWidget parent) {
        this.parent = parent;
    }

    public void resetRows() {
        this.rows.reset();
    }

    public void method_25394(class_332 graphics, int mouseX, int mouseY, float delta) {
        this.bounds.setBounds(this.updatePanelArea(this.parent.favoritesBounds));
        this.innerBounds.setBounds(this.bounds.x + 4, this.bounds.y + 4, this.bounds.width - 8, this.bounds.height - 20);
        this.expendState.update((double)delta);
        int buttonColor = 0xFFFFFF | Math.round(52.0f * Math.min((float)this.expendState.progress() * 2.0f, 1.0f)) << 24;
        graphics.method_25296(this.bounds.x, this.bounds.y, this.bounds.getMaxX(), this.bounds.getMaxY(), buttonColor, buttonColor);
        this.scroller.updatePosition(delta);
        if (((Boolean)this.expendState.value()).booleanValue()) {
            ScissorsHandler.INSTANCE.scissor(this.innerBounds);
            graphics.method_51448().method_22903();
            graphics.method_51448().method_22904(0.0, -this.scroller.scrollAmount(), 0.0);
            int y = this.innerBounds.y;
            for (FavoritesPanelRow row : (List)this.rows.get()) {
                row.render(graphics, this.innerBounds, this.innerBounds.x, y, this.innerBounds.width, row.getRowHeight(), mouseX, mouseY + this.scroller.scrollAmountInt(), delta);
                y += row.getRowHeight();
            }
            graphics.method_51448().method_22909();
            ScissorsHandler.INSTANCE.removeLastScissor();
        }
    }

    private Rectangle updatePanelArea(Rectangle fullArea) {
        int currentWidth = 16 + Math.round(Math.min((float)this.expendState.progress(), 1.0f) * (float)(fullArea.getWidth() - 16 - 8));
        int currentHeight = 16 + Math.round((float)this.expendState.progress() * ((float)fullArea.getHeight() * 0.4f - 16.0f - 8.0f + 4.0f));
        return new Rectangle(fullArea.x + 4, fullArea.getMaxY() - currentHeight - 4, currentWidth, currentHeight);
    }

    public boolean method_25401(double d, double e, double f) {
        if (this.innerBounds.contains(d, e)) {
            this.scroller.offset(ClothConfigInitializer.getScrollStep() * -f, true);
            return true;
        }
        return super.method_25401(d, e, f);
    }

    public List<? extends class_364> method_25396() {
        return (List)this.rows.get();
    }

    @Override
    public Rectangle getBounds() {
        return this.bounds;
    }

    public FavoritesListWidget getParent() {
        return this.parent;
    }

    public Rectangle getInnerBounds() {
        return this.innerBounds;
    }

    public double getScrolledAmount() {
        return this.scroller.scrollAmount();
    }

    public int getScrolledAmountInt() {
        return this.scroller.scrollAmountInt();
    }

    @Nullable
    public DraggableStack getHoveredStack(double mouseX, double mouseY) {
        for (FavoritesPanelRow row : (List)this.rows.get()) {
            FavoritesPanelEntriesRow entriesRow;
            DraggableStack hoveredStack;
            if (!(row instanceof FavoritesPanelEntriesRow) || (hoveredStack = (entriesRow = (FavoritesPanelEntriesRow)row).getHoveredStack(mouseX, mouseY)) == null) continue;
            return hoveredStack;
        }
        return null;
    }

    @Nullable
    public EntryStack<?> getFocusedStack(Point mouse) {
        for (FavoritesPanelRow row : (List)this.rows.get()) {
            FavoritesPanelEntriesRow entriesRow;
            EntryStack<?> focusedStack;
            if (!(row instanceof FavoritesPanelEntriesRow) || (focusedStack = (entriesRow = (FavoritesPanelEntriesRow)row).getFocusedStack(mouse)) == null) continue;
            return focusedStack;
        }
        return null;
    }
}

