/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.shaderpack.option.values;

import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.coderbot.iris.shaderpack.OptionalBoolean;
import net.coderbot.iris.shaderpack.option.OptionSet;
import net.coderbot.iris.shaderpack.option.values.MutableOptionValues;
import net.coderbot.iris.shaderpack.option.values.OptionValues;

public class ImmutableOptionValues
implements OptionValues {
    private final OptionSet options;
    private final ImmutableMap<String, Boolean> booleanValues;
    private final ImmutableMap<String, String> stringValues;

    ImmutableOptionValues(OptionSet optionSet, ImmutableMap<String, Boolean> immutableMap, ImmutableMap<String, String> immutableMap2) {
        this.options = optionSet;
        this.booleanValues = immutableMap;
        this.stringValues = immutableMap2;
    }

    @Override
    public OptionalBoolean getBooleanValue(String string) {
        if (this.booleanValues.containsKey((Object)string)) {
            return (Boolean)this.booleanValues.get((Object)string) != false ? OptionalBoolean.TRUE : OptionalBoolean.FALSE;
        }
        return OptionalBoolean.DEFAULT;
    }

    @Override
    public Optional<String> getStringValue(String string) {
        return Optional.ofNullable((String)this.stringValues.get((Object)string));
    }

    @Override
    public int getOptionsChanged() {
        return this.stringValues.size() + this.booleanValues.size();
    }

    @Override
    public MutableOptionValues mutableCopy() {
        return new MutableOptionValues(this.options, new HashMap<String, Boolean>((Map<String, Boolean>)this.booleanValues), new HashMap<String, String>((Map<String, String>)this.stringValues));
    }

    @Override
    public ImmutableOptionValues toImmutable() {
        return this;
    }

    @Override
    public OptionSet getOptionSet() {
        return this.options;
    }
}

