/*
 * Decompiled with CFR 0.152.
 */
package io.github.sjouwer.pickblockpro.config;

import io.github.sjouwer.pickblockpro.picker.ToolPicker;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.shedaniel.autoconfig.ConfigData;
import me.shedaniel.autoconfig.annotation.Config;
import me.shedaniel.autoconfig.annotation.ConfigEntry;
import net.minecraft.class_1310;
import net.minecraft.class_1887;
import net.minecraft.class_1893;

@Config(name="pickblockpro/config")
public class ModConfig
implements ConfigData {
    @ConfigEntry.Gui.TransitiveObject
    @ConfigEntry.Category(value="block_picker_settings")
    private BlockPicker blockPicker = new BlockPicker();
    @ConfigEntry.Gui.TransitiveObject
    @ConfigEntry.Category(value="id_picker_settings")
    private IdPicker idPicker = new IdPicker();
    @ConfigEntry.Gui.TransitiveObject
    @ConfigEntry.Category(value="tool_picker_settings")
    private ToolPicker toolPicker = new ToolPicker();
    @ConfigEntry.Gui.TransitiveObject
    @ConfigEntry.Category(value="inventory_settings")
    private Inventory inventory = new Inventory();

    public int blockPickRange() {
        return this.blockPicker.range;
    }

    public boolean blockPickBlocks() {
        return this.blockPicker.pickBlocks;
    }

    public boolean blockPickEntities() {
        return this.blockPicker.pickEntities;
    }

    public boolean blockPickFluids() {
        return this.blockPicker.pickFluids;
    }

    public boolean blockPickLight() {
        return this.blockPicker.pickLight;
    }

    public List<String> blockStateTagBlacklist() {
        return Arrays.asList(this.blockPicker.blockStateTagBlacklist.split("\\s*,\\s*"));
    }

    public List<String> blockEntityTagBlacklist() {
        return Arrays.asList(this.blockPicker.blockEntityTagBlacklist.split("\\s*,\\s*"));
    }

    public List<String> entityTagBlacklist() {
        return Arrays.asList(this.blockPicker.entityTagBlacklist.split("\\s*,\\s*"));
    }

    public int idPickRange() {
        return this.idPicker.range;
    }

    public boolean idPickBlocks() {
        return this.idPicker.pickBlocks;
    }

    public boolean idPickEntities() {
        return this.idPicker.pickEntities;
    }

    public boolean idPickFluids() {
        return this.idPicker.pickFluids;
    }

    public boolean addNamespace() {
        return this.idPicker.addNamespace;
    }

    public boolean addProperties() {
        return this.idPicker.addProperties;
    }

    public boolean copyToClipboard() {
        return this.idPicker.copyToClipboard;
    }

    public boolean hotbarPickerEnabled() {
        return this.idPicker.enableHotbarPicker;
    }

    public boolean tagPickerEnabled() {
        return this.idPicker.enableTagPicker;
    }

    public boolean prettyTagEnabled() {
        return this.idPicker.enablePrettyTags;
    }

    public List<String> blockStateTagIdBlacklist() {
        return Arrays.asList(this.idPicker.blockStateTagBlacklist.split("\\s*,\\s*"));
    }

    public List<String> blockEntityTagIdBlacklist() {
        return Arrays.asList(this.idPicker.blockEntityTagBlacklist.split("\\s*,\\s*"));
    }

    public List<String> entityTagIdBlacklist() {
        return Arrays.asList(this.idPicker.entityTagBlacklist.split("\\s*,\\s*"));
    }

    public int toolPickRange() {
        return this.toolPicker.range;
    }

    public boolean toolPickFluids() {
        return this.toolPicker.pickFluids;
    }

    public boolean preferSilkTouch() {
        return this.toolPicker.preferSilkTouch;
    }

    public boolean preferEfficiency() {
        return this.toolPicker.preferEfficiency;
    }

    public boolean preferSwordForBamboo() {
        return this.toolPicker.preferSwordForBamboo;
    }

    public Map<class_1887, Integer> getEnchantments(ToolPicker.Tools tool, class_1310 eGroup) {
        if (!this.toolPicker.enchantTools) {
            return Collections.emptyMap();
        }
        HashMap<class_1887, Integer> enchantments = new HashMap<class_1887, Integer>();
        switch (tool) {
            case PICKAXE: {
                this.getExtendedEnchantments(this.toolPicker.pickaxeEnchantments, enchantments);
                break;
            }
            case AXE: {
                this.getExtendedEnchantments(this.toolPicker.axeEnchantments, enchantments);
                break;
            }
            case SHOVEL: {
                this.getExtendedEnchantments(this.toolPicker.shovelEnchantments, enchantments);
                break;
            }
            case HOE: {
                this.getExtendedEnchantments(this.toolPicker.hoeEnchantments, enchantments);
                break;
            }
            case SHEARS: {
                this.getBaseEnchantments(this.toolPicker.shearEnchantments, enchantments);
                break;
            }
            case SWORD: {
                this.getSwordEnchantments(this.toolPicker.swordEnchantments, enchantments, eGroup);
            }
        }
        return enchantments;
    }

    private void getBaseEnchantments(BaseEnchantments base, HashMap<class_1887, Integer> enchantments) {
        if (base.efficiency > 0) {
            enchantments.put(class_1893.field_9131, Math.min(base.efficiency, 255));
        }
        if (base.unbreaking > 0) {
            enchantments.put(class_1893.field_9119, Math.min(base.unbreaking, 255));
        }
        if (base.mending) {
            enchantments.put(class_1893.field_9101, 1);
        }
    }

    private void getExtendedEnchantments(ExtendedEnchantments extended, HashMap<class_1887, Integer> enchantments) {
        this.getBaseEnchantments(extended.base, enchantments);
        if (extended.silkTouch && (extended.fortune <= 0 || this.toolPicker.preferSilkTouch)) {
            enchantments.put(class_1893.field_9099, 1);
        } else if (extended.fortune > 0) {
            enchantments.put(class_1893.field_9130, Math.min(extended.fortune, 255));
        }
    }

    private void getSwordEnchantments(SwordEnchantments sword, HashMap<class_1887, Integer> enchantments, class_1310 eGroup) {
        if (sword.unbreaking > 0) {
            enchantments.put(class_1893.field_9119, Math.min(sword.unbreaking, 255));
        }
        if (sword.sweeping > 0) {
            enchantments.put(class_1893.field_9115, Math.min(sword.sweeping, 255));
        }
        if (sword.looting > 0) {
            enchantments.put(class_1893.field_9110, Math.min(sword.looting, 255));
        }
        if (sword.fireAspect > 0) {
            enchantments.put(class_1893.field_9124, Math.min(sword.fireAspect, 255));
        }
        if (sword.knockback > 0) {
            enchantments.put(class_1893.field_9121, Math.min(sword.knockback, 255));
        }
        if (sword.mending) {
            enchantments.put(class_1893.field_9101, 1);
        }
        if (sword.bane > 0 && eGroup != null && eGroup.equals(class_1310.field_6293)) {
            enchantments.put(class_1893.field_9112, Math.min(sword.bane, 255));
        } else if (sword.smite > 0 && eGroup != null && eGroup.equals(class_1310.field_6289)) {
            enchantments.put(class_1893.field_9123, Math.min(sword.smite, 255));
        } else if (sword.sharpness > 0) {
            enchantments.put(class_1893.field_9118, Math.min(sword.sharpness, 255));
        }
    }

    public boolean searchContainers() {
        return this.inventory.searchThroughContainers;
    }

    public boolean isSlotLocked(int slot) {
        return switch (slot) {
            case 0 -> this.inventory.lockedSlots.slot1;
            case 1 -> this.inventory.lockedSlots.slot2;
            case 2 -> this.inventory.lockedSlots.slot3;
            case 3 -> this.inventory.lockedSlots.slot4;
            case 4 -> this.inventory.lockedSlots.slot5;
            case 5 -> this.inventory.lockedSlots.slot6;
            case 6 -> this.inventory.lockedSlots.slot7;
            case 7 -> this.inventory.lockedSlots.slot8;
            case 8 -> this.inventory.lockedSlots.slot9;
            default -> false;
        };
    }

    static class BlockPicker {
        @ConfigEntry.Gui.Tooltip
        private int range = 100;
        @ConfigEntry.Gui.Tooltip
        private boolean pickBlocks = true;
        @ConfigEntry.Gui.Tooltip
        private boolean pickEntities = true;
        @ConfigEntry.Gui.Tooltip
        private boolean pickFluids = false;
        @ConfigEntry.Gui.Tooltip
        private boolean pickLight = true;
        @ConfigEntry.Gui.Tooltip
        private String blockStateTagBlacklist = "waterlogged";
        @ConfigEntry.Gui.Tooltip
        private String blockEntityTagBlacklist = "";
        @ConfigEntry.Gui.Tooltip
        private String entityTagBlacklist = "UUID, Pos, TileX, TileY, TileZ, Facing, facing, Rotation, Leash";

        BlockPicker() {
        }
    }

    static class IdPicker {
        @ConfigEntry.Gui.Tooltip
        private int range = 100;
        @ConfigEntry.Gui.Tooltip
        private boolean pickBlocks = true;
        @ConfigEntry.Gui.Tooltip
        private boolean pickEntities = true;
        @ConfigEntry.Gui.Tooltip
        private boolean pickFluids = false;
        @ConfigEntry.Gui.Tooltip
        private boolean addNamespace = false;
        @ConfigEntry.Gui.Tooltip
        private boolean addProperties = true;
        @ConfigEntry.Gui.Tooltip
        private boolean copyToClipboard = true;
        @ConfigEntry.Gui.Tooltip
        private boolean enableHotbarPicker = true;
        @ConfigEntry.Gui.Tooltip
        private boolean enableTagPicker = true;
        @ConfigEntry.Gui.Tooltip
        private boolean enablePrettyTags = true;
        @ConfigEntry.Gui.Tooltip
        private String blockStateTagBlacklist = "";
        @ConfigEntry.Gui.Tooltip
        private String blockEntityTagBlacklist = "";
        @ConfigEntry.Gui.Tooltip
        private String entityTagBlacklist = "";

        IdPicker() {
        }
    }

    static class ToolPicker {
        @ConfigEntry.Gui.Tooltip
        private int range = 100;
        @ConfigEntry.Gui.Tooltip
        private boolean pickFluids = false;
        @ConfigEntry.Gui.Tooltip
        private boolean preferSilkTouch = true;
        @ConfigEntry.Gui.Tooltip
        private boolean preferEfficiency = false;
        @ConfigEntry.Gui.Tooltip
        private boolean preferSwordForBamboo = true;
        @ConfigEntry.Gui.Tooltip
        private boolean enchantTools = true;
        @ConfigEntry.Gui.CollapsibleObject
        private ExtendedEnchantments pickaxeEnchantments = new ExtendedEnchantments();
        @ConfigEntry.Gui.CollapsibleObject
        private ExtendedEnchantments axeEnchantments = new ExtendedEnchantments();
        @ConfigEntry.Gui.CollapsibleObject
        private ExtendedEnchantments shovelEnchantments = new ExtendedEnchantments();
        @ConfigEntry.Gui.CollapsibleObject
        private ExtendedEnchantments hoeEnchantments = new ExtendedEnchantments();
        @ConfigEntry.Gui.CollapsibleObject
        private BaseEnchantments shearEnchantments = new BaseEnchantments();
        @ConfigEntry.Gui.CollapsibleObject
        private SwordEnchantments swordEnchantments = new SwordEnchantments();

        ToolPicker() {
        }
    }

    static class Inventory {
        @ConfigEntry.Gui.Tooltip
        private boolean searchThroughContainers = true;
        @ConfigEntry.Gui.CollapsibleObject(startExpanded=true)
        @ConfigEntry.Gui.Tooltip
        private LockedSlots lockedSlots = new LockedSlots();

        Inventory() {
        }
    }

    static class ExtendedEnchantments {
        @ConfigEntry.Gui.TransitiveObject
        private BaseEnchantments base = new BaseEnchantments();
        @ConfigEntry.Gui.Tooltip
        private boolean silkTouch = true;
        @ConfigEntry.Gui.Tooltip
        private int fortune = 3;

        ExtendedEnchantments() {
        }
    }

    static class BaseEnchantments {
        private int unbreaking = 3;
        private int efficiency = 5;
        private boolean mending = true;

        BaseEnchantments() {
        }
    }

    static class SwordEnchantments {
        private int unbreaking = 3;
        private int sharpness = 5;
        @ConfigEntry.Gui.Tooltip
        private int bane = 5;
        @ConfigEntry.Gui.Tooltip
        private int smite = 5;
        private int sweeping = 3;
        private int looting = 3;
        private int fireAspect = 0;
        private int knockback = 0;
        private boolean mending = true;

        SwordEnchantments() {
        }
    }

    static class LockedSlots {
        private boolean slot1 = false;
        private boolean slot2 = false;
        private boolean slot3 = false;
        private boolean slot4 = false;
        private boolean slot5 = false;
        private boolean slot6 = false;
        private boolean slot7 = false;
        private boolean slot8 = false;
        private boolean slot9 = false;

        LockedSlots() {
        }
    }
}

