/*
 * Decompiled with CFR 0.152.
 */
package io.github.sjouwer.pickblockpro.picker;

import io.github.sjouwer.pickblockpro.PickBlockPro;
import io.github.sjouwer.pickblockpro.config.ModConfig;
import io.github.sjouwer.pickblockpro.config.PickBlockOverrides;
import io.github.sjouwer.pickblockpro.util.InfoProvider;
import io.github.sjouwer.pickblockpro.util.InventoryManager;
import io.github.sjouwer.pickblockpro.util.NbtUtil;
import io.github.sjouwer.pickblockpro.util.Raycast;
import java.util.Optional;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1533;
import net.minecraft.class_1534;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_2338;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_5915;

public class BlockPicker {
    private static final class_310 client = class_310.method_1551();
    private static final ModConfig config = PickBlockPro.getConfig();

    private BlockPicker() {
    }

    public static void pickBlock() {
        int distance;
        if (BlockPicker.client.field_1724 == null || BlockPicker.client.field_1687 == null) {
            PickBlockPro.LOGGER.error("Pick Block called outside of play; no world and/or player");
            return;
        }
        if (!config.blockPickEntities() && !config.blockPickBlocks()) {
            InfoProvider.sendError(class_2561.method_43471((String)"text.pick_block_pro.message.nothingToPick"));
            return;
        }
        class_239 hit = Raycast.getHit(config.blockPickRange(), !config.blockPickFluids(), !config.blockPickEntities());
        class_1799 item = null;
        if (hit.method_17783() == class_239.class_240.field_1331) {
            item = BlockPicker.getEntityItemStack(hit);
        }
        if (hit.method_17783() == class_239.class_240.field_1332 && config.blockPickBlocks()) {
            item = BlockPicker.getBlockItemStack(hit);
        }
        if (hit.method_17783() == class_239.class_240.field_1333 && config.blockPickLight() && (hit = Raycast.getHit(distance = (Integer)BlockPicker.client.field_1690.method_42503().method_41753() * 32, !config.blockPickFluids(), false)).method_17783() == class_239.class_240.field_1333) {
            item = BlockPicker.getLightFromSunOrMoon();
        }
        if (item != null) {
            InventoryManager.placeItemInsideInventory(item);
        }
    }

    private static class_1799 getEntityItemStack(class_239 hit) {
        class_1297 entity = ((class_3966)hit).method_17782();
        class_1799 item = PickBlockOverrides.getEntityOverride(entity.method_5864());
        if (item == null) {
            item = entity.method_31480();
        }
        if (item != null && BlockPicker.client.field_1724.method_31549().field_7477 && class_437.method_25441()) {
            if (entity instanceof class_1533) {
                class_1533 itemFrame = (class_1533)entity;
                item = BlockPicker.createFramedItemStack(itemFrame);
            } else if (entity instanceof class_1534) {
                class_1534 paintingEntity = (class_1534)entity;
                item = BlockPicker.createPaintingVariantStack(paintingEntity);
            } else {
                NbtUtil.addEntityNbt(item, entity, true);
            }
        }
        if (entity instanceof class_1657) {
            class_1657 player = (class_1657)entity;
            item = new class_1799((class_1935)class_1802.field_8575);
            NbtUtil.setSkullOwner(item, player);
        }
        return item;
    }

    private static class_1799 createFramedItemStack(class_1533 itemFrame) {
        class_1799 itemFrameStack = new class_1799((class_1935)(itemFrame instanceof class_5915 ? class_1802.field_28408 : class_1802.field_8143));
        class_1799 framedItem = itemFrame.method_6940();
        if (framedItem.method_31574(class_1802.field_8162)) {
            return itemFrameStack;
        }
        class_5250 name = class_2561.method_43469((String)"text.pick_block_pro.name.framed", (Object[])new Object[]{framedItem.method_7964()});
        name.method_10862(class_2583.field_24360.method_10978(Boolean.valueOf(false)).method_10977(class_124.field_1054));
        itemFrameStack.method_7977((class_2561)name);
        NbtUtil.addEntityNbt(itemFrameStack, (class_1297)itemFrame, false);
        return itemFrameStack;
    }

    private static class_1799 createPaintingVariantStack(class_1534 painting) {
        class_1799 paintingStack = new class_1799((class_1935)class_1802.field_8892);
        Optional key = painting.method_43404().method_40230();
        if (key.isPresent()) {
            String translationKey = ((class_5321)key.get()).method_29177().method_48747("painting", "title");
            class_5250 name = class_2561.method_43471((String)translationKey);
            name.method_10862(class_2583.field_24360.method_10978(Boolean.valueOf(false)).method_10977(class_124.field_1054));
            paintingStack.method_7977((class_2561)name);
        }
        NbtUtil.addEntityNbt(paintingStack, (class_1297)painting, false);
        return paintingStack;
    }

    private static class_1799 getBlockItemStack(class_239 hit) {
        class_2338 blockPos = ((class_3965)hit).method_17777();
        class_2680 state = BlockPicker.client.field_1687.method_8320(blockPos);
        class_1799 item = PickBlockOverrides.getBlockOverride(state.method_26204());
        if (item == null) {
            item = state.method_26204().method_9574((class_1922)BlockPicker.client.field_1687, blockPos, state);
        }
        if (item.method_7960()) {
            return null;
        }
        if (BlockPicker.client.field_1724.method_31549().field_7477) {
            if (class_437.method_25441() && state.method_31709()) {
                class_2586 blockEntity = BlockPicker.client.field_1687.method_8321(blockPos);
                NbtUtil.addBlockEntityNbt(item, blockEntity, true);
            }
            if (class_437.method_25443()) {
                NbtUtil.addBlockStateNbt(item, state, true);
            }
        }
        return item;
    }

    private static class_1799 getLightFromSunOrMoon() {
        double skyAngle = (double)BlockPicker.client.field_1687.method_30274(client.method_1488()) + 0.25;
        if (skyAngle > 1.0) {
            skyAngle -= 1.0;
        }
        skyAngle *= 360.0;
        class_243 playerVector = BlockPicker.client.field_1724.method_5828(client.method_1488());
        double playerAngle = Math.atan2(playerVector.field_1351, playerVector.field_1352) * 180.0 / Math.PI;
        if (playerAngle < 0.0) {
            playerAngle += 360.0;
        }
        double angleDifference = skyAngle - playerAngle;
        if (Math.abs(playerVector.field_1350) < 0.076 && Math.abs(angleDifference) < 4.3) {
            return BlockPicker.giveOrCycleLight(15);
        }
        if (Math.abs(playerVector.field_1350) < 0.051 && Math.abs(angleDifference - 180.0) < 3.0) {
            return BlockPicker.giveOrCycleLight(7);
        }
        return null;
    }

    private static class_1799 giveOrCycleLight(int lightLvl) {
        class_1799 mainHandStack = BlockPicker.client.field_1724.method_6047();
        if (mainHandStack.method_31574(class_1802.field_30904)) {
            NbtUtil.cycleLightLevel(mainHandStack);
            class_1661 inventory = BlockPicker.client.field_1724.method_31548();
            inventory.method_5447(inventory.field_7545, mainHandStack);
            InventoryManager.updateCreativeSlot(inventory.field_7545);
            return null;
        }
        class_1799 light = new class_1799((class_1935)class_1802.field_30904);
        NbtUtil.setLightLevel(light, lightLvl);
        return light;
    }
}

