/*
 * Decompiled with CFR 0.152.
 */
package io.github.sjouwer.pickblockpro.picker;

import io.github.sjouwer.pickblockpro.PickBlockPro;
import io.github.sjouwer.pickblockpro.config.ModConfig;
import io.github.sjouwer.pickblockpro.util.InfoProvider;
import io.github.sjouwer.pickblockpro.util.NbtUtil;
import io.github.sjouwer.pickblockpro.util.Raycast;
import java.util.StringJoiner;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_239;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_7923;

public class IdPicker {
    private static final class_310 client = class_310.method_1551();
    private static final ModConfig config = PickBlockPro.getConfig();

    private IdPicker() {
    }

    public static void pickId() {
        if (IdPicker.client.field_1724 == null || IdPicker.client.field_1687 == null) {
            PickBlockPro.LOGGER.error("Pick ID called outside of play; no world and/or player");
            return;
        }
        if (!config.idPickEntities() && !config.idPickBlocks()) {
            InfoProvider.sendError(class_2561.method_43471((String)"text.pick_block_pro.message.nothingToPick"));
            return;
        }
        class_239 hit = Raycast.getHit(config.idPickRange(), !config.idPickFluids(), !config.idPickEntities());
        class_5250 id = class_2561.method_43473();
        if (hit instanceof class_3966) {
            class_3966 entityHit = (class_3966)hit;
            id = IdPicker.getEntityDataAsText(entityHit.method_17782());
        }
        if (hit instanceof class_3965) {
            class_3965 blockHit = (class_3965)hit;
            if (config.idPickBlocks()) {
                id = IdPicker.getBlockDataAsText(blockHit.method_17777());
            }
        }
        if (id.getString().isEmpty()) {
            return;
        }
        if (config.copyToClipboard()) {
            IdPicker.client.field_1774.method_1455(id.getString());
            InfoProvider.sendMessage((class_2561)class_2561.method_43471((String)"text.pick_block_pro.message.copied").method_27692(class_124.field_1077));
        }
        InfoProvider.sendMessage((class_2561)id);
    }

    private static class_2561 getEntityDataAsText(class_1297 entity) {
        return class_437.method_25441() && config.tagPickerEnabled() ? IdPicker.getEntityTag(entity) : IdPicker.getEntityId(entity);
    }

    private static class_2561 getBlockDataAsText(class_2338 blockPos) {
        class_2680 blockState = IdPicker.client.field_1687.method_8320(blockPos);
        if (class_437.method_25441() && config.tagPickerEnabled() && blockState.method_31709()) {
            class_2586 blockEntity = IdPicker.client.field_1687.method_8321(blockPos);
            return IdPicker.getBlockEntityTag(blockEntity);
        }
        return IdPicker.getBlockId(blockState);
    }

    public static class_2561 getBlockId(class_2680 blockState) {
        String fullId = class_7923.field_41175.method_10221((Object)blockState.method_26204()).toString();
        if (!config.addNamespace()) {
            fullId = fullId.substring(fullId.indexOf(":") + 1);
        }
        if (config.addProperties() && !blockState.method_28501().isEmpty()) {
            return class_2561.method_43470((String)fullId).method_10852(IdPicker.getBlockStateTag(blockState));
        }
        return class_2561.method_43470((String)fullId);
    }

    public static class_2561 getBlockStateTag(class_2680 blockState) {
        class_2487 stateTag = NbtUtil.getBlockStateNbt(blockState);
        config.blockStateTagIdBlacklist().forEach(arg_0 -> ((class_2487)stateTag).method_10551(arg_0));
        return class_2561.method_43470((String)IdPicker.convertBlockStateTag(stateTag));
    }

    public static class_2561 getBlockEntityTag(class_2586 blockEntity) {
        class_2487 tag = blockEntity.method_38244();
        config.blockEntityTagIdBlacklist().forEach(arg_0 -> ((class_2487)tag).method_10551(arg_0));
        return config.prettyTagEnabled() ? class_2512.method_32270((class_2520)tag) : class_2561.method_43470((String)tag.toString());
    }

    public static class_2561 getEntityId(class_1297 entity) {
        String fullId = class_7923.field_41177.method_10221((Object)entity.method_5864()).toString();
        if (!config.addNamespace() && fullId.contains(":")) {
            fullId = fullId.substring(fullId.indexOf(":") + 1);
        }
        return class_2561.method_43470((String)fullId);
    }

    public static class_2561 getEntityTag(class_1297 entity) {
        class_2487 entityTag = NbtUtil.getEntityNbt(entity);
        config.entityTagIdBlacklist().forEach(arg_0 -> ((class_2487)entityTag).method_10551(arg_0));
        return config.prettyTagEnabled() ? class_2512.method_32270((class_2520)entityTag) : class_2561.method_43470((String)entityTag.toString());
    }

    public static String getItemId(class_1799 itemStack) {
        class_2487 stateTag;
        ModConfig config = PickBlockPro.getConfig();
        StringBuilder fullId = new StringBuilder();
        if (config.addNamespace()) {
            fullId.append(class_7923.field_41178.method_10221((Object)itemStack.method_7909()).method_12836());
            fullId.append(":");
        }
        fullId.append(itemStack.method_7909());
        if (config.addProperties() && (stateTag = itemStack.method_7941("BlockStateTag")) != null) {
            fullId.append(IdPicker.convertBlockStateTag(stateTag));
        }
        return fullId.toString();
    }

    private static String convertBlockStateTag(class_2487 stateTag) {
        StringBuilder properties = new StringBuilder();
        StringJoiner stateJoiner = new StringJoiner(",");
        for (String key : stateTag.method_10541()) {
            stateJoiner.add(key + "=" + stateTag.method_10558(key));
        }
        properties.append("[");
        properties.append(stateJoiner);
        properties.append("]");
        return properties.toString();
    }
}

