/*
 * Decompiled with CFR 0.152.
 */
package io.github.sjouwer.pickblockpro.util;

import io.github.sjouwer.pickblockpro.PickBlockPro;
import io.github.sjouwer.pickblockpro.config.ModConfig;
import io.github.sjouwer.pickblockpro.util.InfoProvider;
import io.github.sjouwer.pickblockpro.util.NbtUtil;
import net.minecraft.class_1661;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_310;

public final class InventoryManager {
    private static final class_310 client = class_310.method_1551();
    private static final ModConfig config = PickBlockPro.getConfig();

    private InventoryManager() {
    }

    public static void placeItemInsideInventory(class_1799 item) {
        if (InventoryManager.client.field_1761 == null || InventoryManager.client.field_1724 == null) {
            PickBlockPro.LOGGER.error("Unable to place item inside inventory; no player and/or interaction manager");
            return;
        }
        boolean isCreative = InventoryManager.client.field_1724.method_31549().field_7477;
        class_1661 inventory = InventoryManager.client.field_1724.method_31548();
        int stackSlot = inventory.method_7395(item);
        if (config.searchContainers() && stackSlot == -1 && !isCreative) {
            stackSlot = InventoryManager.searchThroughContainers(inventory, item.method_7909());
        }
        if (stackSlot > -1 && stackSlot < 9) {
            inventory.field_7545 = stackSlot;
            return;
        }
        if ((stackSlot > 8 || isCreative) && !InventoryManager.setOptimalSlot(inventory)) {
            return;
        }
        if (stackSlot > 8) {
            InventoryManager.client.field_1761.method_2916(stackSlot);
            return;
        }
        if (isCreative) {
            int currentSlot = inventory.field_7545;
            int emptySlot = inventory.method_7376();
            inventory.method_7374(item);
            InventoryManager.updateCreativeSlot(currentSlot);
            if (emptySlot > 8) {
                InventoryManager.updateCreativeSlot(emptySlot);
            }
        }
    }

    private static int searchThroughContainers(class_1661 inventory, class_1792 item) {
        int slot = -1;
        int highestAmount = 0;
        for (int i = 0; i < inventory.field_7547.size(); ++i) {
            int storedAmount;
            class_1799 invStack = inventory.method_5438(i);
            if (invStack.method_7960() || (storedAmount = NbtUtil.getAmountStored(invStack, item)) <= highestAmount) continue;
            slot = i;
            highestAmount = storedAmount;
        }
        return slot;
    }

    private static boolean setOptimalSlot(class_1661 inventory) {
        int tries;
        int slot = inventory.field_7545;
        for (tries = 0; !inventory.method_5438(slot).method_7960() && tries < 9; ++tries) {
            if (++slot <= 8) continue;
            slot = 0;
        }
        if (tries == 9 && (slot = InventoryManager.findUnlockedSlot(inventory)) > 8) {
            InfoProvider.sendError(class_2561.method_43471((String)"text.pick_block_pro.message.allSlotsLocked"));
            return false;
        }
        inventory.field_7545 = slot;
        InventoryManager.client.field_1761.method_2927();
        return true;
    }

    private static int findUnlockedSlot(class_1661 inventory) {
        int selectedSlot;
        ModConfig config = PickBlockPro.getConfig();
        if (config.isSlotLocked(selectedSlot = inventory.field_7545)) {
            for (selectedSlot = 0; config.isSlotLocked(selectedSlot) && selectedSlot < 35; ++selectedSlot) {
            }
        }
        return selectedSlot;
    }

    public static void updateCreativeSlot(int slot) {
        if (InventoryManager.client.field_1761 == null || InventoryManager.client.field_1724 == null) {
            PickBlockPro.LOGGER.error("Unable to update inventory slot; no player and/or interaction manager");
            return;
        }
        if (slot < 0) {
            return;
        }
        class_1799 item = InventoryManager.client.field_1724.method_31548().method_5438(slot);
        if (slot < 9) {
            slot = 36 + slot;
        }
        InventoryManager.client.field_1761.method_2909(item, slot);
    }
}

