/*
 * Decompiled with CFR 0.152.
 */
package com.ddwhm.jesen.imblocker.immanager.linux;

import com.ddwhm.jesen.imblocker.ImBlocker;
import com.ddwhm.jesen.imblocker.immanager.ImManager;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class LinuxImManager
implements ImManager {
    private boolean status = true;

    private native void disableIme();

    private native void enableIme();

    private static void loadJNI() throws IOException {
        int length;
        InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream("native/linux/immanager.so");
        if (is == null) {
            throw new IOException("Can't open native/linux/immanager.so");
        }
        File file = File.createTempFile("lib", ".so");
        FileOutputStream os = new FileOutputStream(file);
        byte[] buffer = new byte[1024];
        while ((length = is.read(buffer)) != -1) {
            ((OutputStream)os).write(buffer, 0, length);
        }
        is.close();
        ((OutputStream)os).close();
        System.load(file.getAbsolutePath());
        file.deleteOnExit();
    }

    @Override
    public void makeOn() {
        ImBlocker.LOGGER.debug("status:{} makeOn", (Object)this.status);
        if (this.status) {
            return;
        }
        this.status = true;
        this.enableIme();
    }

    @Override
    public void makeOff() {
        ImBlocker.LOGGER.debug("status:{} makeOff", (Object)this.status);
        if (!this.status) {
            return;
        }
        this.status = false;
        this.disableIme();
    }

    @Override
    public boolean getStatus() {
        return this.status;
    }

    static {
        try {
            LinuxImManager.loadJNI();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

